/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.bmp;

import com.sun.media.imageioimpl.plugins.bmp.BMPImageReader;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class BMPImageReaderSpi
extends ImageReaderSpi {
    private static String[] writerSpiNames = new String[]{"com.sun.media.imageioimpl.bmp.BMPImageWriterSpi"};
    private static String[] formatNames = new String[]{"bmp", "BMP"};
    private static String[] entensions = new String[]{"bmp"};
    private static String[] mimeType = new String[]{"image/bmp"};
    private boolean registered = false;

    public BMPImageReaderSpi() {
        super("Sun Microsystems, Inc.", "0.5", formatNames, entensions, mimeType, "com.sun.media.imageioimpl.bmp.BMPImageWriter", ImageReaderSpi.STANDARD_INPUT_TYPE, writerSpiNames, false, null, null, null, null, true, "com_sun_media_imageio_plugins_bmp_image_1.0", "com.sun.media.imageioimpl.plugins.bmp.BMPMetadataFormat", null, null);
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        if (this.registered) {
            return;
        }
        this.registered = true;
    }

    public String getDescription(Locale locale) {
        return "Standard BMP Image Reader";
    }

    public boolean canDecodeInput(Object source) throws IOException {
        if (!(source instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream stream = (ImageInputStream)source;
        byte[] b2 = new byte[2];
        stream.mark();
        stream.readFully(b2);
        stream.reset();
        return b2[0] == 66 && b2[1] == 77;
    }

    public ImageReader createReaderInstance(Object extension) throws IIOException {
        return new BMPImageReader(this);
    }
}

