/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.bmp;

import com.sun.media.imageio.plugins.bmp.BMPImageWriteParam;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.bmp.BMPConstants;
import com.sun.media.imageioimpl.plugins.bmp.I18N;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class BMPImageWriter
extends ImageWriter
implements BMPConstants {
    private ImageOutputStream stream = null;
    private int version;
    private int compressionType;
    private boolean isTopDown;
    private int w;
    private int h;
    private int compImageSize = 0;
    private int[] bitPos;
    private byte[] bpixels;
    private short[] spixels;
    private int[] ipixels;

    public BMPImageWriter(ImageWriterSpi originator) {
        super(originator);
    }

    public void setOutput(Object output) {
        super.setOutput(output);
        if (output != null) {
            if (!(output instanceof ImageOutputStream)) {
                throw new IllegalArgumentException(I18N.getString("BMPImageWriter0"));
            }
            this.stream = (ImageOutputStream)output;
            this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.stream = null;
        }
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new BMPImageWriteParam();
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata metadata, ImageTypeSpecifier type, ImageWriteParam param) {
        return null;
    }

    public boolean canWriteRasters() {
        return true;
    }

    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        int i;
        this.clearAbortRequest();
        this.processImageStarted(0);
        if (param == null) {
            param = this.getDefaultWriteParam();
        }
        BMPImageWriteParam bmpParam = (BMPImageWriteParam)param;
        int bitsPerPixel = 24;
        boolean isPalette = false;
        int paletteEntries = 0;
        IndexColorModel icm = null;
        RenderedImage input = null;
        Raster inputRaster = null;
        boolean writeRaster = image.hasRaster();
        Rectangle sourceRegion = param.getSourceRegion();
        SampleModel sampleModel = null;
        ColorModel colorModel = null;
        if (writeRaster) {
            inputRaster = image.getRaster();
            sampleModel = inputRaster.getSampleModel();
            colorModel = ImageUtil.createColorModel(null, sampleModel);
            sourceRegion = sourceRegion == null ? inputRaster.getBounds() : sourceRegion.intersection(inputRaster.getBounds());
        } else {
            input = image.getRenderedImage();
            sampleModel = input.getSampleModel();
            colorModel = input.getColorModel();
            Rectangle rect = new Rectangle(input.getMinX(), input.getMinY(), input.getWidth(), input.getHeight());
            sourceRegion = sourceRegion == null ? rect : sourceRegion.intersection(rect);
        }
        if (sourceRegion.isEmpty()) {
            throw new RuntimeException(I18N.getString("BMPImageWrite0"));
        }
        int scaleX = param.getSourceXSubsampling();
        int scaleY = param.getSourceYSubsampling();
        int xOffset = param.getSubsamplingXOffset();
        int yOffset = param.getSubsamplingYOffset();
        int dataType = sampleModel.getDataType();
        sourceRegion.translate(xOffset, yOffset);
        sourceRegion.width -= xOffset;
        sourceRegion.height -= yOffset;
        xOffset = sourceRegion.x % scaleX;
        yOffset = sourceRegion.y % scaleY;
        int minX = sourceRegion.x / scaleX;
        int minY = sourceRegion.y / scaleY;
        this.w = (sourceRegion.width + scaleX - 1) / scaleX;
        this.h = (sourceRegion.height + scaleY - 1) / scaleY;
        Rectangle destinationRegion = new Rectangle(minX, minY, this.w, this.h);
        boolean noTransform = destinationRegion.equals(sourceRegion);
        int[] sourceBands = param.getSourceBands();
        boolean noSubband = true;
        int numBands = sampleModel.getNumBands();
        if (sourceBands != null) {
            sampleModel = sampleModel.createSubsetSampleModel(sourceBands);
            colorModel = null;
            noSubband = false;
            numBands = sampleModel.getNumBands();
        } else {
            sourceBands = new int[numBands];
            int i2 = 0;
            while (i2 < numBands) {
                sourceBands[i2] = i2;
                ++i2;
            }
        }
        int[] bandOffsets = null;
        boolean bgrOrder = true;
        if (sampleModel instanceof ComponentSampleModel) {
            bandOffsets = ((ComponentSampleModel)sampleModel).getBandOffsets();
            i = 0;
            while (i < bandOffsets.length) {
                bgrOrder &= bandOffsets[i] == bandOffsets.length - i - 1;
                ++i;
            }
        } else {
            bandOffsets = new int[numBands];
            i = 0;
            while (i < numBands) {
                bandOffsets[i] = i;
                ++i;
            }
        }
        noTransform &= bgrOrder;
        ImageUtil.canEncodeImage(this, colorModel, sampleModel);
        int[] sampleSize = sampleModel.getSampleSize();
        int destScanlineBytes = this.w * numBands;
        this.compressionType = this.getCompressionType(bmpParam.getCompressionType());
        byte[] r = null;
        byte[] g = null;
        byte[] b2 = null;
        byte[] a2 = null;
        if (colorModel instanceof IndexColorModel) {
            isPalette = true;
            icm = (IndexColorModel)colorModel;
            paletteEntries = icm.getMapSize();
            if (paletteEntries <= 2) {
                bitsPerPixel = 1;
                destScanlineBytes = this.w + 7 >> 3;
            } else if (paletteEntries <= 16) {
                bitsPerPixel = 4;
                destScanlineBytes = this.w + 1 >> 1;
            } else if (paletteEntries <= 256) {
                bitsPerPixel = 8;
            } else {
                bitsPerPixel = 24;
                isPalette = false;
                paletteEntries = 0;
                destScanlineBytes = this.w * 3;
            }
            if (isPalette) {
                r = new byte[paletteEntries];
                g = new byte[paletteEntries];
                b2 = new byte[paletteEntries];
                a2 = new byte[paletteEntries];
                icm.getAlphas(a2);
                icm.getReds(r);
                icm.getGreens(g);
                icm.getBlues(b2);
            }
        } else if (numBands == 1) {
            isPalette = true;
            paletteEntries = 256;
            bitsPerPixel = sampleSize[0];
            destScanlineBytes = this.w * bitsPerPixel + 7 >> 3;
            r = new byte[256];
            g = new byte[256];
            b2 = new byte[256];
            a2 = new byte[256];
            int i3 = 0;
            while (i3 < 256) {
                r[i3] = (byte)i3;
                g[i3] = (byte)i3;
                b2[i3] = (byte)i3;
                a2[i3] = -1;
                ++i3;
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel && noSubband) {
            bitsPerPixel = DataBuffer.getDataTypeSize(sampleModel.getDataType());
            destScanlineBytes = this.w * bitsPerPixel + 7 >> 3;
        }
        int fileSize = 0;
        int offset = 0;
        int headerSize = 0;
        int imageSize = 0;
        int xPelsPerMeter = 0;
        int yPelsPerMeter = 0;
        int colorsUsed = 0;
        int colorsImportant = paletteEntries;
        int padding = destScanlineBytes % 4;
        if (padding != 0) {
            padding = 4 - padding;
        }
        if (sampleModel instanceof SinglePixelPackedSampleModel && noSubband) {
            this.bitPos = ((SinglePixelPackedSampleModel)sampleModel).getBitMasks();
            int i4 = 0;
            while (i4 < this.bitPos.length) {
                this.bitPos[i4] = this.firstLowBit(this.bitPos[i4]);
                ++i4;
            }
        }
        this.version = bmpParam.getVersion();
        switch (this.version) {
            case 0: {
                offset = 26 + paletteEntries * 3;
                headerSize = 12;
                imageSize = (destScanlineBytes + padding) * this.h;
                fileSize = imageSize + offset;
                throw new RuntimeException(I18N.getString("BMPImageWrite4"));
            }
            case 1: {
                offset = 54 + paletteEntries * 4;
                imageSize = (destScanlineBytes + padding) * this.h;
                fileSize = imageSize + offset;
                headerSize = 40;
                break;
            }
            case 2: {
                offset = 122 + paletteEntries * 4;
                imageSize = (destScanlineBytes + padding) * this.h;
                fileSize = imageSize + offset;
                headerSize = 108;
                throw new RuntimeException(I18N.getString("BMPImageWrite4"));
            }
            case 3: {
                imageSize = (destScanlineBytes + padding) * this.h;
                fileSize = imageSize + offset;
                headerSize = 124;
                throw new RuntimeException(I18N.getString("BMPImageWrite4"));
            }
        }
        long headPos = this.stream.getStreamPosition();
        if (this.compressionType == 3) {
            fileSize += 12;
            offset += 12;
        }
        this.writeFileHeader(fileSize, offset);
        this.writeInfoHeader(headerSize, bitsPerPixel);
        this.stream.writeInt(this.compressionType);
        this.stream.writeInt(imageSize);
        this.stream.writeInt(xPelsPerMeter);
        this.stream.writeInt(yPelsPerMeter);
        this.stream.writeInt(colorsUsed);
        this.stream.writeInt(colorsImportant);
        if (this.compressionType == 3) {
            boolean directColor = colorModel instanceof DirectColorModel;
            if (directColor) {
                this.stream.writeInt(((DirectColorModel)colorModel).getRedMask());
                this.stream.writeInt(((DirectColorModel)colorModel).getGreenMask());
                this.stream.writeInt(((DirectColorModel)colorModel).getBlueMask());
            } else if (bitsPerPixel == 16) {
                this.stream.writeInt(31744);
                this.stream.writeInt(992);
                this.stream.writeInt(31);
            } else if (bitsPerPixel == 32) {
                this.stream.writeInt(0xFF0000);
                this.stream.writeInt(65280);
                this.stream.writeInt(255);
            }
        }
        if (isPalette) {
            switch (this.version) {
                case 0: {
                    int i5 = 0;
                    while (i5 < paletteEntries) {
                        this.stream.writeByte(b2[i5]);
                        this.stream.writeByte(g[i5]);
                        this.stream.writeByte(r[i5]);
                        ++i5;
                    }
                    break;
                }
                default: {
                    int i6 = 0;
                    while (i6 < paletteEntries) {
                        this.stream.writeByte(b2[i6]);
                        this.stream.writeByte(g[i6]);
                        this.stream.writeByte(r[i6]);
                        this.stream.writeByte(a2[i6]);
                        ++i6;
                    }
                    break block6;
                }
            }
        }
        int scanlineBytes = this.w * numBands;
        int[] pixels = new int[scanlineBytes * scaleX];
        this.bpixels = new byte[destScanlineBytes];
        if (this.compressionType == 4 || this.compressionType == 5) {
            byte[] data = this.writeEmbedded(image, bmpParam);
            this.stream.write(data, 0, data.length);
            long endPos = this.stream.getStreamPosition();
            fileSize = (int)(endPos - headPos);
            imageSize = fileSize - offset;
            this.stream.seek(headPos);
            this.writeSize(fileSize, 2);
            this.stream.seek(headPos);
            this.writeSize(imageSize, 34);
            this.stream.seek(endPos);
            return;
        }
        this.isTopDown = bmpParam.isTopDown();
        int maxBandOffset = bandOffsets[0];
        int i7 = 1;
        while (i7 < bandOffsets.length) {
            if (bandOffsets[i7] > maxBandOffset) {
                maxBandOffset = bandOffsets[i7];
            }
            ++i7;
        }
        int[] pixel = new int[maxBandOffset + 1];
        int i8 = 0;
        while (i8 < this.h) {
            int row = minY + i8;
            if (!this.isTopDown) {
                row = minY + this.h - i8 - 1;
            }
            Raster src = inputRaster;
            Rectangle srcRect = new Rectangle(minX * scaleX + xOffset, row * scaleY + yOffset, (this.w - 1) * scaleX + 1, 1);
            if (!writeRaster) {
                src = input.getData(srcRect);
            }
            if (noTransform && noSubband) {
                byte[] bdata;
                SampleModel sm = src.getSampleModel();
                int pos = 0;
                int startX = srcRect.x - src.getSampleModelTranslateX();
                int startY = srcRect.y - src.getSampleModelTranslateY();
                if (sm instanceof ComponentSampleModel) {
                    ComponentSampleModel csm = (ComponentSampleModel)sm;
                    pos = csm.getOffset(startX, startY) - bandOffsets[0];
                } else if (sm instanceof MultiPixelPackedSampleModel) {
                    MultiPixelPackedSampleModel mppsm = (MultiPixelPackedSampleModel)sm;
                    pos = mppsm.getOffset(startX, startY);
                } else if (sm instanceof SinglePixelPackedSampleModel) {
                    SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)sm;
                    pos = sppsm.getOffset(startX, startY);
                }
                if (this.compressionType == 0 || this.compressionType == 3) {
                    switch (dataType) {
                        case 0: {
                            bdata = ((DataBufferByte)src.getDataBuffer()).getData();
                            this.stream.write(bdata, pos, destScanlineBytes);
                            break;
                        }
                        case 2: {
                            short[] sdata = ((DataBufferShort)src.getDataBuffer()).getData();
                            this.stream.writeShorts(sdata, pos, destScanlineBytes >> 1);
                            break;
                        }
                        case 1: {
                            short[] usdata = ((DataBufferUShort)src.getDataBuffer()).getData();
                            this.stream.writeShorts(usdata, pos, destScanlineBytes >> 1);
                            break;
                        }
                        case 3: {
                            int[] idata = ((DataBufferInt)src.getDataBuffer()).getData();
                            this.stream.writeInts(idata, pos, destScanlineBytes >> 2);
                        }
                    }
                    int k = 0;
                    while (k < padding) {
                        this.stream.writeByte(0);
                        ++k;
                    }
                } else if (this.compressionType == 2) {
                    if (this.bpixels == null || this.bpixels.length < scanlineBytes) {
                        this.bpixels = new byte[scanlineBytes];
                    }
                    src.getPixels(srcRect.x, srcRect.y, srcRect.width, srcRect.height, pixels);
                    int h = 0;
                    while (h < scanlineBytes) {
                        this.bpixels[h] = (byte)pixels[h];
                        ++h;
                    }
                    this.encodeRLE4(this.bpixels, scanlineBytes);
                } else if (this.compressionType == 1) {
                    bdata = ((DataBufferByte)src.getDataBuffer()).getData();
                    System.arraycopy(bdata, pos, this.bpixels, 0, scanlineBytes);
                    this.encodeRLE8(this.bpixels, scanlineBytes);
                }
            } else {
                src.getPixels(srcRect.x, srcRect.y, srcRect.width, srcRect.height, pixels);
                if (scaleX != 1 || maxBandOffset != numBands - 1 || bgrOrder) {
                    int j = 0;
                    int k = 0;
                    int n = 0;
                    while (j < this.w) {
                        System.arraycopy(pixels, k, pixel, 0, pixel.length);
                        int m = 0;
                        while (m < numBands) {
                            pixels[n + numBands - m - 1] = pixel[bandOffsets[sourceBands[m]]];
                            ++m;
                        }
                        ++j;
                        k += scaleX * numBands;
                        n += numBands;
                    }
                }
                this.writePixels(0, scanlineBytes, bitsPerPixel, pixels, padding, numBands, icm);
            }
            ++i8;
        }
        if (this.compressionType == 2 || this.compressionType == 1) {
            this.stream.writeByte(0);
            this.stream.writeByte(1);
            this.incCompImageSize(2);
            imageSize = this.compImageSize;
            fileSize = this.compImageSize + offset;
            long endPos = this.stream.getStreamPosition();
            this.stream.seek(headPos);
            this.writeSize(fileSize, 2);
            this.stream.seek(headPos);
            this.writeSize(imageSize, 34);
            this.stream.seek(endPos);
        }
    }

    private void writePixels(int l, int scanlineBytes, int bitsPerPixel, int[] pixels, int padding, int numBands, IndexColorModel icm) throws IOException {
        int pixel = 0;
        int k = 0;
        switch (bitsPerPixel) {
            case 1: {
                int j = 0;
                while (j < scanlineBytes / 8) {
                    this.bpixels[k++] = (byte)(pixels[l++] << 7 | pixels[l++] << 6 | pixels[l++] << 5 | pixels[l++] << 4 | pixels[l++] << 3 | pixels[l++] << 2 | pixels[l++] << 1 | pixels[l++]);
                    ++j;
                }
                if (scanlineBytes % 8 > 0) {
                    pixel = 0;
                    int j2 = 0;
                    while (j2 < scanlineBytes % 8) {
                        pixel |= pixels[l++] << 7 - j2;
                        ++j2;
                    }
                    this.bpixels[k++] = (byte)pixel;
                }
                this.stream.write(this.bpixels, 0, (scanlineBytes + 7) / 8);
                break;
            }
            case 4: {
                if (this.compressionType == 2) {
                    byte[] bipixels = new byte[scanlineBytes];
                    int h = 0;
                    while (h < scanlineBytes) {
                        bipixels[h] = (byte)pixels[l++];
                        ++h;
                    }
                    this.encodeRLE4(bipixels, scanlineBytes);
                    break;
                }
                int j = 0;
                while (j < scanlineBytes / 2) {
                    pixel = pixels[l++] << 4 | pixels[l++];
                    this.bpixels[k++] = (byte)pixel;
                    ++j;
                }
                if (scanlineBytes % 2 == 1) {
                    pixel = pixels[l] << 4;
                    this.bpixels[k++] = (byte)pixel;
                }
                this.stream.write(this.bpixels, 0, (scanlineBytes + 1) / 2);
                break;
            }
            case 8: {
                if (this.compressionType == 1) {
                    int h = 0;
                    while (h < scanlineBytes) {
                        this.bpixels[h] = (byte)pixels[l++];
                        ++h;
                    }
                    this.encodeRLE8(this.bpixels, scanlineBytes);
                    break;
                }
                int j = 0;
                while (j < scanlineBytes) {
                    this.bpixels[j] = (byte)pixels[l++];
                    ++j;
                }
                this.stream.write(this.bpixels, 0, scanlineBytes);
                break;
            }
            case 16: {
                if (this.spixels == null) {
                    this.spixels = new short[scanlineBytes / numBands];
                }
                int j = 0;
                int m = 0;
                while (j < scanlineBytes) {
                    this.spixels[m] = 0;
                    int i = numBands - 1;
                    while (i >= 0) {
                        int n = m;
                        this.spixels[n] = (short)(this.spixels[n] | pixels[j] << this.bitPos[i]);
                        --i;
                        ++j;
                    }
                    ++m;
                }
                this.stream.writeShorts(this.spixels, 0, this.spixels.length);
                break;
            }
            case 24: {
                int j;
                if (numBands == 3) {
                    j = 0;
                    while (j < scanlineBytes) {
                        this.bpixels[k++] = (byte)pixels[l + 2];
                        this.bpixels[k++] = (byte)pixels[l + 1];
                        this.bpixels[k++] = (byte)pixels[l];
                        l += 3;
                        j += 3;
                    }
                    this.stream.write(this.bpixels, 0, scanlineBytes);
                    break;
                }
                int entries = icm.getMapSize();
                byte[] r = new byte[entries];
                byte[] g = new byte[entries];
                byte[] b2 = new byte[entries];
                icm.getReds(r);
                icm.getGreens(g);
                icm.getBlues(b2);
                int j3 = 0;
                while (j3 < scanlineBytes) {
                    int index = pixels[l];
                    this.bpixels[k++] = b2[index];
                    this.bpixels[k++] = g[index];
                    this.bpixels[k++] = b2[index];
                    ++l;
                    ++j3;
                }
                this.stream.write(this.bpixels, 0, scanlineBytes * 3);
                break;
            }
            case 32: {
                if (this.ipixels == null) {
                    this.ipixels = new int[scanlineBytes / numBands];
                }
                int j = 0;
                int m = 0;
                while (j < scanlineBytes) {
                    this.ipixels[m] = 0;
                    int i = numBands - 1;
                    while (i >= 0) {
                        int n = m;
                        this.ipixels[n] = this.ipixels[n] | pixels[j] << this.bitPos[i];
                        --i;
                        ++j;
                    }
                    ++m;
                }
                this.stream.writeInts(this.ipixels, 0, this.ipixels.length);
            }
        }
        if (this.compressionType == 0 || this.compressionType == 3) {
            k = 0;
            while (k < padding) {
                this.stream.writeByte(0);
                ++k;
            }
        }
    }

    private void encodeRLE8(byte[] bpixels, int scanlineBytes) throws IOException {
        int runCount = 1;
        int absVal = -1;
        int j = -1;
        byte runVal = 0;
        byte nextVal = 0;
        runVal = bpixels[++j];
        byte[] absBuf = new byte[256];
        while (j < scanlineBytes - 1) {
            int b2;
            int a2;
            if ((nextVal = bpixels[++j]) == runVal) {
                if (absVal >= 3) {
                    this.stream.writeByte(0);
                    this.stream.writeByte(absVal);
                    this.incCompImageSize(2);
                    a2 = 0;
                    while (a2 < absVal) {
                        this.stream.writeByte(absBuf[a2]);
                        this.incCompImageSize(1);
                        ++a2;
                    }
                    if (!this.isEven(absVal)) {
                        this.stream.writeByte(0);
                        this.incCompImageSize(1);
                    }
                } else if (absVal > -1) {
                    b2 = 0;
                    while (b2 < absVal) {
                        this.stream.writeByte(1);
                        this.stream.writeByte(absBuf[b2]);
                        this.incCompImageSize(2);
                        ++b2;
                    }
                }
                absVal = -1;
                if (++runCount == 256) {
                    this.stream.writeByte(runCount - 1);
                    this.stream.writeByte(runVal);
                    this.incCompImageSize(2);
                    runCount = 1;
                }
            } else {
                if (runCount > 1) {
                    this.stream.writeByte(runCount);
                    this.stream.writeByte(runVal);
                    this.incCompImageSize(2);
                } else if (absVal < 0) {
                    absBuf[++absVal] = runVal;
                    absBuf[++absVal] = nextVal;
                } else if (absVal < 254) {
                    absBuf[++absVal] = nextVal;
                } else {
                    this.stream.writeByte(0);
                    this.stream.writeByte(absVal + 1);
                    this.incCompImageSize(2);
                    a2 = 0;
                    while (a2 <= absVal) {
                        this.stream.writeByte(absBuf[a2]);
                        this.incCompImageSize(1);
                        ++a2;
                    }
                    this.stream.writeByte(0);
                    this.incCompImageSize(1);
                    absVal = -1;
                }
                runVal = nextVal;
                runCount = 1;
            }
            if (j != scanlineBytes - 1) continue;
            if (absVal == -1) {
                this.stream.writeByte(runCount);
                this.stream.writeByte(runVal);
                this.incCompImageSize(2);
                runCount = 1;
            } else if (absVal >= 2) {
                this.stream.writeByte(0);
                this.stream.writeByte(absVal + 1);
                this.incCompImageSize(2);
                a2 = 0;
                while (a2 <= absVal) {
                    this.stream.writeByte(absBuf[a2]);
                    this.incCompImageSize(1);
                    ++a2;
                }
                if (!this.isEven(absVal + 1)) {
                    this.stream.writeByte(0);
                    this.incCompImageSize(1);
                }
            } else if (absVal > -1) {
                b2 = 0;
                while (b2 <= absVal) {
                    this.stream.writeByte(1);
                    this.stream.writeByte(absBuf[b2]);
                    this.incCompImageSize(2);
                    ++b2;
                }
            }
            this.stream.writeByte(0);
            this.stream.writeByte(0);
            this.incCompImageSize(2);
        }
    }

    private void encodeRLE4(byte[] bipixels, int scanlineBytes) throws IOException {
        int runCount = 2;
        int absVal = -1;
        int j = -1;
        int pixel = 0;
        int q = 0;
        byte runVal1 = 0;
        byte runVal2 = 0;
        byte nextVal1 = 0;
        byte nextVal2 = 0;
        byte[] absBuf = new byte[256];
        runVal1 = bipixels[++j];
        runVal2 = bipixels[++j];
        while (j < scanlineBytes - 2) {
            int n;
            int a2;
            nextVal1 = bipixels[++j];
            nextVal2 = bipixels[++j];
            if (nextVal1 == runVal1) {
                int r;
                if (absVal >= 4) {
                    this.stream.writeByte(0);
                    this.stream.writeByte(absVal - 1);
                    this.incCompImageSize(2);
                    a2 = 0;
                    while (a2 < absVal - 2) {
                        pixel = absBuf[a2] << 4 | absBuf[a2 + 1];
                        this.stream.writeByte((byte)pixel);
                        this.incCompImageSize(1);
                        a2 += 2;
                    }
                    if (!this.isEven(absVal - 1)) {
                        q = absBuf[absVal - 2] << 4 | 0;
                        this.stream.writeByte(q);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven((int)Math.ceil((absVal - 1) / 2))) {
                        this.stream.writeByte(0);
                        this.incCompImageSize(1);
                    }
                } else if (absVal > -1) {
                    this.stream.writeByte(2);
                    pixel = absBuf[0] << 4 | absBuf[1];
                    this.stream.writeByte(pixel);
                    this.incCompImageSize(2);
                }
                absVal = -1;
                if (nextVal2 == runVal2) {
                    if ((runCount += 2) == 256) {
                        this.stream.writeByte(runCount - 1);
                        pixel = runVal1 << 4 | runVal2;
                        this.stream.writeByte(pixel);
                        this.incCompImageSize(2);
                        runCount = 2;
                        if (j < scanlineBytes - 1) {
                            runVal1 = runVal2;
                            runVal2 = bipixels[++j];
                        } else {
                            this.stream.writeByte(1);
                            r = runVal2 << 4 | 0;
                            this.stream.writeByte(r);
                            this.incCompImageSize(2);
                            runCount = -1;
                        }
                    }
                } else {
                    pixel = runVal1 << 4 | runVal2;
                    this.stream.writeByte(++runCount);
                    this.stream.writeByte(pixel);
                    this.incCompImageSize(2);
                    runCount = 2;
                    runVal1 = nextVal2;
                    if (j < scanlineBytes - 1) {
                        runVal2 = bipixels[++j];
                    } else {
                        this.stream.writeByte(1);
                        r = nextVal2 << 4 | 0;
                        this.stream.writeByte(r);
                        this.incCompImageSize(2);
                        runCount = -1;
                    }
                }
            } else {
                if (runCount > 2) {
                    pixel = runVal1 << 4 | runVal2;
                    this.stream.writeByte(runCount);
                    this.stream.writeByte(pixel);
                    this.incCompImageSize(2);
                } else if (absVal < 0) {
                    absBuf[++absVal] = runVal1;
                    absBuf[++absVal] = runVal2;
                    absBuf[++absVal] = nextVal1;
                    absBuf[++absVal] = nextVal2;
                } else if (absVal < 253) {
                    absBuf[++absVal] = nextVal1;
                    absBuf[++absVal] = nextVal2;
                } else {
                    this.stream.writeByte(0);
                    this.stream.writeByte(absVal + 1);
                    this.incCompImageSize(2);
                    a2 = 0;
                    while (a2 < absVal) {
                        pixel = absBuf[a2] << 4 | absBuf[a2 + 1];
                        this.stream.writeByte((byte)pixel);
                        this.incCompImageSize(1);
                        a2 += 2;
                    }
                    this.stream.writeByte(0);
                    this.incCompImageSize(1);
                    absVal = -1;
                }
                runVal1 = nextVal1;
                runVal2 = nextVal2;
                runCount = 2;
            }
            if (j < scanlineBytes - 2) continue;
            if (absVal == -1 && runCount >= 2) {
                if (j == scanlineBytes - 2) {
                    if (bipixels[++j] == runVal1) {
                        pixel = runVal1 << 4 | runVal2;
                        this.stream.writeByte(++runCount);
                        this.stream.writeByte(pixel);
                        this.incCompImageSize(2);
                    } else {
                        pixel = runVal1 << 4 | runVal2;
                        this.stream.writeByte(runCount);
                        this.stream.writeByte(pixel);
                        this.stream.writeByte(1);
                        pixel = bipixels[j] << 4 | 0;
                        this.stream.writeByte(pixel);
                        n = bipixels[j] << 4 | 0;
                        this.incCompImageSize(4);
                    }
                } else {
                    this.stream.writeByte(runCount);
                    pixel = runVal1 << 4 | runVal2;
                    this.stream.writeByte(pixel);
                    this.incCompImageSize(2);
                }
            } else if (absVal > -1) {
                if (j == scanlineBytes - 2) {
                    absBuf[++absVal] = bipixels[++j];
                }
                if (absVal >= 2) {
                    this.stream.writeByte(0);
                    this.stream.writeByte(absVal + 1);
                    this.incCompImageSize(2);
                    a2 = 0;
                    while (a2 < absVal) {
                        pixel = absBuf[a2] << 4 | absBuf[a2 + 1];
                        this.stream.writeByte((byte)pixel);
                        this.incCompImageSize(1);
                        a2 += 2;
                    }
                    if (!this.isEven(absVal + 1)) {
                        q = absBuf[absVal] << 4 | 0;
                        this.stream.writeByte(q);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven((int)Math.ceil((absVal + 1) / 2))) {
                        this.stream.writeByte(0);
                        this.incCompImageSize(1);
                    }
                } else {
                    switch (absVal) {
                        case 0: {
                            this.stream.writeByte(1);
                            n = absBuf[0] << 4 | 0;
                            this.stream.writeByte(n);
                            this.incCompImageSize(2);
                            break;
                        }
                        case 1: {
                            this.stream.writeByte(2);
                            pixel = absBuf[0] << 4 | absBuf[1];
                            this.stream.writeByte(pixel);
                            this.incCompImageSize(2);
                        }
                    }
                }
            }
            this.stream.writeByte(0);
            this.stream.writeByte(0);
            this.incCompImageSize(2);
        }
    }

    private synchronized void incCompImageSize(int value) {
        this.compImageSize += value;
    }

    private boolean isEven(int number) {
        return number % 2 == 0;
    }

    private void writeFileHeader(int fileSize, int offset) throws IOException {
        this.stream.writeByte(66);
        this.stream.writeByte(77);
        this.stream.writeInt(fileSize);
        this.stream.writeInt(0);
        this.stream.writeInt(offset);
    }

    private void writeInfoHeader(int headerSize, int bitsPerPixel) throws IOException {
        this.stream.writeInt(headerSize);
        this.stream.writeInt(this.w);
        this.stream.writeInt(this.h);
        this.stream.writeShort(1);
        this.stream.writeShort(bitsPerPixel);
    }

    private void writeSize(int dword, int offset) throws IOException {
        this.stream.skipBytes(offset);
        this.stream.writeInt(dword);
    }

    public void reset() {
        super.reset();
        this.stream = null;
    }

    private int getCompressionType(String typeString) {
        int i = 0;
        while (i < BMPConstants.compressionTypeNames.length) {
            if (BMPConstants.compressionTypeNames[i].equals(typeString)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private byte[] writeEmbedded(IIOImage image, ImageWriteParam bmpParam) throws IOException {
        String format = this.compressionType == 4 ? "jpeg" : "png";
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(format);
        ImageWriter writer = null;
        while (iterator.hasNext()) {
            writer = iterator.next();
            if (writer != null && writer.getClass().getName().indexOf("com.sun.imageio") >= 0) break;
        }
        if (writer != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            writer.setOutput(new MemoryCacheImageOutputStream(baos));
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setDestinationOffset(bmpParam.getDestinationOffset());
            param.setSourceBands(bmpParam.getSourceBands());
            param.setSourceRegion(bmpParam.getSourceRegion());
            param.setSourceSubsampling(bmpParam.getSourceXSubsampling(), bmpParam.getSourceYSubsampling(), bmpParam.getSubsamplingXOffset(), bmpParam.getSubsamplingYOffset());
            writer.write(null, image, param);
            baos.flush();
            return baos.toByteArray();
        }
        throw new RuntimeException(I18N.getString("BMPImageWrite5") + " " + format);
    }

    private int firstLowBit(int num) {
        int count = 0;
        while ((num & 1) == 0) {
            ++count;
            num >>>= 1;
        }
        return count;
    }
}

