/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg;

import com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriter;
import com.sun.medialib.codec.jiio.Util;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;

public class CLibJPEGImageWriterSpi
extends ImageWriterSpi {
    private static final String vendorName = "Sun Microsystems, Inc.";
    private static final String version = "0.5";
    private static final String[] names;
    private static final String[] suffixes;
    private static final String[] MIMETypes;
    private static final String writerClassName = "com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriter";
    private static final String[] readerSpiNames;
    private boolean registered = false;

    public CLibJPEGImageWriterSpi() {
        super(vendorName, version, names, suffixes, MIMETypes, writerClassName, ImageWriterSpi.STANDARD_OUTPUT_TYPE, readerSpiNames, false, null, null, null, null, false, null, null, null, null);
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        if (!this.registered) {
            boolean isCodecLibAvailable;
            try {
                isCodecLibAvailable = Util.isCodecLibAvailable();
            }
            catch (Throwable e) {
                isCodecLibAvailable = false;
            }
            if (!isCodecLibAvailable) {
                registry.deregisterServiceProvider(this);
            }
            this.registered = true;
        }
    }

    public boolean canEncodeImage(ImageTypeSpecifier type) {
        int bitDepth;
        ColorModel colorModel = type.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            return false;
        }
        SampleModel sampleModel = type.getSampleModel();
        if (colorModel != null) {
            int[] componentSize = colorModel.getComponentSize();
            bitDepth = componentSize[0];
            int i = 1;
            while (i < componentSize.length) {
                if (componentSize[i] != bitDepth) {
                    return false;
                }
                ++i;
            }
        } else {
            int[] sampleSize = sampleModel.getSampleSize();
            bitDepth = sampleSize[0];
            int i = 1;
            while (i < sampleSize.length) {
                if (sampleSize[i] != bitDepth) {
                    return false;
                }
                ++i;
            }
        }
        if (bitDepth > 12) {
            return false;
        }
        int numBands = sampleModel.getNumBands();
        return numBands == 1 || numBands == 3;
    }

    public String getDescription(Locale locale) {
        return "codecLib JPEG image writer";
    }

    public ImageWriter createWriterInstance(Object extension) {
        return new CLibJPEGImageWriter(this);
    }

    static {
        vendorName = vendorName;
        version = version;
        names = new String[]{"jpeg", "JPEG", "jpg", "JPG", "jfif", "JFIF", "jpeg-lossless", "JPEG-LOSSLESS", "jpeg-ls", "JPEG-LS"};
        suffixes = new String[]{"jpeg", "jpg", "jfif", "jls"};
        MIMETypes = new String[]{"image/jpeg"};
        writerClassName = writerClassName;
        readerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageReaderSpi"};
    }
}

