/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderCodecLib;
import com.sun.medialib.codec.jiio.Util;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class J2KImageReaderCodecLibSpi
extends ImageReaderSpi {
    private static String[] writerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriterCodecLibSpi"};
    private static String[] formatNames = new String[]{"jpeg 2000", "JPEG 2000", "jpeg2000", "JPEG2000"};
    private static String[] entensions = new String[]{"jp2"};
    private static String[] mimeType = new String[]{"image/jpeg2000"};
    private boolean registered = false;
    private boolean useCodecLib = false;

    public J2KImageReaderCodecLibSpi() {
        super("Sun Microsystems, Inc.", "0.5", formatNames, entensions, mimeType, "com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriterCodecLib", ImageReaderSpi.STANDARD_INPUT_TYPE, writerSpiNames, false, null, null, null, null, true, "com_sun_media_imageio_plugins_jpeg2000_image_1.0", "com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadataFormat", null, null);
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        if (this.registered) {
            return;
        }
        try {
            this.useCodecLib = Util.isCodecLibAvailable();
        }
        catch (Throwable e) {
            this.useCodecLib = false;
        }
        if (this.useCodecLib) {
            this.registered = true;
        }
    }

    public String getDescription(Locale locale) {
        return "Standard JPEG 2000 Image Reader";
    }

    public boolean canDecodeInput(Object source) throws IOException {
        if (!(source instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream stream = (ImageInputStream)source;
        byte[] b2 = new byte[12];
        stream.mark();
        stream.readFully(b2);
        stream.reset();
        if (b2[0] != 0 || b2[1] != 0 || b2[2] != 0 || b2[3] != 12) {
            return false;
        }
        if ((b2[4] & 0xFF) != 106 || (b2[5] & 0xFF) != 80 || (b2[6] & 0xFF) != 32 || (b2[7] & 0xFF) != 32) {
            return false;
        }
        return (b2[8] & 0xFF) == 13 && (b2[9] & 0xFF) == 10 && (b2[10] & 0xFF) == 135 && (b2[11] & 0xFF) == 10;
    }

    public ImageReader createReaderInstance(Object extension) throws IIOException {
        return new J2KImageReaderCodecLib(this);
    }
}

