/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageioimpl.plugins.tiff.TIFFFaxDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFT4Compressor;
import com.sun.medialib.codec.g3fax.Encoder;

public class TIFFCodecLibT4Compressor
extends TIFFT4Compressor {
    Object encoder;

    public TIFFCodecLibT4Compressor() {
        try {
            Encoder encoder = new Encoder();
            this.encoder = encoder;
        }
        catch (Throwable t) {
            throw new RuntimeException("CodecLib not available");
        }
    }

    public final int encodeT4(boolean is1DMode, boolean isEOLAligned, byte[] data, int lineStride, int colOffset, int width, int height, byte[] compData) {
        int result2;
        int encodingFlags;
        if (isEOLAligned || colOffset % 8 != 0) {
            return super.encodeT4(is1DMode, isEOLAligned, data, lineStride, colOffset, width, height, compData);
        }
        int bytesPerRow = (width + 7) / 8;
        byte[] image = null;
        if (colOffset == 0 && bytesPerRow == lineStride) {
            image = data;
        } else {
            image = new byte[bytesPerRow * height];
            int dataOffset = colOffset / 8;
            int imageOffset = 0;
            int row = 0;
            while (row < height) {
                System.arraycopy(data, dataOffset, image, imageOffset, bytesPerRow);
                dataOffset += lineStride;
                imageOffset += bytesPerRow;
                ++row;
            }
        }
        Encoder clibEncoder = (Encoder)this.encoder;
        int n = encodingFlags = is1DMode ? 1 : 2;
        if (isEOLAligned) {
            encodingFlags |= 0x10;
        }
        if ((result2 = clibEncoder.encode(compData, image, width, height, 2, encodingFlags)) == -1) {
            result2 = super.encodeT4(is1DMode, isEOLAligned, data, lineStride, colOffset, width, height, compData);
        } else if (this.inverseFill) {
            byte[] flipTable = TIFFFaxDecompressor.flipTable;
            int i = 0;
            while (i < result2) {
                compData[i] = flipTable[compData[i] & 0xFF];
                ++i;
            }
        }
        return result2;
    }
}

