/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import com.sun.media.imageioimpl.plugins.tiff.TIFFField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class TIFFIFD {
    private static final int MAX_LOW_FIELD_TAG_NUM = 532;
    private List tagSets;
    private TIFFTag parentTag;
    private TIFFField[] lowFields = new TIFFField[533];
    private int numLowFields = 0;
    private Map highFields = new HashMap();
    int stripOrTileByteCountsPosition;
    int stripOrTileOffsetsPosition;
    int lastPosition;

    public TIFFIFD(List tagSets, TIFFTag parentTag) {
        this.tagSets = tagSets;
        this.parentTag = parentTag;
    }

    public TIFFIFD(List tagSets) {
        this(tagSets, null);
    }

    public List getTagSets() {
        return this.tagSets;
    }

    public TIFFTag getParentTag() {
        return this.parentTag;
    }

    public Iterator iterator() {
        ArrayList<TIFFField> fields = new ArrayList<TIFFField>(this.numLowFields + this.highFields.size());
        int len = this.lowFields.length;
        int i = 0;
        while (i < len) {
            TIFFField f = this.lowFields[i];
            if (f != null) {
                fields.add(f);
            }
            ++i;
        }
        fields.addAll(this.highFields.values());
        return fields.iterator();
    }

    public static TIFFTag getTag(int tagNumber, List tagSets) {
        Iterator iter = tagSets.iterator();
        while (iter.hasNext()) {
            TIFFTagSet tagSet = (TIFFTagSet)iter.next();
            TIFFTag tag = tagSet.getTag(tagNumber);
            if (tag == null) continue;
            return tag;
        }
        return null;
    }

    public TIFFTag getTag(int tagNumber) {
        return TIFFIFD.getTag(tagNumber, this.tagSets);
    }

    public static TIFFTag getTag(String tagName, List tagSets) {
        Iterator iter = tagSets.iterator();
        while (iter.hasNext()) {
            TIFFTagSet tagSet = (TIFFTagSet)iter.next();
            TIFFTag tag = tagSet.getTag(tagName);
            if (tag == null) continue;
            return tag;
        }
        return null;
    }

    public void initialize(ImageInputStream stream) throws IOException {
        Arrays.fill(this.lowFields, null);
        this.numLowFields = 0;
        this.highFields.clear();
        int numEntries = stream.readUnsignedShort();
        int i = 0;
        while (i < numEntries) {
            int tag = stream.readUnsignedShort();
            int type = stream.readUnsignedShort();
            int count = (int)stream.readUnsignedInt();
            int value = 0;
            long nextTagOffset = stream.getStreamPosition() + 4L;
            int sizeOfType = TIFFTag.getSizeOfType(type);
            if (count * sizeOfType > 4) {
                value = (int)stream.readUnsignedInt();
                stream.seek(value);
            }
            Object obj = null;
            switch (type) {
                case 1: 
                case 2: 
                case 6: 
                case 7: {
                    byte[] bvalues = new byte[count];
                    stream.readFully(bvalues, 0, count);
                    if (type == 2) {
                        Vector<String> v = new Vector<String>();
                        boolean inString = false;
                        int prevIndex = 0;
                        int index = 0;
                        while (index <= count) {
                            if (index < count && bvalues[index] != 0) {
                                if (!inString) {
                                    prevIndex = index;
                                    inString = true;
                                }
                            } else if (inString) {
                                String s = new String(bvalues, prevIndex, index - prevIndex);
                                v.add(s);
                                inString = false;
                            }
                            ++index;
                        }
                        count = v.size();
                        String[] strings = new String[count];
                        int c2 = 0;
                        while (c2 < count) {
                            strings[c2] = (String)v.elementAt(c2);
                            ++c2;
                        }
                        obj = strings;
                        break;
                    }
                    obj = bvalues;
                    break;
                }
                case 3: {
                    char[] cvalues = new char[count];
                    int j = 0;
                    while (j < count) {
                        cvalues[j] = (char)stream.readUnsignedShort();
                        ++j;
                    }
                    obj = cvalues;
                    break;
                }
                case 4: 
                case 13: {
                    long[] lvalues = new long[count];
                    int j = 0;
                    while (j < count) {
                        lvalues[j] = stream.readUnsignedInt();
                        ++j;
                    }
                    obj = lvalues;
                    break;
                }
                case 5: {
                    long[][] llvalues = new long[count][2];
                    int j = 0;
                    while (j < count) {
                        llvalues[j][0] = stream.readUnsignedInt();
                        llvalues[j][1] = stream.readUnsignedInt();
                        ++j;
                    }
                    obj = llvalues;
                    break;
                }
                case 8: {
                    short[] svalues = new short[count];
                    int j = 0;
                    while (j < count) {
                        svalues[j] = stream.readShort();
                        ++j;
                    }
                    obj = svalues;
                    break;
                }
                case 9: {
                    int[] ivalues = new int[count];
                    int j = 0;
                    while (j < count) {
                        ivalues[j] = stream.readInt();
                        ++j;
                    }
                    obj = ivalues;
                    break;
                }
                case 10: {
                    int[][] iivalues = new int[count][2];
                    int j = 0;
                    while (j < count) {
                        iivalues[j][0] = stream.readInt();
                        iivalues[j][1] = stream.readInt();
                        ++j;
                    }
                    obj = iivalues;
                    break;
                }
                case 11: {
                    float[] fvalues = new float[count];
                    int j = 0;
                    while (j < count) {
                        fvalues[j] = stream.readFloat();
                        ++j;
                    }
                    obj = fvalues;
                    break;
                }
                case 12: {
                    double[] dvalues = new double[count];
                    int j = 0;
                    while (j < count) {
                        dvalues[j] = stream.readDouble();
                        ++j;
                    }
                    obj = dvalues;
                    break;
                }
            }
            TIFFTag tiffTag = TIFFIFD.getTag(tag, this.tagSets);
            if (tiffTag != null && tiffTag.isDataTypeOK(type) && tiffTag.isIFDPointer()) {
                stream.mark();
                stream.seek(((long[])obj)[0]);
                ArrayList<TIFFTagSet> tagSets = new ArrayList<TIFFTagSet>(1);
                tagSets.add(tiffTag.getTagSet());
                TIFFIFD subIFD = new TIFFIFD(tagSets);
                subIFD.initialize(stream);
                obj = subIFD;
                stream.reset();
            }
            if (tiffTag == null) {
                tiffTag = new TIFFTag(null, tag, 1 << type, null);
            }
            TIFFField f = new TIFFField(tiffTag, type, count, obj);
            this.addTIFFField(f);
            stream.seek(nextTagOffset);
            ++i;
        }
    }

    public void writeToStream(ImageOutputStream stream) throws IOException {
        int numFields = this.numLowFields + this.highFields.size();
        stream.writeShort(numFields);
        long nextSpace = stream.getStreamPosition() + (long)(12 * numFields) + 4L;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            long pos;
            TIFFField f = (TIFFField)iter.next();
            TIFFTag tag = f.getTag();
            int type = f.getType();
            int count = f.getCount();
            if (type == 0) {
                type = 7;
            }
            int size = count * TIFFTag.getSizeOfType(type);
            if (type == 2) {
                int chars = 0;
                int i = 0;
                while (i < count) {
                    chars += f.getAsString(i).length() + 1;
                    ++i;
                }
                size = count = chars;
            }
            int tagNumber = f.getTagNumber();
            stream.writeShort(tagNumber);
            stream.writeShort(type);
            stream.writeInt(count);
            stream.writeInt(0);
            stream.mark();
            stream.skipBytes(-4);
            if (size > 4 || tag.isIFDPointer()) {
                if (tag.isIFDPointer()) {
                    nextSpace = nextSpace + 3L & 0xFFFFFFFFFFFFFFFCL;
                }
                stream.writeInt((int)nextSpace);
                stream.seek(nextSpace);
                pos = nextSpace;
                if (tag.isIFDPointer()) {
                    TIFFIFD subIFD = (TIFFIFD)f.getData();
                    subIFD.writeToStream(stream);
                } else {
                    f.writeData(stream);
                }
                nextSpace = stream.getStreamPosition();
            } else {
                pos = stream.getStreamPosition();
                f.writeData(stream);
            }
            if (tagNumber == 279 || tagNumber == 325) {
                this.stripOrTileByteCountsPosition = (int)pos;
            } else if (tagNumber == 273 || tagNumber == 324) {
                this.stripOrTileOffsetsPosition = (int)pos;
            }
            stream.reset();
        }
        this.lastPosition = (int)nextSpace;
    }

    public int getStripOrTileByteCountsPosition() {
        return this.stripOrTileByteCountsPosition;
    }

    public int getStripOrTileOffsetsPosition() {
        return this.stripOrTileOffsetsPosition;
    }

    public int getLastPosition() {
        return this.lastPosition;
    }

    public void addTIFFField(TIFFField f) {
        int tagNumber = f.getTagNumber();
        if (tagNumber <= 532) {
            if (this.lowFields[tagNumber] == null) {
                ++this.numLowFields;
            }
            this.lowFields[tagNumber] = f;
        } else {
            this.highFields.put(new Integer(tagNumber), f);
        }
    }

    public TIFFField getTIFFField(int tagNumber) {
        TIFFField f = tagNumber <= 532 ? this.lowFields[tagNumber] : (TIFFField)this.highFields.get(new Integer(tagNumber));
        return f;
    }

    public void removeTIFFField(int tagNumber) {
        if (tagNumber <= 532) {
            if (this.lowFields[tagNumber] != null) {
                --this.numLowFields;
                this.lowFields[tagNumber] = null;
            }
        } else {
            this.highFields.remove(new Integer(tagNumber));
        }
    }

    static {
        MAX_LOW_FIELD_TAG_NUM = 532;
    }
}

