/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import com.sun.media.imageioimpl.plugins.tiff.TIFFField;
import com.sun.media.imageioimpl.plugins.tiff.TIFFIFD;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TIFFImageMetadata
extends IIOMetadata {
    public static final String nativeMetadataFormatName = "com_sun_media_imageio_plugins_tiff_image_1.0";
    public static final String nativeMetadataFormatClassName = "com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadataFormat";
    List tagSets;
    TIFFIFD rootIFD;
    private static final String[] colorSpaceNames;
    String[] compressionTypeNames = new String[]{null, "none", "CCITT RLE", "CCITT T4", "CCITT T6", "LZW", "Old JPEG", "JPEG", "Deflate", "Packbits"};
    private static final String[] orientationNames;

    public TIFFImageMetadata(List tagSets) {
        super(true, nativeMetadataFormatName, nativeMetadataFormatClassName, null, null);
        this.tagSets = tagSets;
        this.rootIFD = new TIFFIFD(tagSets);
    }

    public TIFFImageMetadata(TIFFIFD ifd) {
        super(true, nativeMetadataFormatName, nativeMetadataFormatClassName, null, null);
        this.tagSets = ifd.getTagSets();
        this.rootIFD = ifd;
    }

    public void initializeFromStream(ImageInputStream stream) throws IOException {
        this.rootIFD.initialize(stream);
    }

    public void addShortOrLongField(int tagNumber, int value) {
        TIFFField field = new TIFFField(this.rootIFD.getTag(tagNumber), value);
        this.rootIFD.addTIFFField(field);
    }

    public boolean isReadOnly() {
        return false;
    }

    private Node getIFDAsTree(TIFFIFD ifd, String parentTagName, int parentTagNumber) {
        Iterator iter;
        List tagSets;
        IIOMetadataNode IFDRoot = new IIOMetadataNode("TIFFIFD");
        if (parentTagNumber != 0) {
            IFDRoot.setAttribute("parentNumber", Integer.toString(parentTagNumber));
        }
        if (parentTagName != null) {
            IFDRoot.setAttribute("parentName", parentTagName);
        }
        if ((tagSets = ifd.getTagSets()).size() > 0) {
            iter = tagSets.iterator();
            String tagSetNames = "";
            while (iter.hasNext()) {
                TIFFTagSet tagSet = (TIFFTagSet)iter.next();
                tagSetNames = tagSetNames + tagSet.getClass().getName();
                if (!iter.hasNext()) continue;
                tagSetNames = tagSetNames + ",";
            }
            IFDRoot.setAttribute("tagSets", tagSetNames);
        }
        iter = ifd.iterator();
        while (iter.hasNext()) {
            TIFFField f = (TIFFField)iter.next();
            int tagNumber = f.getTagNumber();
            TIFFTag tag = TIFFIFD.getTag(tagNumber, tagSets);
            Node node = null;
            if (tag == null) {
                IIOMetadataNode n = new IIOMetadataNode("TIFFField");
                n.setAttribute("number", Integer.toString(tagNumber));
                node = n;
            } else if (tag.isIFDPointer()) {
                TIFFIFD subIFD = (TIFFIFD)f.getData();
                node = this.getIFDAsTree(subIFD, tag.getName(), tag.getNumber());
            } else {
                node = f.getNativeNode();
            }
            if (node == null) continue;
            IFDRoot.appendChild(node);
        }
        return IFDRoot;
    }

    public Node getAsTree(String formatName) {
        if (formatName.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (formatName.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    private Node getNativeTree() {
        IIOMetadataNode root = new IIOMetadataNode(nativeMetadataFormatName);
        Node IFDNode = this.getIFDAsTree(this.rootIFD, null, 0);
        root.appendChild(IFDNode);
        return root;
    }

    public IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode chroma_node = new IIOMetadataNode("Chroma");
        IIOMetadataNode node = null;
        TIFFField f = this.getTIFFField(262);
        if (f != null) {
            int photometricInterpretation = f.getAsInt(0);
            if (photometricInterpretation > 0 && photometricInterpretation < colorSpaceNames.length) {
                node = new IIOMetadataNode("ColorSpaceType");
                node.setAttribute("name", colorSpaceNames[photometricInterpretation]);
                chroma_node.appendChild(node);
            }
            node = new IIOMetadataNode("BlackIsZero");
            node.setAttribute("value", photometricInterpretation == 0 ? "false" : "true");
            chroma_node.appendChild(node);
        }
        if ((f = this.getTIFFField(258)) != null) {
            int numChannels = f.getCount();
            node = new IIOMetadataNode("NumChannels");
            node.setAttribute("value", Integer.toString(numChannels));
            chroma_node.appendChild(node);
        }
        if ((f = this.getTIFFField(320)) != null) {
            boolean hasAlpha = false;
            node = new IIOMetadataNode("Palette");
            int idx = 0;
            int len = f.getCount() / (hasAlpha ? 4 : 3);
            int i = 0;
            while (i < len) {
                IIOMetadataNode entry = new IIOMetadataNode("PaletteEntry");
                entry.setAttribute("index", Integer.toString(i));
                int r = f.getAsInt(idx++);
                int g = f.getAsInt(idx++);
                int b2 = f.getAsInt(idx++);
                entry.setAttribute("red", Integer.toString(r));
                entry.setAttribute("green", Integer.toString(g));
                entry.setAttribute("blue", Integer.toString(b2));
                if (hasAlpha) {
                    int alpha = 0;
                    entry.setAttribute("alpha", Integer.toString(alpha));
                }
                node.appendChild(entry);
                ++i;
            }
            chroma_node.appendChild(node);
        }
        return chroma_node;
    }

    public IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode compression_node = new IIOMetadataNode("Compression");
        IIOMetadataNode node = null;
        TIFFField f = this.getTIFFField(259);
        if (f != null) {
            int compression = f.getAsInt(0);
            if (compression >= 0 && compression < this.compressionTypeNames.length) {
                node = new IIOMetadataNode("CompressionTypeName");
                node.setAttribute("value", this.compressionTypeNames[compression]);
                compression_node.appendChild(node);
            }
            boolean isLossless = compression != 6 && compression != 7;
            node = new IIOMetadataNode("Lossless");
            node.setAttribute("value", isLossless ? "true" : "false");
            compression_node.appendChild(node);
        }
        node = new IIOMetadataNode("NumProgressiveScans");
        node.setAttribute("value", "1");
        compression_node.appendChild(node);
        return compression_node;
    }

    private String repeat(String s, int times) {
        if (times == 1) {
            return s;
        }
        StringBuffer sb = new StringBuffer((s.length() + 1) * times - 1);
        sb.append(s);
        int i = 1;
        while (i < times) {
            sb.append(" ");
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }

    public IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode data_node = new IIOMetadataNode("Data");
        IIOMetadataNode node = null;
        TIFFField f = this.getTIFFField(284);
        String planarConfiguration = "PixelInterleaved";
        if (f != null && f.getAsInt(0) == 2) {
            planarConfiguration = "PlaneInterleaved";
        }
        node = new IIOMetadataNode("PlanarConfiguration");
        node.setAttribute("value", planarConfiguration);
        data_node.appendChild(node);
        f = this.getTIFFField(262);
        if (f != null) {
            int photometricInterpretation = f.getAsInt(0);
            String sampleFormat = "UnsignedIntegral";
            if (photometricInterpretation == 3) {
                sampleFormat = "Index";
            } else {
                f = this.getTIFFField(339);
                if (f != null) {
                    int format = f.getAsInt(0);
                    sampleFormat = format == 2 ? "SignedIntegral" : (format == 3 ? "Real" : null);
                }
            }
            if (sampleFormat != null) {
                node = new IIOMetadataNode("SampleFormat");
                node.setAttribute("value", sampleFormat);
                data_node.appendChild(node);
            }
        }
        if ((f = this.getTIFFField(258)) != null) {
            int[] bitsPerSample = f.getAsInts();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < bitsPerSample.length) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(Integer.toString(bitsPerSample[i]));
                ++i;
            }
            node = new IIOMetadataNode("BitsPerSample");
            node.setAttribute("value", sb.toString());
            data_node.appendChild(node);
        }
        return data_node;
    }

    public IIOMetadataNode getStandardDimensionNode() {
        int o;
        IIOMetadataNode dimension_node = new IIOMetadataNode("Dimension");
        IIOMetadataNode node = null;
        long[] xres = null;
        long[] yres = null;
        TIFFField f = this.getTIFFField(282);
        if (f != null) {
            xres = f.getAsRational(0);
        }
        if ((f = this.getTIFFField(283)) != null) {
            yres = f.getAsRational(0);
        }
        if (xres != null && yres != null) {
            node = new IIOMetadataNode("PixelAspectRatio");
            float ratio = (float)((double)xres[1] * (double)yres[0]) / (float)(xres[0] * yres[1]);
            node.setAttribute("value", Float.toString(ratio));
            dimension_node.appendChild(node);
        }
        boolean gotPixelSize = false;
        if (xres != null || yres != null) {
            f = this.getTIFFField(296);
            if (f != null) {
                int resolutionUnit = f.getAsInt(0);
                if (resolutionUnit == 3) {
                    gotPixelSize = true;
                } else if (resolutionUnit == 2) {
                    if (xres != null) {
                        xres[0] = xres[0] * 100L;
                        xres[1] = xres[1] * 254L;
                    }
                    if (yres != null) {
                        yres[0] = yres[0] * 100L;
                        yres[1] = yres[1] * 254L;
                    }
                    gotPixelSize = true;
                }
            }
            if (gotPixelSize) {
                if (xres != null) {
                    float horizontalPixelSize = (float)(10.0 * (double)xres[1] / (double)xres[0]);
                    node = new IIOMetadataNode("HorizontalPixelSize");
                    node.setAttribute("value", Float.toString(horizontalPixelSize));
                    dimension_node.appendChild(node);
                }
                if (yres != null) {
                    float verticalPixelSize = (float)(10.0 * (double)yres[1] / (double)yres[0]);
                    node = new IIOMetadataNode("VerticalPixelSize");
                    node.setAttribute("value", Float.toString(verticalPixelSize));
                    dimension_node.appendChild(node);
                }
            }
        }
        if ((f = this.getTIFFField(274)) != null && (o = f.getAsInt(0)) >= 0 && o < orientationNames.length) {
            node = new IIOMetadataNode("ImageOrientation");
            node.setAttribute("value", orientationNames[o]);
            dimension_node.appendChild(node);
        }
        return dimension_node;
    }

    private void addAttribute(IIOMetadataNode node, String attrName, StringTokenizer st) {
        int val = Integer.parseInt(st.nextToken());
        node.setAttribute(attrName, Integer.toString(val));
    }

    public IIOMetadataNode getStandardDocumentNode() {
        IIOMetadataNode document_node = new IIOMetadataNode("Document");
        IIOMetadataNode node = null;
        TIFFField f = this.getTIFFField(306);
        if (f != null) {
            String s = f.getAsString(0);
            StringTokenizer st = new StringTokenizer(s, ": ");
            node = new IIOMetadataNode("ImageCreationTime");
            this.addAttribute(node, "year", st);
            this.addAttribute(node, "month", st);
            this.addAttribute(node, "day", st);
            this.addAttribute(node, "hour", st);
            this.addAttribute(node, "minute", st);
            this.addAttribute(node, "second", st);
            document_node.appendChild(node);
        }
        return document_node;
    }

    private static void fatal(Node node, String reason) throws IIOInvalidTreeException {
        throw new IIOInvalidTreeException(reason, node);
    }

    private void mergeStandardTree(Node root) throws IIOInvalidTreeException {
        Node node = root;
        if (!node.getNodeName().equals("javax_imageio_1.0")) {
            TIFFImageMetadata.fatal(node, "Root must be javax_imageio_1.0");
        }
        node = node.getFirstChild();
        while (node != null) {
            TIFFField f;
            String name = node.getNodeName();
            if (name.equals("Chroma")) {
                Node child = node.getFirstChild();
                while (child != null) {
                    String childName = child.getNodeName();
                }
                continue;
            }
            if (name.equals("Compression")) {
                Node child = node.getFirstChild();
                while (child != null) {
                    String childName = child.getNodeName();
                }
                continue;
            }
            if (name.equals("Data")) {
                Node child = node.getFirstChild();
                while (child != null) {
                    String childName = child.getNodeName();
                    if (!childName.equals("PlanarConfiguration") && !childName.equals("SampleFormat") && !childName.equals("BitsPerSample")) continue;
                }
                continue;
            }
            if (name.equals("Dimension")) {
                float pixelAspectRatio = -1.0f;
                boolean gotPixelAspectRatio = false;
                float horizontalPixelSize = -1.0f;
                boolean gotHorizontalPixelSize = false;
                float verticalPixelSize = -1.0f;
                boolean gotVerticalPixelSize = false;
                boolean sizeIsAbsolute = false;
                Node child = node.getFirstChild();
                block4: while (child != null) {
                    String childName = child.getNodeName();
                    if (childName.equals("PixelAspectRatio")) {
                        String par = TIFFImageMetadata.getAttribute(child, "value");
                        pixelAspectRatio = Float.parseFloat(par);
                        gotPixelAspectRatio = true;
                        continue;
                    }
                    if (childName.equals("ImageOrientation")) {
                        String orientation = TIFFImageMetadata.getAttribute(child, "value");
                        int i = 0;
                        while (i < orientationNames.length) {
                            if (orientation.equals(orientationNames[i])) {
                                int[] oData = new int[]{i};
                                f = new TIFFField(this.rootIFD.getTag(274), 3, 1, oData);
                                this.rootIFD.addTIFFField(f);
                                continue block4;
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (childName.equals("HorizontalPixelSize")) {
                        String hps = TIFFImageMetadata.getAttribute(child, "value");
                        horizontalPixelSize = Float.parseFloat(hps);
                        gotHorizontalPixelSize = true;
                        continue;
                    }
                    if (!childName.equals("VerticalPixelSize")) continue;
                    String vps = TIFFImageMetadata.getAttribute(child, "value");
                    verticalPixelSize = Float.parseFloat(vps);
                    gotVerticalPixelSize = true;
                }
                boolean bl = sizeIsAbsolute = gotHorizontalPixelSize || gotVerticalPixelSize;
                if (gotPixelAspectRatio) {
                    if (gotHorizontalPixelSize && !gotVerticalPixelSize) {
                        verticalPixelSize = horizontalPixelSize / pixelAspectRatio;
                        gotVerticalPixelSize = true;
                    } else if (gotVerticalPixelSize && !gotHorizontalPixelSize) {
                        horizontalPixelSize = verticalPixelSize * pixelAspectRatio;
                        gotHorizontalPixelSize = true;
                    } else if (!gotHorizontalPixelSize && !gotVerticalPixelSize) {
                        horizontalPixelSize = pixelAspectRatio;
                        verticalPixelSize = 1.0f;
                        gotHorizontalPixelSize = true;
                        gotVerticalPixelSize = true;
                    }
                }
                if (gotHorizontalPixelSize) {
                    float xResolution = 10.0f / horizontalPixelSize;
                    long[][] hData = new long[1][2];
                    hData[0] = new long[2];
                    hData[0][0] = (long)(xResolution * 10000.0f);
                    hData[0][1] = 10000L;
                    f = new TIFFField(this.rootIFD.getTag(282), 5, 1, hData);
                    this.rootIFD.addTIFFField(f);
                }
                if (gotVerticalPixelSize) {
                    float yResolution = 10.0f / verticalPixelSize;
                    long[][] vData = new long[1][2];
                    vData[0] = new long[2];
                    vData[0][0] = (long)(yResolution * 10000.0f);
                    vData[0][1] = 10000L;
                    f = new TIFFField(this.rootIFD.getTag(283), 5, 1, vData);
                    this.rootIFD.addTIFFField(f);
                }
                int[] res = new int[]{sizeIsAbsolute ? 3 : 1};
                f = new TIFFField(this.rootIFD.getTag(296), 3, 1, res);
                this.rootIFD.addTIFFField(f);
                continue;
            }
            if (name.equals("Document")) {
                Node child = node.getFirstChild();
                while (child != null) {
                    String childName = child.getNodeName();
                    if (!childName.equals("ImageCreationTime")) continue;
                    String year = TIFFImageMetadata.getAttribute(child, "year");
                    String month = TIFFImageMetadata.getAttribute(child, "month");
                    String day = TIFFImageMetadata.getAttribute(child, "day");
                    String hour = TIFFImageMetadata.getAttribute(child, "hour");
                    String minute = TIFFImageMetadata.getAttribute(child, "minute");
                    String second = TIFFImageMetadata.getAttribute(child, "second");
                    StringBuffer sb = new StringBuffer();
                    sb.append(year);
                    sb.append(":");
                    sb.append(month);
                    sb.append(":");
                    sb.append(day);
                    sb.append(" ");
                    sb.append(hour);
                    sb.append(":");
                    sb.append(minute);
                    sb.append(":");
                    sb.append(second);
                    String[] dt = new String[]{sb.toString()};
                    f = new TIFFField(this.rootIFD.getTag(306), 2, 1, dt);
                    this.rootIFD.addTIFFField(f);
                }
                continue;
            }
            if (name.equals("Text") || !name.equals("Transparency")) continue;
            Node child = node.getFirstChild();
            while (child != null) {
                String childName = child.getNodeName();
                if (!childName.equals("Alpha")) continue;
                String alpha = TIFFImageMetadata.getAttribute(child, "value");
                f = null;
                if (alpha.equals("premultiplied")) {
                    f = new TIFFField(this.rootIFD.getTag(338), 1);
                } else if (alpha.equals("nonpremultiplied")) {
                    f = new TIFFField(this.rootIFD.getTag(338), 2);
                }
                if (f == null) continue;
                this.rootIFD.addTIFFField(f);
            }
        }
    }

    private static String getAttribute(Node node, String attrName) {
        NamedNodeMap attrs = node.getAttributes();
        return attrs.getNamedItem(attrName).getNodeValue();
    }

    public static TIFFIFD parseIFD(Node node) throws IIOInvalidTreeException {
        if (!node.getNodeName().equals("TIFFIFD")) {
            TIFFImageMetadata.fatal(node, "Expected \"TIFFIFD\" node");
        }
        String tagSetNames = TIFFImageMetadata.getAttribute(node, "tagSets");
        ArrayList<TIFFTagSet> tagSets = new ArrayList<TIFFTagSet>(5);
        if (tagSetNames != null) {
            StringTokenizer st = new StringTokenizer(tagSetNames, ",");
            while (st.hasMoreTokens()) {
                String className = st.nextToken();
                Object o = null;
                try {
                    Class<?> setClass = Class.forName(className);
                    Method getInstanceMethod = setClass.getMethod("getInstance", null);
                    o = getInstanceMethod.invoke(null, null);
                }
                catch (NoSuchMethodException e) {
                    System.out.println(e);
                }
                catch (IllegalAccessException e) {
                    System.out.println(e);
                }
                catch (InvocationTargetException e) {
                    System.out.println(e);
                }
                catch (ClassNotFoundException e) {
                    System.out.println(e);
                }
                if (!(o instanceof TIFFTagSet)) {
                    TIFFImageMetadata.fatal(node, "Specified tag set class \"" + className + "\" is not an instance of TIFFTagSet");
                    continue;
                }
                tagSets.add((TIFFTagSet)o);
            }
        }
        TIFFIFD ifd = new TIFFIFD(tagSets);
        node = node.getFirstChild();
        while (node != null) {
            String name = node.getNodeName();
            TIFFField f = null;
            if (name.equals("TIFFIFD")) {
                TIFFIFD subIFD = TIFFImageMetadata.parseIFD(node);
                String parentTagName = TIFFImageMetadata.getAttribute(node, "parentName");
                String parentTagNumber = TIFFImageMetadata.getAttribute(node, "parentNumber");
                TIFFTag tag = TIFFIFD.getTag(parentTagName, tagSets);
                int type = tag.isDataTypeOK(13) ? 13 : 4;
                f = new TIFFField(tag, type, 1, subIFD);
            } else if (name.equals("TIFFField")) {
                int number = Integer.parseInt(TIFFImageMetadata.getAttribute(node, "number"));
                TIFFTagSet tagSet = null;
                Iterator iter = tagSets.iterator();
                while (iter.hasNext()) {
                    TIFFTagSet t = (TIFFTagSet)iter.next();
                    if (t.getTag(number) == null) continue;
                    tagSet = t;
                    break;
                }
                f = new TIFFField(tagSet, node);
            } else {
                TIFFImageMetadata.fatal(node, "Expected either \"TIFFIFD\" or \"TIFFField\" node, got " + name);
            }
            ifd.addTIFFField(f);
            node = node.getNextSibling();
        }
        return ifd;
    }

    private void mergeNativeTree(Node root) throws IIOInvalidTreeException {
        Node node = root;
        if (!node.getNodeName().equals(nativeMetadataFormatName)) {
            TIFFImageMetadata.fatal(node, "Root must be com_sun_media_imageio_plugins_tiff_image_1.0");
        }
        if ((node = node.getFirstChild()) == null) {
            TIFFImageMetadata.fatal(root, "Root must have \"TIFFIFD\" child");
        }
        this.rootIFD = TIFFImageMetadata.parseIFD(node);
    }

    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        if (formatName.equals(nativeMetadataFormatName)) {
            if (root == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeNativeTree(root);
        } else if (formatName.equals("javax_imageio_1.0")) {
            if (root == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeStandardTree(root);
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
    }

    public void reset() {
        this.rootIFD = new TIFFIFD(this.tagSets);
    }

    public TIFFIFD getRootIFD() {
        return this.rootIFD;
    }

    public TIFFField getTIFFField(int tagNumber) {
        return this.rootIFD.getTIFFField(tagNumber);
    }

    public void removeTIFFField(int tagNumber) {
        this.rootIFD.getTIFFField(tagNumber);
    }

    static {
        nativeMetadataFormatName = nativeMetadataFormatName;
        nativeMetadataFormatClassName = nativeMetadataFormatClassName;
        colorSpaceNames = new String[]{"GRAY", "GRAY", "RGB", "RGB", "GRAY", null, "YCbCr", "Lab", "Lab"};
        orientationNames = new String[]{null, "Normal", "FlipH", "Rotate180", "FlipV", "FlipHRotate90", "Rotate270", "FlipVRotate90", "Rotate90"};
    }
}

