/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class TIFFImageReaderSpi
extends ImageReaderSpi {
    private static final String vendorName = "Sun Microsystems, Inc.";
    private static final String version = "1.0";
    private static final String[] names;
    private static final String[] suffixes;
    private static final String[] MIMETypes;
    private static final String readerClassName = "com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader";
    private static final String[] writerSpiNames;

    public TIFFImageReaderSpi() {
        super(vendorName, version, names, suffixes, MIMETypes, readerClassName, ImageReaderSpi.STANDARD_INPUT_TYPE, writerSpiNames, false, "com_sun_media_imageio_plugins_tiff_stream_1.0", "com.sun.media.imageioimpl.plugins.tiff.TIFFStreamMetadataFormat", null, null, true, "com_sun_media_imageio_plugins_tiff_image_1.0", "com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadataFormat", null, null);
    }

    public String getDescription(Locale locale) {
        return "Standard TIFF image reader";
    }

    public boolean canDecodeInput(Object input) throws IOException {
        if (!(input instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream stream = (ImageInputStream)input;
        byte[] b2 = new byte[4];
        stream.mark();
        stream.readFully(b2);
        stream.reset();
        return b2[0] == 73 && b2[1] == 73 && b2[2] == 42 && b2[3] == 0 || b2[0] == 77 && b2[1] == 77 && b2[2] == 0 && b2[3] == 42;
    }

    public ImageReader createReaderInstance(Object extension) {
        return new TIFFImageReader(this);
    }

    static {
        vendorName = vendorName;
        version = version;
        names = new String[]{"tif", "TIF", "tiff", "TIFF"};
        suffixes = new String[]{"tif", "tiff"};
        MIMETypes = new String[]{"image/tiff"};
        readerClassName = readerClassName;
        writerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.tiff.TIFFImageWriterSpi"};
    }
}

