/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.BaselineTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.TIFFCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFField;
import com.sun.media.imageioimpl.plugins.tiff.TIFFIFD;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class TIFFJPEGCompressor
extends TIFFCompressor {
    static final int CHROMA_SUBSAMPLING = 2;
    JPEGImageWriteParam JPEGParam = null;
    ImageWriter JPEGWriter = null;

    public TIFFJPEGCompressor(ImageWriteParam param) {
        super("JPEG", 7, false);
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
        if (!iter.hasNext()) {
            throw new IllegalStateException("No JPEG writers found!");
        }
        this.JPEGWriter = iter.next();
        if (!this.JPEGWriter.getClass().getName().startsWith("com.sun.imageio")) {
            while (iter.hasNext()) {
                ImageWriter nextWriter = iter.next();
                if (!nextWriter.getClass().getName().startsWith("com.sun.imageio")) continue;
                this.JPEGWriter = nextWriter;
            }
        }
        if (param != null && param instanceof JPEGImageWriteParam) {
            this.JPEGParam = (JPEGImageWriteParam)param;
        } else {
            this.JPEGParam = new JPEGImageWriteParam(this.writer != null ? this.writer.getLocale() : null);
            this.JPEGParam.setCompressionMode(2);
            this.JPEGParam.setCompressionQuality(param.getCompressionQuality());
        }
    }

    public void setMetadata(IIOMetadata metadata) {
        super.setMetadata(metadata);
        if (metadata instanceof TIFFImageMetadata) {
            TIFFImageMetadata tim = (TIFFImageMetadata)metadata;
            TIFFIFD rootIFD = tim.getRootIFD();
            BaselineTIFFTagSet base = BaselineTIFFTagSet.getInstance();
            TIFFField f = tim.getTIFFField(277);
            int numBands = f.getAsInt(0);
            rootIFD.removeTIFFField(347);
            if (numBands == 1) {
                rootIFD.removeTIFFField(530);
                rootIFD.removeTIFFField(531);
                rootIFD.removeTIFFField(532);
            } else {
                TIFFField YCbCrSubSamplingField = new TIFFField(base.getTag(530), 3, 2, new char[]{'\u0002', '\u0002'});
                rootIFD.addTIFFField(YCbCrSubSamplingField);
                TIFFField YCbCrPositioningField = new TIFFField(base.getTag(531), 3, 1, new char[]{'\u0001'});
                rootIFD.addTIFFField(YCbCrPositioningField);
                TIFFField referenceBlackWhiteField = new TIFFField(base.getTag(532), 5, 6, new long[][]{{0L, 1L}, {255L, 1L}, {128L, 1L}, {255L, 1L}, {128L, 1L}, {255L, 1L}});
                rootIFD.addTIFFField(referenceBlackWhiteField);
                f = tim.getTIFFField(347);
                if (f == null) {
                    // empty if block
                }
            }
        }
    }

    public int encode(byte[] b2, int off, int width, int height, int[] bitsPerSample, int scanlineStride) throws IOException {
        ColorSpace cs;
        int[] offsets;
        DataBufferByte dbb;
        if (!(bitsPerSample.length == 3 && bitsPerSample[0] == 8 && bitsPerSample[1] == 8 && bitsPerSample[2] == 8 || bitsPerSample.length == 1 && bitsPerSample[0] == 8)) {
            throw new IIOException("Can only JPEG compress 8- and 24-bit images!");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(baos);
        this.JPEGWriter.setOutput(ios);
        if (off == 0) {
            dbb = new DataBufferByte(b2, b2.length - off, off);
        } else {
            byte[] btmp = new byte[b2.length - off];
            System.arraycopy(b2, off, btmp, 0, b2.length - off);
            dbb = new DataBufferByte(btmp, btmp.length, 0);
        }
        if (bitsPerSample.length == 3) {
            offsets = new int[]{0, 1, 2};
            cs = ColorSpace.getInstance(1000);
        } else {
            offsets = new int[]{0};
            cs = ColorSpace.getInstance(1003);
        }
        PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(0, width, height, bitsPerSample.length, scanlineStride, offsets);
        WritableRaster wras = Raster.createWritableRaster(sm, dbb, new Point(0, 0));
        ComponentColorModel cm = new ComponentColorModel(cs, false, false, 1, 0);
        BufferedImage bi = new BufferedImage(cm, wras, false, null);
        IIOImage image = new IIOImage(bi, null, null);
        this.JPEGWriter.write(null, image, this.JPEGParam);
        byte[] compData = baos.toByteArray();
        this.stream.write(compData, 0, compData.length);
        return compData.length;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.JPEGWriter != null) {
            this.JPEGWriter.dispose();
        }
    }

    static {
        CHROMA_SUBSAMPLING = 2;
    }
}

