/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFFaxDecompressor;
import java.io.IOException;

public class TIFFLSBCompressor
extends TIFFCompressor {
    public TIFFLSBCompressor() {
        super("", 1, true);
    }

    public int encode(byte[] b2, int off, int width, int height, int[] bitsPerSample, int scanlineStride) throws IOException {
        int bitsPerPixel = 0;
        int i = 0;
        while (i < bitsPerSample.length) {
            bitsPerPixel += bitsPerSample[i];
            ++i;
        }
        int bytesPerRow = (bitsPerPixel * width + 7) / 8;
        byte[] compData = new byte[bytesPerRow];
        byte[] flipTable = TIFFFaxDecompressor.flipTable;
        int row = 0;
        while (row < height) {
            System.arraycopy(b2, off, compData, 0, bytesPerRow);
            int j = 0;
            while (j < bytesPerRow) {
                compData[j] = flipTable[compData[j] & 0xFF];
                ++j;
            }
            this.stream.write(compData, 0, bytesPerRow);
            off += scanlineStride;
            ++row;
        }
        return height * bytesPerRow;
    }
}

