/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.wbmp;

import com.sun.media.imageioimpl.plugins.wbmp.I18N;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class WBMPImageWriter
extends ImageWriter {
    private ImageOutputStream stream = null;

    private static int getNumBits(int intValue) {
        int numBits = 32;
        int mask = Integer.MIN_VALUE;
        while (mask != 0 && (intValue & mask) == 0) {
            --numBits;
            mask >>>= 1;
        }
        return numBits;
    }

    private static byte[] intToMultiByte(int intValue) {
        int numBitsLeft = WBMPImageWriter.getNumBits(intValue);
        byte[] multiBytes = new byte[(numBitsLeft + 6) / 7];
        int maxIndex = multiBytes.length - 1;
        int b2 = 0;
        while (b2 <= maxIndex) {
            multiBytes[b2] = (byte)(intValue >>> (maxIndex - b2) * 7 & 0x7F);
            if (b2 != maxIndex) {
                int n = b2;
                multiBytes[n] = (byte)(multiBytes[n] | 0xFFFFFF80);
            }
            ++b2;
        }
        return multiBytes;
    }

    public WBMPImageWriter(ImageWriterSpi originator) {
        super(originator);
    }

    public void setOutput(Object output) {
        super.setOutput(output);
        if (output != null) {
            if (!(output instanceof ImageOutputStream)) {
                throw new IllegalArgumentException(I18N.getString("WBMPImageWriter"));
            }
            this.stream = (ImageOutputStream)output;
        } else {
            this.stream = null;
        }
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata metadata, ImageTypeSpecifier type, ImageWriteParam param) {
        return null;
    }

    public boolean canWriteRasters() {
        return true;
    }

    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        this.clearAbortRequest();
        this.processImageStarted(0);
        if (param == null) {
            param = this.getDefaultWriteParam();
        }
        RenderedImage input = null;
        Raster inputRaster = null;
        boolean writeRaster = image.hasRaster();
        Rectangle sourceRegion = param.getSourceRegion();
        SampleModel sampleModel = null;
        if (writeRaster) {
            inputRaster = image.getRaster();
            sampleModel = inputRaster.getSampleModel();
        } else {
            input = image.getRenderedImage();
            sampleModel = input.getSampleModel();
            inputRaster = input.getData();
        }
        this.checkSampleModel(sampleModel);
        sourceRegion = sourceRegion == null ? inputRaster.getBounds() : sourceRegion.intersection(inputRaster.getBounds());
        if (sourceRegion.isEmpty()) {
            throw new RuntimeException(I18N.getString("WBMPImageWriter1"));
        }
        int scaleX = param.getSourceXSubsampling();
        int scaleY = param.getSourceYSubsampling();
        int xOffset = param.getSubsamplingXOffset();
        int yOffset = param.getSubsamplingYOffset();
        sourceRegion.translate(xOffset, yOffset);
        sourceRegion.width -= xOffset;
        sourceRegion.height -= yOffset;
        int minX = sourceRegion.x / scaleX;
        int minY = sourceRegion.y / scaleY;
        int w = (sourceRegion.width + scaleX - 1) / scaleX;
        int h = (sourceRegion.height + scaleY - 1) / scaleY;
        Rectangle destinationRegion = new Rectangle(minX, minY, w, h);
        SampleModel destSM = sampleModel = sampleModel.createCompatibleSampleModel(w, h);
        if (sampleModel.getDataType() != 0 || !(sampleModel instanceof MultiPixelPackedSampleModel) || ((MultiPixelPackedSampleModel)sampleModel).getDataBitOffset() != 0) {
            destSM = new MultiPixelPackedSampleModel(0, w, h, 1, w + 7 >> 3, 0);
        }
        if (!destinationRegion.equals(sourceRegion)) {
            if (scaleX == 1 && scaleY == 1) {
                inputRaster = inputRaster.createChild(inputRaster.getMinX(), inputRaster.getMinY(), w, h, minX, minY, null);
            } else {
                WritableRaster ras = Raster.createWritableRaster(destSM, new Point(minX, minY));
                byte[] data = ((DataBufferByte)ras.getDataBuffer()).getData();
                int j = minY;
                int y = sourceRegion.y;
                int k = 0;
                while (j < minY + h) {
                    int i = 0;
                    int x = sourceRegion.x;
                    while (i < w) {
                        int v = inputRaster.getSample(x, y, 0);
                        int n = k + (i >> 3);
                        data[n] = (byte)(data[n] | v << 7 - (i & 7));
                        ++i;
                        x += scaleX;
                    }
                    k += w + 7 >> 3;
                    ++j;
                    y += scaleY;
                }
                inputRaster = ras;
            }
        }
        if (!destSM.equals(inputRaster.getSampleModel())) {
            WritableRaster raster = Raster.createWritableRaster(destSM, new Point(inputRaster.getMinX(), inputRaster.getMinY()));
            raster.setRect(inputRaster);
            inputRaster = raster;
        }
        boolean isWhiteZero = false;
        if (!writeRaster && input.getColorModel() instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)input.getColorModel();
            isWhiteZero = icm.getRed(0) > icm.getRed(1);
        }
        int lineStride = ((MultiPixelPackedSampleModel)destSM).getScanlineStride();
        int bytesPerRow = (w + 7) / 8;
        byte[] bdata = ((DataBufferByte)inputRaster.getDataBuffer()).getData();
        this.stream.write(0);
        this.stream.write(0);
        this.stream.write(WBMPImageWriter.intToMultiByte(w));
        this.stream.write(WBMPImageWriter.intToMultiByte(h));
        if (!isWhiteZero && lineStride == bytesPerRow) {
            this.stream.write(bdata, 0, h * bytesPerRow);
            this.processImageProgress(100.0f);
        } else {
            int offset = 0;
            if (!isWhiteZero) {
                int row = 0;
                while (row < h) {
                    if (!this.abortRequested()) {
                        this.stream.write(bdata, offset, bytesPerRow);
                        offset += lineStride;
                        this.processImageProgress(100.0f * (float)row / (float)h);
                        ++row;
                        continue;
                    }
                    break;
                }
            } else {
                byte[] inverted = new byte[bytesPerRow];
                int row = 0;
                while (row < h) {
                    if (!this.abortRequested()) {
                        int col = 0;
                        while (col < bytesPerRow) {
                            inverted[col] = ~bdata[col + offset];
                            ++col;
                        }
                        this.stream.write(inverted, 0, bytesPerRow);
                        offset += lineStride;
                        this.processImageProgress(100.0f * (float)row / (float)h);
                        ++row;
                        continue;
                    }
                    break;
                }
            }
        }
        if (this.abortRequested()) {
            this.processWriteAborted();
        } else {
            this.processImageComplete();
        }
    }

    public void reset() {
        super.reset();
        this.stream = null;
    }

    private void checkSampleModel(SampleModel sm) {
        int type = sm.getDataType();
        if (type < 0 || type > 3 || sm.getNumBands() != 1 || sm.getSampleSize(0) != 1) {
            throw new IllegalArgumentException(I18N.getString("WBMPImageWriter2"));
        }
    }
}

