/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.imageioimpl;

import com.sun.media.jai.imageioimpl.I18N;
import com.sun.media.jai.imageioimpl.ImageReadCIF;
import com.sun.media.jai.imageioimpl.ImageReadOpImage;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.net.URL;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.CRIFImpl;
import javax.media.jai.CollectionImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.MultiResolutionRenderableImage;
import javax.media.jai.PropertySource;
import javax.media.jai.WritablePropertySource;

public final class ImageReadCRIF
extends CRIFImpl {
    private static ImageInputStream getImageInputStream(Object input) {
        ImageInputStream stream = null;
        if (input instanceof ImageInputStream) {
            stream = (ImageInputStream)input;
        } else {
            if (input instanceof String) {
                try {
                    input = new RandomAccessFile((String)input, "r");
                }
                catch (Exception e) {
                    throw new RuntimeException(I18N.getString("ImageReadCRIF0") + " " + input);
                }
            }
            if (input instanceof URL) {
                try {
                    input = ((URL)input).openStream();
                }
                catch (Exception e) {
                    throw new RuntimeException(I18N.getString("ImageReadCRIF1") + " " + input);
                }
            }
            if (input instanceof Socket) {
                try {
                    Socket socket = (Socket)input;
                    input = socket.getInputStream();
                }
                catch (Exception e) {
                    throw new RuntimeException(I18N.getString("ImageReadCRIF2") + " " + input);
                }
            }
        }
        try {
            stream = ImageIO.createImageInputStream(input);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return stream;
    }

    static ImageReader getImageReader(ParameterBlock pb) {
        Iterator<ImageReader> readers;
        Object input = pb.getObjectParameter(0);
        ImageReader reader = (ImageReader)pb.getObjectParameter(8);
        ImageInputStream stream = ImageReadCRIF.getImageInputStream(input);
        if (reader == null && (readers = ImageIO.getImageReaders(stream != null ? stream : input)) != null && readers.hasNext()) {
            reader = readers.next();
        }
        if (reader != null) {
            EventListener[] listeners;
            Locale locale = (Locale)pb.getObjectParameter(6);
            if (locale != null) {
                reader.setLocale(locale);
            }
            if ((listeners = (EventListener[])pb.getObjectParameter(5)) != null) {
                int i = 0;
                while (i < listeners.length) {
                    EventListener listener = listeners[i];
                    if (listener instanceof IIOReadProgressListener) {
                        reader.addIIOReadProgressListener((IIOReadProgressListener)listener);
                    }
                    if (listener instanceof IIOReadUpdateListener) {
                        reader.addIIOReadUpdateListener((IIOReadUpdateListener)listener);
                    }
                    if (listener instanceof IIOReadWarningListener) {
                        reader.addIIOReadWarningListener((IIOReadWarningListener)listener);
                    }
                    ++i;
                }
            }
            boolean readMetadata = (Boolean)pb.getObjectParameter(2);
            reader.setInput(stream != null ? stream : input, false, !readMetadata);
        }
        return reader;
    }

    static void copyProperty(PropertySource ps, WritablePropertySource wps, String propertyName) {
        Object propertyValue = ps.getProperty(propertyName);
        if (propertyValue != null && !propertyValue.equals(Image.UndefinedProperty)) {
            wps.setProperty(propertyName, propertyValue);
        }
    }

    public RenderedImage create(ParameterBlock pb, RenderingHints rh) {
        ImageReadOpImage image = null;
        ImageReader reader = ImageReadCRIF.getImageReader(pb);
        if (reader != null) {
            int imageIndex = pb.getIntParameter(1);
            ImageReadParam param = (ImageReadParam)pb.getObjectParameter(7);
            boolean readThumbnails = (Boolean)pb.getObjectParameter(3);
            ImageLayout layout = rh != null && rh.containsKey(JAI.KEY_IMAGE_LAYOUT) ? (ImageLayout)rh.get(JAI.KEY_IMAGE_LAYOUT) : new ImageLayout();
            try {
                Object paramInput = pb.getObjectParameter(0);
                Object readerInput = reader.getInput();
                ImageInputStream streamToClose = null;
                if (readerInput != paramInput && readerInput instanceof ImageInputStream) {
                    streamToClose = (ImageInputStream)readerInput;
                }
                image = new ImageReadOpImage(layout, rh, param, reader, imageIndex, readThumbnails, streamToClose);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return image;
    }

    public RenderableImage createRenderable(ParameterBlock pb, RenderingHints rh) {
        CollectionImage sequence = ImageReadCIF.createStatic(pb, rh);
        TreeMap<Dimension, RenderedImage> sourceMap = new TreeMap<Dimension, RenderedImage>(new Comparator(){

            public int compare(Object o1, Object o2) {
                double inverse2;
                Dimension d1 = (Dimension)o1;
                Dimension d2 = (Dimension)o2;
                int area1 = d1.width * d1.height;
                int area2 = d2.width * d2.height;
                double inverse1 = area1 == 0 ? Double.MAX_VALUE : 1.0 / (double)area1;
                double d = inverse2 = area2 == 0 ? Double.MAX_VALUE : 1.0 / (double)area2;
                if (inverse1 < inverse2) {
                    return -1;
                }
                if (inverse1 > inverse2) {
                    return 1;
                }
                return 0;
            }

            public boolean equals(Object o1, Object o2) {
                return o1.equals(o2);
            }
        });
        Iterator images = sequence.iterator();
        while (images.hasNext()) {
            RenderedImage image = (RenderedImage)images.next();
            sourceMap.put(new Dimension(image.getWidth(), image.getHeight()), image);
        }
        Vector renderedSources = new Vector(sourceMap.size());
        Iterator keys = sourceMap.keySet().iterator();
        while (keys.hasNext()) {
            renderedSources.add(sourceMap.get(keys.next()));
        }
        MultiResolutionRenderableImage renderableImage = new MultiResolutionRenderableImage(renderedSources, 0.0f, 0.0f, 1.0f);
        PropertySource firstSource = (PropertySource)renderedSources.get(0);
        ImageReadCRIF.copyProperty(firstSource, (WritablePropertySource)renderableImage, "JAI.ImageReadParam");
        ImageReadCRIF.copyProperty(firstSource, (WritablePropertySource)renderableImage, "JAI.ImageReader");
        ImageReadCRIF.copyProperty(firstSource, (WritablePropertySource)renderableImage, "JAI.StreamMetadata");
        ImageReadCRIF.copyProperty(firstSource, (WritablePropertySource)renderableImage, "JAI.ImageMetadata");
        return renderableImage;
    }

    public RenderedImage create(RenderContext rc, ParameterBlock pb) {
        RenderableImage renderableImage = this.createRenderable(pb, rc.getRenderingHints());
        RenderedImage renderedImage = renderableImage.createRendering(rc);
        ((WritablePropertySource)renderedImage).setProperty("JAI.RenderableInput", (Object)((PropertySource)renderableImage));
        return renderedImage;
    }

    public Rectangle2D getBounds2D(ParameterBlock pb) {
        RenderableImage renderable = this.createRenderable(pb, null);
        return new Rectangle2D.Float(renderable.getMinX(), renderable.getMinY(), renderable.getWidth(), renderable.getHeight());
    }
}

