/*
 * Decompiled with CFR 0.152.
 */
package com.sun.medialib.codec.png;

import com.sun.medialib.codec.png.Constants;
import com.sun.medialib.codec.png.PNGChunk;
import com.sun.medialib.codec.png.PNGException;
import com.sun.medialib.codec.png.PNGTextualData;
import com.sun.medialib.mlib.mediaLibImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;

public final class Decoder
implements Constants {
    private int pio = 0;
    private mediaLibImage image = null;
    private int[] cHRMchunk = null;
    private int[] pHYschunk = null;
    private byte[] iCCPchunk = null;

    public static String getVersion() {
        return "png:0100:20030623:javawrapper";
    }

    public Decoder(InputStream inputStream) {
        Object[] objectArray;
        int[] nArray = new int[5];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.pio = this.decode_init(inputStream);
        this.createImage(this.pio, nArray);
        if (nArray[1] == -1) {
            this.image = null;
            return;
        }
        n2 = nArray[3];
        n = nArray[4];
        n3 = n2 * n;
        if (nArray[0] == 0 || nArray[0] == 1) {
            objectArray = new byte[n3];
        } else if (nArray[0] == 6) {
            n /= 2;
            objectArray = new short[n3 / 2];
        } else {
            this.image = null;
            return;
        }
        this.image = new mediaLibImage(nArray[0], nArray[1], nArray[2], nArray[3], n, 0, objectArray);
    }

    public Decoder() {
    }

    public mediaLibImage getImage() {
        return this.image;
    }

    public void decode1() throws IOException {
        this.decode(this.pio);
        if (this.SetData(this.image, this.pio) == 0) {
            throw new PNGException();
        }
    }

    public void Init(InputStream inputStream) throws IOException {
        this.pio = this.decode_init(inputStream);
    }

    public void decode() throws IOException {
        Object[] objectArray;
        int[] nArray = new int[5];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.createImage(this.pio, nArray);
        if (nArray[1] == -1) {
            this.image = null;
            return;
        }
        n2 = nArray[3];
        n = nArray[4];
        n3 = n2 * n;
        if (nArray[0] == 0 || nArray[0] == 1) {
            objectArray = new byte[n3];
        } else if (nArray[0] == 6) {
            n /= 2;
            objectArray = new short[n3 / 2];
        } else {
            this.image = null;
            return;
        }
        this.image = new mediaLibImage(nArray[0], nArray[1], nArray[2], nArray[3], n, 0, objectArray);
        this.decode(this.pio);
        if (this.SetData(this.image, this.pio) == 0) {
            throw new PNGException();
        }
    }

    public final void setUnroll(boolean bl) {
        if (bl) {
            this.setUnroll(this.pio, 1);
        } else {
            this.setUnroll(this.pio, 0);
        }
    }

    public final int getBitDepth() {
        return this.getBitDepth(this.pio);
    }

    public final byte[] getPalette() {
        return this.getPalette(this.pio);
    }

    public final short[] getHistogram() {
        return this.getHistogram(this.pio);
    }

    public final int[] getTransparency() {
        return this.getTransparency(this.pio);
    }

    public final int[] getBackground() {
        return this.getBackground(this.pio);
    }

    public final int getPrimaryChromaticities(int n) {
        if (this.cHRMchunk == null) {
            this.cHRMchunk = this.getChromaticities(this.pio);
            if (this.cHRMchunk == null) {
                return -1;
            }
        }
        switch (n) {
            case 0: {
                return this.cHRMchunk[0];
            }
            case 1: {
                return this.cHRMchunk[1];
            }
            case 2: {
                return this.cHRMchunk[2];
            }
            case 3: {
                return this.cHRMchunk[3];
            }
            case 4: {
                return this.cHRMchunk[4];
            }
            case 5: {
                return this.cHRMchunk[5];
            }
            case 6: {
                return this.cHRMchunk[6];
            }
            case 7: {
                return this.cHRMchunk[7];
            }
        }
        return -1;
    }

    public final int[] getAllPrimaryChromaticities() {
        if (this.cHRMchunk == null) {
            this.cHRMchunk = this.getChromaticities(this.pio);
        }
        return this.cHRMchunk;
    }

    public final int getPhysicalPixelDimensions(int n) {
        if (this.pHYschunk == null) {
            this.pHYschunk = this.getPhysPixelDimensions(this.pio);
            if (this.pHYschunk == null) {
                return -1;
            }
        }
        switch (n) {
            case 0: {
                return this.pHYschunk[0];
            }
            case 1: {
                return this.pHYschunk[1];
            }
            case 2: {
                return this.pHYschunk[2];
            }
        }
        return -1;
    }

    public final int getImageGamma() {
        int n = this.getImageGamma(this.pio);
        if (n == -1) {
            return -1;
        }
        return n;
    }

    public final int getStandardRGB() {
        int n = this.getStandardRGB(this.pio);
        if (n == -1) {
            return -1;
        }
        return n;
    }

    public final byte[] getSignificantBits() {
        return this.getSignificantBits(this.pio);
    }

    public final PNGChunk[] getSuggestedPalette() {
        byte[] byArray;
        Vector<PNGChunk> vector = new Vector<PNGChunk>();
        int n = 0;
        while ((byArray = this.getSuggestedPalette(this.pio)) != null) {
            PNGChunk pNGChunk = new PNGChunk(1934642260, byArray);
            vector.add(pNGChunk);
            ++n;
        }
        PNGChunk[] pNGChunkArray = new PNGChunk[vector.size()];
        n = 0;
        while (n < pNGChunkArray.length) {
            pNGChunkArray[n] = (PNGChunk)vector.get(n);
            ++n;
        }
        return pNGChunkArray;
    }

    public final Object getSuggestedPaletteParameter(PNGChunk pNGChunk, int n) {
        if (pNGChunk.getID() == 1934642260) {
            return this.getsPLTparam(pNGChunk.getData(), n);
        }
        return null;
    }

    private Object getsPLTparam(byte[] byArray, int n) {
        int n2 = 0;
        byte[] byArray2 = new byte[]{0};
        int n3 = 0;
        while (n3 < byArray.length) {
            if (byArray[n3] == 0) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n == 0) {
            String string = new String(byArray, 0, n2);
            return string;
        }
        byArray2[0] = byArray[n2 + 1];
        if (byArray2[0] != 8 && byArray2[0] != 16) {
            return null;
        }
        if (n == 1) {
            return byArray2;
        }
        int n4 = n2 + 2;
        int n5 = byArray.length - n4;
        if (byArray2[0] == 8) {
            if (n5 % 6 != 0) {
                return null;
            }
            n5 /= 6;
            if (n == 6) {
                short[] sArray = new short[n5];
                int n6 = 0;
                while (n6 < n5) {
                    sArray[n6] = (short)((byArray[n4 + 6 * n6 + 4] & 0xFF) << 8 | byArray[n4 + 6 * n6 + 5] & 0xFF);
                    ++n6;
                }
                return sArray;
            }
            byte[] byArray3 = new byte[n5];
            if (n == 2) {
                int n7 = 0;
                while (n7 < n5) {
                    byArray3[n7] = byArray[n4 + 6 * n7];
                    ++n7;
                }
                return byArray3;
            }
            if (n == 3) {
                int n8 = 0;
                while (n8 < n5) {
                    byArray3[n8] = byArray[n4 + 6 * n8 + 1];
                    ++n8;
                }
                return byArray3;
            }
            if (n == 4) {
                int n9 = 0;
                while (n9 < n5) {
                    byArray3[n9] = byArray[n4 + 6 * n9 + 2];
                    ++n9;
                }
                return byArray3;
            }
            if (n == 5) {
                int n10 = 0;
                while (n10 < n5) {
                    byArray3[n10] = byArray[n4 + 6 * n10 + 3];
                    ++n10;
                }
                return byArray3;
            }
        } else {
            if (n5 % 10 != 0) {
                return null;
            }
            short[] sArray = new short[n5 /= 10];
            if (n == 2) {
                int n11 = 0;
                while (n11 < n5) {
                    sArray[n11] = (short)((byArray[n4 + 10 * n11 + 0] & 0xFF) << 8 | byArray[n4 + 10 * n11 + 1] & 0xFF);
                    ++n11;
                }
                return sArray;
            }
            if (n == 3) {
                int n12 = 0;
                while (n12 < n5) {
                    sArray[n12] = (short)((byArray[n4 + 10 * n12 + 2] & 0xFF) << 8 | byArray[n4 + 10 * n12 + 3] & 0xFF);
                    ++n12;
                }
                return sArray;
            }
            if (n == 4) {
                int n13 = 0;
                while (n13 < n5) {
                    sArray[n13] = (short)((byArray[n4 + 10 * n13 + 4] & 0xFF) << 8 | byArray[n4 + 10 * n13 + 5] & 0xFF);
                    ++n13;
                }
                return sArray;
            }
            if (n == 5) {
                int n14 = 0;
                while (n14 < n5) {
                    sArray[n14] = (short)((byArray[n4 + 10 * n14 + 6] & 0xFF) << 8 | byArray[n4 + 10 * n14 + 7] & 0xFF);
                    ++n14;
                }
                return sArray;
            }
            if (n == 6) {
                int n15 = 0;
                while (n15 < n5) {
                    sArray[n15] = (short)((byArray[n4 + 10 * n15 + 8] & 0xFF) << 8 | byArray[n4 + 10 * n15 + 9] & 0xFF);
                    ++n15;
                }
                return sArray;
            }
        }
        return null;
    }

    public final PNGChunk[] getUserData() {
        byte[] byArray;
        Vector<PNGChunk> vector = new Vector<PNGChunk>();
        int[] nArray = new int[]{0};
        int n = 0;
        while ((byArray = this.getUserData(this.pio, nArray)) != null) {
            PNGChunk pNGChunk = new PNGChunk(nArray[0], byArray);
            vector.add(pNGChunk);
            ++n;
        }
        PNGChunk[] pNGChunkArray = new PNGChunk[vector.size()];
        n = 0;
        while (n < pNGChunkArray.length) {
            pNGChunkArray[n] = (PNGChunk)vector.get(n);
            ++n;
        }
        return pNGChunkArray;
    }

    public final PNGTextualData[] getTextualData() {
        PNGTextualData pNGTextualData;
        String string;
        int n;
        int n2;
        String string2;
        int n3;
        byte[] byArray;
        Vector<PNGTextualData> vector = new Vector<PNGTextualData>();
        int n4 = 0;
        int n5 = 0;
        while ((byArray = this.getTextualData(this.pio, 0)) != null) {
            n3 = 0;
            while (n3 < byArray.length) {
                if (byArray[n3] == 0) {
                    n4 = n3;
                    break;
                }
                ++n3;
            }
            string2 = new String(byArray, 0, n4);
            n2 = n4 + 1;
            n = byArray.length - n2;
            string = new String(byArray, n2, n);
            pNGTextualData = new PNGTextualData(string2, string);
            vector.add(pNGTextualData);
            ++n5;
        }
        n5 = 0;
        while ((byArray = this.getTextualData(this.pio, 1)) != null) {
            n3 = 0;
            while (n3 < byArray.length) {
                if (byArray[n3] == 0) {
                    n4 = n3;
                    break;
                }
                ++n3;
            }
            string2 = new String(byArray, 0, n4);
            n2 = n4 + 2;
            n = byArray.length - n2;
            string = new String(byArray, n2, n);
            pNGTextualData = new PNGTextualData(string2, string);
            vector.add(pNGTextualData);
            ++n5;
        }
        n5 = 0;
        while ((byArray = this.getTextualData(this.pio, 2)) != null) {
            n3 = 0;
            while (n3 < byArray.length) {
                if (byArray[n3] == 0) {
                    n4 = n3;
                    break;
                }
                ++n3;
            }
            string2 = new String(byArray, 0, n4);
            int n6 = n2 = n4 + 3;
            while (n6 < byArray.length) {
                if (byArray[n6] == 0) {
                    n4 = n6;
                    break;
                }
                ++n6;
            }
            String string3 = new String(byArray, n2, n4 - n2);
            int n7 = n2 = n4 + 1;
            while (n7 < byArray.length) {
                if (byArray[n7] == 0) {
                    n4 = n7;
                    break;
                }
                ++n7;
            }
            String string4 = new String(byArray, n2, n4 - n2);
            n2 = n4 + 1;
            n = byArray.length - n2;
            string = new String(byArray, n2, n);
            pNGTextualData = new PNGTextualData(string2, string4, string, string3);
            vector.add(pNGTextualData);
            ++n5;
        }
        PNGTextualData[] pNGTextualDataArray = new PNGTextualData[vector.size()];
        n5 = 0;
        while (n5 < pNGTextualDataArray.length) {
            pNGTextualDataArray[n5] = (PNGTextualData)vector.get(n5);
            ++n5;
        }
        return pNGTextualDataArray;
    }

    public final byte[] getEmbeddedICCProfile() {
        int n = 0;
        if (this.iCCPchunk == null) {
            this.iCCPchunk = this.getEmbeddedICCProfile(this.pio);
            if (this.iCCPchunk == null) {
                return null;
            }
        }
        int n2 = 0;
        while (n2 < this.iCCPchunk.length) {
            if (this.iCCPchunk[n2] == 0) {
                n = n2 + 2;
                break;
            }
            ++n2;
        }
        int n3 = this.iCCPchunk.length - n;
        byte[] byArray = new byte[n3];
        System.arraycopy(this.iCCPchunk, n, byArray, 0, n3);
        return byArray;
    }

    public final String getEmbeddedICCProfileName() {
        int n = 0;
        if (this.iCCPchunk == null) {
            this.iCCPchunk = this.getEmbeddedICCProfile(this.pio);
            if (this.iCCPchunk == null) {
                return null;
            }
        }
        int n2 = 0;
        while (n2 < this.iCCPchunk.length) {
            if (this.iCCPchunk[n2] == 0) {
                n = n2;
                break;
            }
            ++n2;
        }
        String string = new String(this.iCCPchunk, 0, n);
        return string;
    }

    public final Calendar getLastModificationTime() {
        int n = 0;
        byte[] byArray = this.getLastModificationTime(this.pio);
        if (byArray == null) {
            return null;
        }
        int n2 = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
        byte by = byArray[3];
        byte by2 = byArray[4];
        byte by3 = byArray[5];
        byte by4 = byArray[6];
        switch (byArray[2]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            case 4: {
                n = 3;
                break;
            }
            case 5: {
                n = 4;
                break;
            }
            case 6: {
                n = 5;
                break;
            }
            case 7: {
                n = 6;
                break;
            }
            case 8: {
                n = 7;
                break;
            }
            case 9: {
                n = 8;
                break;
            }
            case 10: {
                n = 9;
                break;
            }
            case 11: {
                n = 10;
                break;
            }
            case 12: {
                n = 11;
            }
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.clear();
        gregorianCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.set(n2, n, by, by2, by3, by4);
        return gregorianCalendar;
    }

    protected void finalize() throws Throwable {
        this.decode_free(this.pio);
    }

    private native int decode_init(InputStream var1);

    private native void createImage(int var1, int[] var2);

    private native void decode(int var1);

    private native int SetData(Object var1, int var2);

    private native void setUnroll(int var1, int var2);

    private native int getBitDepth(int var1);

    private native byte[] getPalette(int var1);

    private native short[] getHistogram(int var1);

    private native int[] getTransparency(int var1);

    private native int[] getBackground(int var1);

    private native int[] getChromaticities(int var1);

    private native int[] getPhysPixelDimensions(int var1);

    private native int getImageGamma(int var1);

    private native int getStandardRGB(int var1);

    private native byte[] getSignificantBits(int var1);

    private native byte[] getSuggestedPalette(int var1);

    private native byte[] getUserData(int var1, int[] var2);

    private native byte[] getTextualData(int var1, int var2);

    private native byte[] getEmbeddedICCProfile(int var1);

    private native byte[] getLastModificationTime(int var1);

    private native void decode_free(int var1);

    static {
        System.loadLibrary("clib_jiio");
    }
}

