/*
 * Decompiled with CFR 0.152.
 */
package com.sun.medialib.codec.png;

import com.sun.medialib.codec.png.Constants;
import com.sun.medialib.codec.png.PNGException;
import com.sun.medialib.mlib.mediaLibImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class Encoder
implements Constants {
    private int encoder = 0;
    private mediaLibImage img;
    private int interlaceMethod = 0;
    private byte[] dataPLTE = null;
    private int BitDepth = 0;
    private boolean hassRGB = false;
    private boolean hasiCCP = false;

    public static String getVersion() {
        return "png:0100:20030623:javawrapper";
    }

    public Encoder(mediaLibImage mediaLibImage2) {
        this.img = mediaLibImage2;
        this.encoder = this.encode_init();
    }

    public Encoder() {
    }

    public final void Init(mediaLibImage mediaLibImage2) throws IOException {
        this.dataPLTE = null;
        this.hassRGB = false;
        this.hasiCCP = false;
        this.img = mediaLibImage2;
        this.encoder = this.encode_init();
        this.setBitDepth(this.encoder, this.BitDepth);
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(outputStream, this.img, this.encoder, this.interlaceMethod);
    }

    public final void setIDATSize(int n) {
        this.setIDATSize(this.encoder, n);
    }

    public final void setCompressionLevel(int n) {
        this.setCompressionLevel(this.encoder, n);
    }

    public final void setStrategy(int n) {
        this.setStrategy(this.encoder, n);
    }

    public final void setBitDepth(int n) {
        this.BitDepth = n;
    }

    public final void setInterlaceMethod(int n) {
        this.interlaceMethod = n == 1 ? 1 : 0;
    }

    public final void setImageGamma(int n) {
        if (!this.hassRGB) {
            this.setImageGamma(this.encoder, n);
        }
    }

    public final void setPalette(byte[] byArray) {
        if (byArray != null) {
            if (byArray.length % 3 != 0 || byArray.length > 768) {
                throw new PNGException(6, "[PLTE]");
            }
        } else {
            throw new PNGException(6, "[PLTE]");
        }
        this.dataPLTE = byArray;
        this.setPalette(this.encoder, byArray, byArray.length / 3);
    }

    public final void setTextualData(String string, String string2, boolean bl) {
        if (string.length() > 79) {
            string = new String(string.getBytes(), 0, 79);
        }
        String string3 = string + '\u0000';
        byte[] byArray = (string2 + '\u0000').getBytes();
        byte[] byArray2 = string3.getBytes();
        if (bl) {
            this.setCompressedTextualData(this.encoder, byArray2, byArray);
        } else {
            this.setTextualData(this.encoder, byArray2, byArray);
        }
    }

    public final void setTextualData(String string, String string2) {
        this.setTextualData(string, string2, false);
    }

    public final void setUnicodeTextualData(String string, String string2, String string3, String string4, boolean bl) {
        if (string.length() > 79) {
            string = new String(string.getBytes(), 0, 79);
        }
        byte[] byArray = (string + '\u0000').getBytes();
        byte[] byArray2 = (string2 + '\u0000').getBytes();
        byte[] byArray3 = (string3 + '\u0000').getBytes();
        byte[] byArray4 = (string4 + '\u0000').getBytes();
        this.setUnicodeTextualData(this.encoder, byArray, bl, byArray3, byArray2, byArray4);
    }

    public final void setUnicodeTextualData(String string, String string2, String string3, String string4) {
        this.setUnicodeTextualData(string, string2, string3, string4, false);
    }

    public final void setStandardRGB(int n) {
        if (!this.hasiCCP) {
            this.hassRGB = true;
            this.setStandardRGB(this.encoder, n);
            this.setImageGamma(this.encoder, 45455);
            this.setPrimaryChromaticities(this.encoder, 31270, 32900, 64000, 33000, 30000, 60000, 15000, 6000);
        }
    }

    public final void setPhysicalPixelDimensions(int n, int n2, int n3) {
        this.setPhysicalPixelDimensions(this.encoder, n, n2, n3);
    }

    public final void setPrimaryChromaticities(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (!this.hassRGB) {
            this.setPrimaryChromaticities(this.encoder, n, n2, n3, n4, n5, n6, n7, n8);
        }
    }

    public final void setSignificantBits(byte[] byArray) {
        byte by;
        byte by2;
        byte by3;
        byte by4;
        int n;
        if (byArray != null && (n = byArray.length) > 0) {
            by4 = byArray[0];
            by3 = 1;
            by2 = 1;
            by = 1;
            if (n > 1) {
                by = byArray[1];
            }
            if (n > 2) {
                by2 = byArray[2];
            }
            if (n > 3) {
                by3 = byArray[3];
            }
        } else {
            throw new PNGException(6, "[sBIT]");
        }
        this.setSignificantBits(this.encoder, by4, by, by2, by3);
    }

    public final void setTransparency(int[] nArray) {
        byte[] byArray;
        int n;
        if (nArray != null && (n = nArray.length) > 0) {
            byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)nArray[n2];
                ++n2;
            }
        } else {
            throw new PNGException(6, "[tRNS]");
        }
        this.setTransparencyPlt(this.encoder, byArray, n);
    }

    public final void setTransparency(int n, int n2, int n3) {
        this.setTransparency(this.encoder, n, n2, n3);
    }

    public final void setHistogram(short[] sArray) {
        if (this.dataPLTE == null || sArray == null || this.dataPLTE.length / 3 != sArray.length) {
            throw new PNGException(6, "[hIST]");
        }
        this.setHistogram(this.encoder, sArray, sArray.length);
    }

    public final void setBackground(int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        if (nArray != null && (n4 = nArray.length) > 0) {
            n3 = nArray[0];
            n2 = 0;
            n = 0;
            if (n4 > 1) {
                n = nArray[1];
            }
            if (n4 > 2) {
                n2 = nArray[2];
            }
        } else {
            throw new PNGException(6, "[bKGD]");
        }
        this.setBackground(this.encoder, n3, n, n2);
    }

    public final void setEmbeddedICCProfile(String string, byte[] byArray) {
        if (!this.hassRGB) {
            this.hasiCCP = true;
            if (string.length() > 79) {
                string = new String(string.getBytes(), 0, 79);
            }
            byte[] byArray2 = (string + '\u0000').getBytes();
            this.setEmbeddedICCProfile(this.encoder, byArray2, byArray, byArray.length);
        }
    }

    public final void setSuggestedPalette(String string, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, short[] sArray) {
        int n = byArray.length;
        if (n != byArray2.length || n != byArray3.length || n != byArray4.length || n != sArray.length) {
            throw new PNGException(6, "[sPLT]");
        }
        if (string.length() > 79) {
            string = new String(string.getBytes(), 0, 79);
        }
        byte[] byArray5 = (string + '\u0000').getBytes();
        byte[] byArray6 = new byte[6 * byArray.length];
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray6[6 * n2 + 0] = byArray[n2];
            byArray6[6 * n2 + 1] = byArray2[n2];
            byArray6[6 * n2 + 2] = byArray3[n2];
            byArray6[6 * n2 + 3] = byArray4[n2];
            byArray6[6 * n2 + 4] = (byte)(sArray[n2] >> 8);
            byArray6[6 * n2 + 5] = (byte)sArray[n2];
            ++n2;
        }
        this.setSuggestedPalette(this.encoder, byArray5, 8, byArray6, byArray6.length);
    }

    public final void setSuggestedPalette(String string, short[] sArray, short[] sArray2, short[] sArray3, short[] sArray4, short[] sArray5) {
        int n = sArray.length;
        if (n != sArray2.length || n != sArray3.length || n != sArray4.length || n != sArray5.length) {
            throw new PNGException(6, "[sPLT]");
        }
        if (string.length() > 79) {
            string = new String(string.getBytes(), 0, 79);
        }
        byte[] byArray = (string + '\u0000').getBytes();
        byte[] byArray2 = new byte[10 * sArray.length];
        int n2 = 0;
        while (n2 < sArray.length) {
            byArray2[10 * n2 + 0] = (byte)(sArray[n2] >> 8);
            byArray2[10 * n2 + 1] = (byte)sArray[n2];
            byArray2[10 * n2 + 2] = (byte)(sArray2[n2] >> 8);
            byArray2[10 * n2 + 3] = (byte)sArray2[n2];
            byArray2[10 * n2 + 4] = (byte)(sArray3[n2] >> 8);
            byArray2[10 * n2 + 5] = (byte)sArray3[n2];
            byArray2[10 * n2 + 6] = (byte)(sArray4[n2] >> 8);
            byArray2[10 * n2 + 7] = (byte)sArray4[n2];
            byArray2[10 * n2 + 8] = (byte)(sArray5[n2] >> 8);
            byArray2[10 * n2 + 9] = (byte)sArray5[n2];
            ++n2;
        }
        this.setSuggestedPalette(this.encoder, byArray, 16, byArray2, byArray2.length);
    }

    public final void setLastModificationTime(boolean bl) {
        this.setLastModificationTime(new GregorianCalendar());
    }

    public final void setLastModificationTime(GregorianCalendar gregorianCalendar) {
        int n;
        gregorianCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        int n2 = gregorianCalendar.get(1);
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        switch (gregorianCalendar.get(2)) {
            case 0: {
                n = 1;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 4: {
                n = 5;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            case 6: {
                n = 7;
                break;
            }
            case 7: {
                n = 8;
                break;
            }
            case 8: {
                n = 9;
                break;
            }
            case 9: {
                n = 10;
                break;
            }
            case 10: {
                n = 11;
                break;
            }
            case 11: {
                n = 12;
                break;
            }
            default: {
                n = 1;
            }
        }
        this.setLastModificationTime(this.encoder, n2, n, n3, n4, n5, n6);
    }

    public final void setUserData(int n, byte[] byArray, int n2) {
        int n3 = -1;
        if (n2 == 0) {
            n3 = 0;
        } else if (n2 == 1) {
            n3 = 1;
        }
        this.setUserData(this.encoder, n, byArray, byArray.length, n3);
    }

    public final void setUserData(String string, byte[] byArray, int n) {
        byte[] byArray2;
        if (string.length() == 4) {
            byArray2 = new byte[4];
            int n2 = 0;
            while (n2 < 4) {
                char c2 = string.charAt(n2);
                if (!(c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z')) {
                    throw new PNGException(0, "[user]");
                }
                byArray2[n2] = (byte)c2;
                ++n2;
            }
        } else {
            throw new PNGException(0, "[user]");
        }
        int n3 = (byArray2[0] & 0xFF) << 24 | (byArray2[1] & 0xFF) << 16 | (byArray2[2] & 0xFF) << 8 | byArray2[3] & 0xFF;
        this.setUserData(n3, byArray, n);
    }

    private native int encode_init();

    private native void encode(OutputStream var1, mediaLibImage var2, int var3, int var4);

    private native void setIDATSize(int var1, int var2);

    private native void setCompressionLevel(int var1, int var2);

    private native void setStrategy(int var1, int var2);

    private native void setBitDepth(int var1, int var2);

    private native void setImageGamma(int var1, int var2);

    private native void setPalette(int var1, byte[] var2, int var3);

    private native void setCompressedTextualData(int var1, byte[] var2, byte[] var3);

    private native void setTextualData(int var1, byte[] var2, byte[] var3);

    private native void setUnicodeTextualData(int var1, byte[] var2, boolean var3, byte[] var4, byte[] var5, byte[] var6);

    private native void setStandardRGB(int var1, int var2);

    private native void setPhysicalPixelDimensions(int var1, int var2, int var3, int var4);

    private native void setPrimaryChromaticities(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private native void setSignificantBits(int var1, int var2, int var3, int var4, int var5);

    private native void setHistogram(int var1, short[] var2, int var3);

    private native void setBackground(int var1, int var2, int var3, int var4);

    private native void setEmbeddedICCProfile(int var1, byte[] var2, byte[] var3, int var4);

    private native void setSuggestedPalette(int var1, byte[] var2, int var3, byte[] var4, int var5);

    private native void setTransparencyPlt(int var1, byte[] var2, int var3);

    private native void setTransparency(int var1, int var2, int var3, int var4);

    private native void setLastModificationTime(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private native void setUserData(int var1, int var2, byte[] var3, int var4, int var5);

    static {
        System.loadLibrary("clib_jiio");
    }
}

