/*
 * Decompiled with CFR 0.152.
 */
package de.mein;

import de.mein.auth.data.MeinAuthSettings;
import de.mein.auth.service.MeinBoot;
import de.mein.sql.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class KonsoleHandler {
    private final String jsonPath = "meinAuth.settings.json";
    private int position = 0;
    private List<Pair<String>> parameters;
    private Pair<String> broadcastPort = this.stringPair("-bcp", "port used for broadcasting");
    private Pair<String> port = this.stringPair("-p", "port used for messaging (listening and sending)");
    private Pair<String> deliveryPort = this.stringPair("-dp", "port used to deliver the certificate");
    private Pair<String> workingDirectory = this.stringPair("-d", "path of working directory\nmeinauth will store certificates there");
    private Pair<String> broadcastListenerPort = this.stringPair("-bclp", "listen for broadcasts on this port");
    MeinAuthSettings meinAuthSettings = new MeinAuthSettings();
    private String[] args;

    private Pair<String> stringPair(String key, String value) {
        return new Pair<String>(String.class, key, value);
    }

    protected void fillParameters(Pair ... pairs) {
        this.parameters = new ArrayList<Pair<String>>();
        if (pairs != null) {
            Pair[] pairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                Pair pair = pairArray[n2];
                this.parameters.add(pair);
                ++n2;
            }
        }
    }

    public KonsoleHandler() {
        this.fillParameters(this.workingDirectory, this.port, this.deliveryPort, this.broadcastPort, this.broadcastListenerPort);
    }

    public MeinAuthSettings start(String[] args) throws Exception {
        this.args = args;
        if (args.length > 0 && args[0].equals("--help")) {
            this.displayHelp();
        } else if (args.length > 0) {
            while (this.position < args.length) {
                this.read();
            }
        } else {
            File jsonFile = new File("meinAuth.settings.json");
            if (jsonFile.exists()) {
                System.out.println("KonsoleHandler.start.loading settings from file: " + jsonFile.getAbsolutePath());
                this.meinAuthSettings = (MeinAuthSettings)MeinAuthSettings.load(jsonFile);
            } else {
                this.meinAuthSettings.setPort(8888).setDeliveryPort(8889).setName("meinauth").setBrotcastListenerPort(9966).setBrotcastPort(9966).setWorkingDirectory(MeinBoot.defaultWorkingDir1).setJsonFile(new File("meinAuth.settings.json"));
            }
        }
        return this.meinAuthSettings;
    }

    private void read() {
        String key = this.args[this.position++];
        String value = this.args[this.position++];
        assert (key != null && value != null);
        if (key.equals(this.workingDirectory.k())) {
            this.meinAuthSettings.setWorkingDirectory(new File(value));
        } else if (key.equals(this.port.k())) {
            this.meinAuthSettings.setPort(Integer.parseInt(value));
        } else if (key.equals(this.deliveryPort.k())) {
            this.meinAuthSettings.setDeliveryPort(Integer.parseInt(value));
        } else if (key.equals(this.broadcastPort.k())) {
            this.meinAuthSettings.setBrotcastPort(Integer.parseInt(value));
        } else if (key.equals(this.broadcastListenerPort.k())) {
            this.meinAuthSettings.setBrotcastListenerPort(Integer.parseInt(value));
        }
    }

    private void displayHelp() {
        System.out.println("MeinAuth Help: available arguments:");
        for (Pair<String> parameter : this.parameters) {
            System.out.println(String.valueOf(parameter.k()) + ": " + parameter.v());
        }
    }
}

