/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth;

import de.mein.auth.tools.ByteTools;
import org.junit.Assert;
import org.junit.Test;

public class ByteToolsTest {
    @Test
    public void long2byte() {
        Long l = 500L;
        Long ll = ByteTools.bytesToLong(ByteTools.longToBytes(l));
        Assert.assertEquals(l, ll);
    }

    @Test
    public void int2byte() {
        int i = 500;
        int ii = ByteTools.bytesToInt(ByteTools.intToBytes(i));
        Assert.assertEquals(i, ii);
    }

    @Test
    public void fill() {
        byte[] arr = new byte[12];
        int offset = 4;
        ByteTools.fill(arr, 4, (byte[][])new byte[][]{ByteTools.longToBytes(7L)});
        Assert.assertEquals(7L, arr[11]);
    }

    @Test
    public void read() {
        byte[] arr = new byte[12];
        int offset = 4;
        ByteTools.fill(arr, 4, (byte[][])new byte[][]{ByteTools.longToBytes(77777777L)});
        long read = ByteTools.bytesToLong(arr, 4);
        Assert.assertEquals(77777777L, read);
    }

    @Test
    public void read2() {
        byte[] byArray = new byte[10];
        byArray[8] = -96;
        byArray[9] = 21;
        byte[] arr = byArray;
        long read = ByteTools.bytesToLong(arr, 2);
        Assert.assertEquals(40981L, read);
    }
}

