/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth;

import de.mein.auth.data.MeinAuthSettings;
import de.mein.auth.data.access.CertificateManager;
import de.mein.auth.data.access.DatabaseManager;
import de.mein.auth.data.db.Certificate;
import de.mein.sql.SqlQueriesException;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CertificateManagerTest {
    private CertificateManager certificateManager;

    private X509Certificate genCert() throws Exception {
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        certGen.setSerialNumber(BigInteger.valueOf(5L));
        certGen.setIssuerDN(new X509Principal("CN=mein.auth.test.junit, OU=None, O=None L=None, C=None"));
        certGen.setNotBefore(new Date(System.currentTimeMillis() - 2592000000L));
        certGen.setNotAfter(new Date(System.currentTimeMillis() + 315360000000L));
        certGen.setSubjectDN(new X509Principal("CN=mein.auth.TEST.JUNIT, OU=None, O=None L=None, C=None"));
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(1024);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        certGen.setPublicKey(publicKey);
        certGen.setSignatureAlgorithm("SHA512WITHRSA");
        X509Certificate certificate = certGen.generateX509Certificate(privateKey);
        return certificate;
    }

    @Before
    public void init() throws Exception, SqlQueriesException {
        CertificateManager.deleteDirectory(new File("z_test"));
        this.certificateManager = CertificateManagerTest.createCertificateManager(new MeinAuthSettings().setWorkingDirectory(new File("z_test")));
    }

    public static CertificateManager createCertificateManager(MeinAuthSettings meinAuthSettings) throws SQLException, ClassNotFoundException, IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, SqlQueriesException {
        DatabaseManager databaseManager = new DatabaseManager(meinAuthSettings);
        return new CertificateManager(meinAuthSettings.getWorkingDirectory(), databaseManager.getSqlQueries(), 1024);
    }

    @After
    public void finish() throws IOException {
        CertificateManager.deleteDirectory(new File("z_test"));
    }

    @Test
    public void loadCertificateFromBytes() throws Exception {
        X509Certificate x509Certificate = this.genCert();
        byte[] bytes = x509Certificate.getEncoded();
        X509Certificate loadedCert = CertificateManager.loadX509CertificateFromBytes(bytes);
        Assert.assertEquals(x509Certificate, loadedCert);
    }

    @Test
    public void registerCertificate() throws Exception, SqlQueriesException {
        X509Certificate x509Certificate = this.genCert();
        byte[] byteCert = x509Certificate.getEncoded();
        UUID uuid = UUID.randomUUID();
        Certificate buildCertificate = this.certificateManager.importCertificate(x509Certificate, "testname", uuid.toString(), null, null, null, "huiii");
        Certificate dbCertificate = this.certificateManager.getTrustedCertificates().get(0);
        X509Certificate dbX509Certificate = CertificateManager.loadX509CertificateFromBytes(dbCertificate.getCertificate().v());
        Assert.assertEquals(x509Certificate, dbX509Certificate);
        Assert.assertNotNull(buildCertificate.getId().v());
        buildCertificate.setId(dbCertificate.getId().v());
        Assert.assertEquals(Arrays.toString(byteCert), Arrays.toString(dbCertificate.getCertificate().v()));
    }

    public static CertificateManager createCertificateManager(File wd) throws SQLException, ClassNotFoundException, IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, SqlQueriesException {
        return CertificateManagerTest.createCertificateManager(wd, true);
    }

    private static CertificateManager createCertificateManager(File wd, boolean delete) throws SQLException, IOException, ClassNotFoundException, CertificateException, NoSuchAlgorithmException, KeyStoreException, SignatureException, SqlQueriesException, InvalidKeyException {
        if (delete) {
            CertificateManager.deleteDirectory(wd);
        }
        wd.mkdirs();
        MeinAuthSettings meinAuthSettings = new MeinAuthSettings().setWorkingDirectory(wd);
        DatabaseManager databaseManager = new DatabaseManager(meinAuthSettings);
        return new CertificateManager(meinAuthSettings.getWorkingDirectory(), databaseManager.getSqlQueries(), 1024);
    }

    @Test
    public void keySerialization() throws Exception, SqlQueriesException {
        CertificateManager certificateManager = CertificateManagerTest.createCertificateManager(new File("testDir"));
        certificateManager.generateCertificate();
        PrivateKey pk1 = certificateManager.getPrivateKey();
        PublicKey pubk1 = certificateManager.getPublicKey();
        X509Certificate cert1 = certificateManager.getMyX509Certificate();
        certificateManager = CertificateManagerTest.createCertificateManager(new File("testDir"), false);
        PrivateKey pk2 = certificateManager.getPrivateKey();
        PublicKey pubk2 = certificateManager.getPublicKey();
        X509Certificate cert2 = certificateManager.getMyX509Certificate();
        System.out.println("CertificateManagerTest.keySerialization");
        Assert.assertEquals(pk1, pk2);
        Assert.assertEquals(pubk1, pubk2);
        Assert.assertEquals(cert1, cert2);
    }

    @Test
    public void storeCertificate() throws Exception, SqlQueriesException {
        this.certificateManager.generateCertificate();
        Certificate certificate = new Certificate();
        certificate.setCertificate(this.certificateManager.getMyX509Certificate().getEncoded());
        certificate.setAnswerUuid("some address");
        UUID uuid = UUID.randomUUID();
        certificate.setUuid(uuid.toString());
        System.out.println("CertificateManagerTest.storeCertificateDB");
    }
}

