/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.broadcast;

import de.mein.auth.broadcast.BrotCaster;
import de.mein.auth.data.db.Certificate;
import de.mein.auth.data.db.Service;
import de.mein.auth.service.IMeinService;
import de.mein.auth.service.MeinAuthService;
import de.mein.sql.SqlQueriesException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MeinAuthBrotCaster
extends BrotCaster {
    private final MeinAuthService meinAuthService;
    private MeinAuthBrotCasterListener brotCasterListener;

    public MeinAuthBrotCaster setBrotCasterListener(MeinAuthBrotCasterListener brotCasterListener) {
        this.brotCasterListener = brotCasterListener;
        return this;
    }

    @Override
    public String getRunnableName() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.meinAuthService.getName();
    }

    public MeinAuthBrotCaster(MeinAuthService meinAuthService) {
        super(meinAuthService.getSettings().getBrotcastListenerPort(), meinAuthService.getSettings().getBrotcastPort());
        this.meinAuthService = meinAuthService;
    }

    private boolean handleBrotcast(DatagramPacket packet) throws SqlQueriesException, IOException {
        String brotCast = new String(packet.getData());
        String greetingExtractionRegex = "^meinauth\\([0-9]{3}[0-9]{1,2},[0-9]{3}[0-9]{1,2}\\)\\.";
        String greetingMatchRegex = "^meinauth\\([0-9]{3}[0-9]{1,2},[0-9]{3}[0-9]{1,2}\\)\\..+";
        Pattern pattern = Pattern.compile("^meinauth\\([0-9]{3}[0-9]{1,2},[0-9]{3}[0-9]{1,2}\\)\\..+");
        Matcher matcher = pattern.matcher(brotCast);
        if (matcher.matches()) {
            String greeting = brotCast.replaceAll("^meinauth\\([0-9]{3}[0-9]{1,2},[0-9]{3}[0-9]{1,2}\\)\\.", "").trim();
            Certificate partnerCertificate = this.findCertificate(greeting);
            if (partnerCertificate != null) {
                this.updateCertificate(partnerCertificate, packet);
                this.onCertificateSpotted(partnerCertificate);
                if (this.brotCasterListener != null) {
                    this.brotCasterListener.onHasAddress(packet.getAddress(), packet.getPort(), this.extractDeliveryPort(brotCast));
                }
                String answerString = this.meinAuthService.getSettings().getDiscoverAnswer();
                DatagramPacket answer = new DatagramPacket(answerString.getBytes(), answerString.getBytes().length, packet.getAddress(), packet.getPort());
                this.socket.send(answer);
            }
            return true;
        }
        return false;
    }

    private void onCertificateSpotted(Certificate partnerCertificate) throws SqlQueriesException {
        for (Service service : this.meinAuthService.getDatabaseManager().getAllowedServices(partnerCertificate.getId().v())) {
            IMeinService runningService = this.meinAuthService.getMeinService(service.getUuid().v());
            if (runningService == null) continue;
            runningService.handleCertificateSpotted(partnerCertificate);
        }
    }

    private Certificate findCertificate(String greeting) throws SqlQueriesException {
        List<Certificate> possibleCertificates = this.meinAuthService.getCertificateManager().getCertificatesByGreeting(greeting);
        if (possibleCertificates.size() == 0) {
            System.out.println("MeinAuthBrotCaster.findCertificate.don't know that guy");
        } else if (possibleCertificates.size() > 1) {
            System.out.println("MeinAuthBrotCaster.findCertificate.know too many of these guys");
        } else {
            return possibleCertificates.get(0);
        }
        return null;
    }

    private void updateCertificate(Certificate partnerCertificate, DatagramPacket packet) throws SqlQueriesException {
        String brotCast = new String(packet.getData());
        Integer port = this.extractPort(brotCast);
        Integer deliveryPort = this.extractDeliveryPort(brotCast);
        partnerCertificate.setPort(port).setCertDeliveryPort(deliveryPort).setAddress(packet.getAddress().getHostAddress());
        this.meinAuthService.getCertificateManager().updateCertificate(partnerCertificate);
    }

    private Integer extractPort(String msg) {
        int bracket = msg.indexOf(40) + 1;
        int comma = msg.indexOf(44);
        String portString = msg.substring(bracket, comma);
        return Integer.parseInt(portString);
    }

    private Integer extractDeliveryPort(String msg) {
        int bracket = msg.indexOf(44) + 1;
        int comma = msg.indexOf(41);
        String portString = msg.substring(bracket, comma);
        return Integer.parseInt(portString);
    }

    private boolean handleBrotcastAnswer(DatagramPacket packet) throws SqlQueriesException {
        String msg = new String(packet.getData());
        String extractionRegex = "^meinauth\\.answer\\([0-9]{3}[0-9]{1,2},[0-9]{3}[0-9]{1,2}\\)\\.";
        String matchRegex = "^meinauth\\.answer\\([0-9]{3}[0-9]{1,2},[0-9]{3}[0-9]{1,2}\\)\\..+";
        Pattern pattern = Pattern.compile("^meinauth\\.answer\\([0-9]{3}[0-9]{1,2},[0-9]{3}[0-9]{1,2}\\)\\..+");
        Matcher matcher = pattern.matcher(msg);
        if (matcher.matches()) {
            String greeting = msg.replaceFirst("^meinauth\\.answer\\([0-9]{3}[0-9]{1,2},[0-9]{3}[0-9]{1,2}\\)\\.", "").trim();
            Certificate partnerCertificate = this.findCertificate(greeting);
            if (partnerCertificate != null) {
                this.updateCertificate(partnerCertificate, packet);
                this.onCertificateSpotted(partnerCertificate);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void handleMessage(DatagramPacket packet, byte[] buf) {
        String brotCast = new String(buf);
        System.out.println(String.valueOf(this.meinAuthService.getName()) + ".MeinAuthBrotCaster.handleMessage.msg: '" + brotCast + "' from address " + packet.getAddress().getHostName());
        try {
            if (!(this.handleDiscover(packet) || this.handleDiscoverAnswer(packet) || this.handleBrotcast(packet))) {
                this.handleBrotcastAnswer(packet);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean handleDiscover(DatagramPacket packet) throws IOException {
        String brotCast = new String(packet.getData()).trim();
        String disciverRegex = "^meinauth\\.discover\\([0-9]{3}[0-9]{1,2},[0-9]{3}[0-9]{1,2}\\)";
        Pattern pattern = Pattern.compile("^meinauth\\.discover\\([0-9]{3}[0-9]{1,2},[0-9]{3}[0-9]{1,2}\\)");
        Matcher matcher = pattern.matcher(brotCast);
        if (matcher.matches()) {
            if (this.brotCasterListener != null) {
                this.brotCasterListener.onHasAddress(packet.getAddress(), this.extractPort(brotCast), this.extractDeliveryPort(brotCast));
            }
            String answerString = this.meinAuthService.getSettings().getDiscoverAnswer();
            DatagramPacket answer = new DatagramPacket(answerString.getBytes(), answerString.getBytes().length, packet.getAddress(), packet.getPort());
            this.socket.send(answer);
            return true;
        }
        return false;
    }

    private boolean handleDiscoverAnswer(DatagramPacket packet) throws SqlQueriesException {
        String msg = new String(packet.getData()).trim();
        String answerRegex = "^meinauth\\.discover\\.answer\\([0-9]{3}[0-9]{1,2},[0-9]{3}[0-9]{1,2}\\)";
        Pattern pattern = Pattern.compile("^meinauth\\.discover\\.answer\\([0-9]{3}[0-9]{1,2},[0-9]{3}[0-9]{1,2}\\)");
        Matcher matcher = pattern.matcher(msg);
        if (matcher.matches()) {
            if (this.brotCasterListener != null) {
                this.brotCasterListener.onHasAddress(packet.getAddress(), this.extractPort(msg), this.extractDeliveryPort(msg));
            }
            return true;
        }
        return false;
    }

    public void discover(int port) throws IOException {
        this.brotcast(port, this.meinAuthService.getSettings().getDiscoverMessage());
    }

    public static interface MeinAuthBrotCasterListener {
        public void onHasAddress(InetAddress var1, int var2, int var3);
    }
}

