/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.data;

import de.mein.auth.data.db.Approval;
import de.mein.auth.data.db.Certificate;
import de.mein.auth.data.db.ServiceJoinServiceType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApprovalMatrix {
    private Map<Long, Map<Long, Approval>> matrix = new HashMap<Long, Map<Long, Approval>>();
    private Set<Long> approvalsToDelete = new HashSet<Long>();

    public ApprovalMatrix fill(List<Certificate> certificates, List<ServiceJoinServiceType> services, List<Approval> approvals) {
        for (ServiceJoinServiceType service : services) {
            this.matrix.put(service.getServiceId().v(), new HashMap());
        }
        for (Certificate certificate : certificates) {
            if (this.matrix.containsKey(certificate.getId().v())) continue;
            this.matrix.put(certificate.getId().v(), new HashMap());
        }
        for (Approval approval : approvals) {
            this.matrix.get(approval.getCertificateId().v()).put(approval.getServiceid().v(), approval);
        }
        return this;
    }

    public Map<Long, Map<Long, Approval>> getMatrix() {
        return this.matrix;
    }

    public ApprovalMatrix approve(Long certificateId, Long serviceId) {
        if (!this.matrix.containsKey(certificateId)) {
            this.matrix.put(certificateId, new HashMap());
        }
        this.matrix.get(certificateId).put(serviceId, new Approval().setCertificateId(certificateId).setServiceid(serviceId));
        return this;
    }

    public boolean isApproved(Long certificateId, Long serviceId) {
        return this.matrix.get(certificateId).containsKey(serviceId);
    }

    public ApprovalMatrix disapprove(Long certificateId, Long serviceId) {
        if (this.matrix.get(certificateId).containsKey(serviceId)) {
            Approval approval = this.matrix.get(certificateId).get(serviceId);
            if (approval.getId().v() != null) {
                this.approvalsToDelete.add(approval.getId().v());
            }
            this.matrix.get(certificateId).remove(serviceId);
        }
        return this;
    }

    public static class ApprovalMatrixRow {
        private Set<Certificate> approvedCertificates = new HashSet<Certificate>();
        private ServiceJoinServiceType service;

        public ApprovalMatrixRow setService(ServiceJoinServiceType service) {
            this.service = service;
            return this;
        }

        public ServiceJoinServiceType getService() {
            return this.service;
        }

        public Set<Certificate> getApprovedCertificates() {
            return this.approvedCertificates;
        }

        public ApprovalMatrixRow addApprovedCertificate(Certificate certificate) {
            this.approvedCertificates.add(certificate);
            return this;
        }
    }
}

