/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.data;

import de.mein.auth.data.JsonSettings;
import de.mein.auth.service.IDBCreatedListener;
import de.mein.auth.service.MeinAuthService;
import java.io.File;

public class MeinAuthSettings
extends JsonSettings {
    public static final File DEFAULT_FILE = new File("meinauthsettings.json");
    public static final int BROTCAST_PORT = 9966;
    private int deliveryPort;
    private int port;
    private String workingDirectory;
    private String name;
    private String greeting;
    private Integer brotcastListenerPort;
    private Integer brotcastPort;
    private Class<? extends MeinAuthService> meinAuthServiceClass;
    private IDBCreatedListener idbCreatedListener;

    public MeinAuthSettings setBrotcastListenerPort(Integer brotcastListenerPort) {
        this.brotcastListenerPort = brotcastListenerPort;
        return this;
    }

    public MeinAuthSettings setMeinAuthServiceClass(Class<? extends MeinAuthService> meinAuthServiceClass) {
        this.meinAuthServiceClass = meinAuthServiceClass;
        return this;
    }

    public MeinAuthSettings setIdbCreatedListener(IDBCreatedListener idbCreatedListener) {
        this.idbCreatedListener = idbCreatedListener;
        return this;
    }

    public IDBCreatedListener getIdbCreatedListener() {
        return this.idbCreatedListener;
    }

    public Class<? extends MeinAuthService> getMeinAuthServiceClass() {
        return this.meinAuthServiceClass;
    }

    public MeinAuthSettings setBrotcastPort(Integer brotcastPort) {
        this.brotcastPort = brotcastPort;
        return this;
    }

    public int getBrotcastPort() {
        return this.brotcastPort;
    }

    public Integer getBrotcastListenerPort() {
        return this.brotcastListenerPort;
    }

    public String getDiscoverMessage() {
        return "meinauth.discover(" + this.port + "," + this.deliveryPort + ")";
    }

    public String getDiscoverAnswer() {
        return "meinauth.discover.answer(" + this.port + "," + this.deliveryPort + ")";
    }

    public String getGreeting() {
        return this.greeting;
    }

    public MeinAuthSettings setGreeting(String greeting) {
        this.greeting = greeting;
        return this;
    }

    public Integer getDeliveryPort() {
        return this.deliveryPort;
    }

    public MeinAuthSettings setDeliveryPort(int deliveryPort) {
        this.deliveryPort = deliveryPort;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public MeinAuthSettings setPort(int port) {
        this.port = port;
        return this;
    }

    public File getWorkingDirectory() {
        return new File(this.workingDirectory);
    }

    public MeinAuthSettings setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory.getAbsolutePath();
        File jsonFile = new File(String.valueOf(workingDirectory.getAbsolutePath()) + File.separator + DEFAULT_FILE);
        this.setJsonFile(jsonFile);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public MeinAuthSettings setName(String name) {
        this.name = name;
        return this;
    }
}

