/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.data;

import de.mein.auth.data.Dobject;
import de.mein.auth.data.IPayload;
import de.mein.auth.data.IRequestHandler;
import de.mein.auth.data.MeinMessage;
import de.mein.auth.data.MeinResponse;
import de.mein.auth.data.ResponseException;
import de.mein.auth.data.db.Certificate;
import de.mein.core.serialize.JsonIgnore;
import de.mein.core.serialize.SerializableEntity;
import java.security.SecureRandom;
import org.jdeferred.Promise;

public class MeinRequest
extends MeinMessage {
    private Long requestId;
    private Long answerId;
    @JsonIgnore
    private IRequestHandler requestHandler;
    @JsonIgnore
    private Dobject dobject = new Dobject();
    private byte[] secret;
    private String decryptedSecret;
    private String userUuid;
    private Boolean authenticated;
    private Certificate certificate;
    private String mode;

    public MeinRequest() {
        this.requestId = new SecureRandom().nextLong();
    }

    public MeinRequest(String serviceUuid, String intent) {
        this();
        this.serviceUuid = serviceUuid;
        this.intent = intent;
    }

    public Long getRequestId() {
        return this.requestId;
    }

    public MeinRequest setRequestId(Long requestId) {
        this.requestId = requestId;
        return this;
    }

    public MeinResponse reponse() {
        return new MeinResponse().setResponseId(this.requestId);
    }

    public MeinRequest setRequestHandler(IRequestHandler requestHandler) {
        this.requestHandler = requestHandler;
        return this;
    }

    public MeinRequest queue() {
        this.requestHandler.queueForResponse(this);
        return this;
    }

    @Override
    public MeinRequest setPayLoad(IPayload payLoad) {
        return (MeinRequest)super.setPayLoad(payLoad);
    }

    public Long getAnswerId() {
        return this.answerId;
    }

    public MeinRequest setAnswerId(Long answerId) {
        this.answerId = answerId;
        return this;
    }

    public Dobject getDobject() {
        return this.dobject;
    }

    public Promise<SerializableEntity, Exception, Void> getPromise() {
        return this.dobject.promise();
    }

    public byte[] getSecret() {
        return this.secret;
    }

    public MeinRequest setSecret(byte[] secret) {
        this.secret = secret;
        return this;
    }

    public String getDecryptedSecret() {
        return this.decryptedSecret;
    }

    public MeinRequest setDecryptedSecret(String decryptedSecret) {
        this.decryptedSecret = decryptedSecret;
        return this;
    }

    public String getUserUuid() {
        return this.userUuid;
    }

    public MeinRequest setUserUuid(String userUuid) {
        this.userUuid = userUuid;
        return this;
    }

    public Boolean getAuthenticated() {
        return this.authenticated;
    }

    public MeinRequest setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
        return this;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public MeinRequest setCertificate(Certificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public MeinRequest request() {
        return new MeinRequest().setAnswerId(this.requestId);
    }

    @Override
    public MeinMessage setState(String state) {
        return super.setState(state);
    }

    public MeinResponse respondError(Exception e) {
        MeinResponse response = this.reponse().setState("err");
        if (e instanceof ResponseException) {
            response.setPayLoad((IPayload)((Object)e));
        } else {
            response.setPayLoad(new ResponseException(e));
        }
        return response;
    }

    public void setMode(String mode) {
        System.out.println();
        this.mode = mode;
    }
}

