/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.data;

import de.mein.auth.data.db.ServiceJoinServiceType;
import de.mein.sql.RWLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;

public class NetworkEnvironment
extends Observable {
    private Map<String, ServiceJoinServiceType> serviceMap = new HashMap<String, ServiceJoinServiceType>();
    private Map<Long, List<ServiceJoinServiceType>> certificateServicesMap = new HashMap<Long, List<ServiceJoinServiceType>>();
    private Map<ServiceJoinServiceType, Long> serviceCertificateMap = new HashMap<ServiceJoinServiceType, Long>();
    private List<UnknownAuthInstance> unknownAuthInstances = new ArrayList<UnknownAuthInstance>();
    private RWLock unknownInstancesLock = new RWLock();

    public synchronized NetworkEnvironment add(Long certificateId, ServiceJoinServiceType service) {
        String key;
        if (certificateId == null && service != null) {
            System.err.println("NetworkEnvironment.add: Cert==null, Service!=null");
            return this;
        }
        if (!this.certificateServicesMap.containsKey(certificateId)) {
            this.certificateServicesMap.put(certificateId, new ArrayList());
            this.setChanged();
        }
        if (service != null && !this.serviceMap.containsKey(key = certificateId + "." + service.getUuid().v())) {
            this.certificateServicesMap.get(certificateId).add(service);
            this.serviceCertificateMap.put(service, certificateId);
            this.serviceMap.put(key, service);
            this.setChanged();
        }
        this.notifyObservers();
        return this;
    }

    public List<UnknownAuthInstance> getUnknownAuthInstances() {
        return this.unknownAuthInstances;
    }

    public Long getCertificateId(ServiceJoinServiceType service) {
        return this.serviceCertificateMap.get(service);
    }

    public List<ServiceJoinServiceType> getServices(Long certificateId) {
        return this.certificateServicesMap.get(certificateId);
    }

    public Collection<ServiceJoinServiceType> getServices() {
        return this.serviceMap.values();
    }

    public Set<Long> getCertificateIds() {
        return this.certificateServicesMap.keySet();
    }

    public NetworkEnvironment clear() {
        this.serviceMap.clear();
        this.certificateServicesMap.clear();
        this.serviceCertificateMap.clear();
        this.unknownAuthInstances.clear();
        return this;
    }

    public NetworkEnvironment addUnkown(String address, int port, int portCert) {
        this.unknownInstancesLock.lockWrite();
        this.unknownAuthInstances.add(new UnknownAuthInstance(address, port, portCert));
        this.unknownInstancesLock.unlockWrite();
        this.setChanged();
        this.notifyObservers();
        return this;
    }

    public static interface NetworkEnvironmentListener {
        public void onUnknownFound(UnknownAuthInstance var1);

        public void onKownFound();
    }

    public static class UnknownAuthInstance {
        private final int portCert;
        private final int port;
        private final String address;

        public UnknownAuthInstance(String address, int port, int portCert) {
            this.address = address;
            this.port = port;
            this.portCert = portCert;
        }

        public int getPort() {
            return this.port;
        }

        public int getPortCert() {
            return this.portCert;
        }

        public String getAddress() {
            return this.address;
        }
    }
}

