/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.data.access;

import de.mein.auth.data.access.FileRelatedManager;
import de.mein.auth.data.db.dao.CertificateDao;
import de.mein.auth.tools.Cryptor;
import de.mein.sql.ISQLQueries;
import de.mein.sql.SqlQueriesException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class CertificateManager
extends FileRelatedManager {
    public static final String PASS = "pass";
    private final String PK_NAME = "private";
    private final String CERT_FILENAME = "cert.cert";
    private final String PK_FILENAME = "pk.key";
    private final String KS_FILENAME = "keystore.bks";
    private final String PUB_FILENAME = "pub.key";
    private KeyStore keyStore;
    private int keysize = 1024;
    private File keyStoreFile;
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private X509Certificate certificate;
    private CertificateDao certificateDao;

    public CertificateManager(File workingDirectory, ISQLQueries ISQLQueries2, int keysize) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException, SQLException, ClassNotFoundException, SignatureException, InvalidKeyException, SqlQueriesException {
        super(workingDirectory);
        boolean deleted;
        System.out.println("CertificateManager.dir: " + workingDirectory.getAbsolutePath());
        this.keysize = keysize;
        boolean providerSet = false;
        Provider[] providerArray = Security.getProviders();
        int n = providerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Provider p = providerArray[n2];
            if (p.getClass().equals(BouncyCastleProvider.class)) {
                providerSet = true;
                break;
            }
            ++n2;
        }
        if (!providerSet) {
            Security.addProvider(new BouncyCastleProvider());
        }
        this.keyStoreFile = new File(String.valueOf(this.createWorkingPath()) + "keystore.bks");
        if (this.keyStoreFile.exists() && !(deleted = this.keyStoreFile.delete())) {
            System.err.println("CertificateManager().KEYSTORE.NOT.DELETED");
        }
        this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        this.keyStore.load(null, PASS.toCharArray());
        this.certificateDao = new CertificateDao(ISQLQueries2, false);
        if (!this.loadKeys()) {
            this.generateCertificate();
        }
        this.saveKeysInKeystore();
        this.loadTrustedCertificates();
    }

    public static void deleteDirectory(File dir) {
        System.out.println("CertificateManager.deleteDirectory: " + dir.getAbsolutePath());
        File[] subs = dir.listFiles();
        if (subs != null) {
            File[] fileArray = subs;
            int n = subs.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                CertificateManager.deleteDirectoryP(f);
                ++n2;
            }
        }
        dir.delete();
    }

    private static void deleteDirectoryP(File dir) {
        File[] subs = dir.listFiles();
        if (subs != null) {
            File[] fileArray = subs;
            int n = subs.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                CertificateManager.deleteDirectoryP(f);
                ++n2;
            }
        }
        dir.delete();
    }

    private static int generateSecurePositiveRndInt() {
        int num = new SecureRandom().nextInt();
        return num < 0 ? -num : num;
    }

    public static X509Certificate loadX509CertificateFromBytes(byte[] data) throws CertificateException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        X509Certificate result2 = (X509Certificate)certFactory.generateCertificate(in);
        return result2;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public synchronized de.mein.auth.data.db.Certificate importCertificate(X509Certificate x509Certificate, String name, String answerUuid, String address, Integer port, Integer portCert, String greeting) throws CertificateException, SqlQueriesException, KeyStoreException, NoSuchAlgorithmException, IOException {
        this.certificateDao.lockWrite();
        de.mein.auth.data.db.Certificate certificate = new de.mein.auth.data.db.Certificate();
        String uuid = this.getNewUUID().toString();
        certificate.setUuid(uuid).setCertificate(x509Certificate.getEncoded()).setAnswerUuid(answerUuid).setAddress(address).setName(name).setPort(port).setCertDeliveryPort(portCert).setGreeting(greeting).setTrusted(false);
        certificate = this.certificateDao.insertCertificate(certificate);
        this.certificateDao.unlockWrite();
        this.storeCertInKeyStore(uuid, x509Certificate);
        return certificate;
    }

    public void trustCertificate(Long certId, boolean trusted) throws SqlQueriesException {
        this.certificateDao.trustCertificate(certId, trusted);
    }

    private void loadTrustedCertificates() throws SqlQueriesException, KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        this.certificateDao.lockRead();
        for (de.mein.auth.data.db.Certificate dbCert : this.certificateDao.getTrustedCertificates()) {
            X509Certificate cert = CertificateManager.loadX509CertificateFromBytes(dbCert.getCertificate().v());
            this.storeCertInKeyStore(dbCert.getUuid().v(), cert);
        }
        this.certificateDao.unlockRead();
    }

    private synchronized void storeCertInKeyStore(String name, X509Certificate certificate) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        if (this.keyStore.getCertificate(name) != null) {
            this.keyStore.deleteEntry(name);
        }
        this.keyStore.setCertificateEntry(name, certificate);
        this.storeKeyStore();
    }

    private byte[] readFile(String fileName) throws IOException {
        String path = String.valueOf(this.createWorkingPath()) + fileName;
        File f = new File(path);
        DataInputStream dis = new DataInputStream(new FileInputStream(f));
        byte[] bytes = new byte[(int)f.length()];
        dis.readFully(bytes);
        dis.close();
        return bytes;
    }

    private boolean loadKeys() throws IOException, ClassNotFoundException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        try {
            byte[] privkeyBytes = this.readFile("pk.key");
            byte[] pubkeyBytes = this.readFile("pub.key");
            byte[] certBytes = this.readFile("cert.cert");
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(privkeyBytes);
            X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(pubkeyBytes);
            this.privateKey = kf.generatePrivate(privSpec);
            this.publicKey = kf.generatePublic(pubSpec);
            this.certificate = CertificateManager.loadX509CertificateFromBytes(certBytes);
            return true;
        }
        catch (Exception e) {
            this.privateKey = null;
            this.publicKey = null;
            this.certificate = null;
            System.err.println("error loading existing keys");
            return false;
        }
    }

    public void generateCertificate() throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, IOException, CertificateException, KeyStoreException {
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        certGen.setSerialNumber(BigInteger.valueOf(CertificateManager.generateSecurePositiveRndInt()));
        certGen.setIssuerDN(new X509Principal("CN=mein.auth." + this.workingDirectory + ", OU=None, O=None L=None, C=None"));
        certGen.setNotBefore(new Date(System.currentTimeMillis() - 2592000000L));
        certGen.setNotAfter(new Date(System.currentTimeMillis() + 315360000000L));
        certGen.setSubjectDN(new X509Principal("CN=mein.auth." + this.workingDirectory + ", OU=None, O=None L=None, C=None"));
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(this.keysize);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        this.privateKey = keyPair.getPrivate();
        this.publicKey = keyPair.getPublic();
        certGen.setPublicKey(this.publicKey);
        certGen.setSignatureAlgorithm("SHA512WITHRSA");
        this.certificate = certGen.generateX509Certificate(this.privateKey);
        this.saveFile(this.certificate.getEncoded(), "cert.cert");
        this.saveFile(this.privateKey.getEncoded(), "pk.key");
        this.saveFile(this.publicKey.getEncoded(), "pub.key");
        this.storeKeyStore();
    }

    private void saveKeysInKeystore() throws KeyStoreException {
        char[] pwd = PASS.toCharArray();
        this.keyStore.setKeyEntry("private", this.privateKey, pwd, new Certificate[]{this.certificate});
    }

    private synchronized void storeKeyStore() throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        char[] pwd = PASS.toCharArray();
        this.keyStore.store(new FileOutputStream(this.keyStoreFile), pwd);
    }

    private void saveFile(byte[] data, String fileName) throws IOException {
        String path = String.valueOf(this.createWorkingPath()) + fileName;
        FileOutputStream fos = new FileOutputStream(path);
        fos.write(data);
        fos.close();
    }

    public X509Certificate getMyX509Certificate() {
        return this.certificate;
    }

    public String getNewUUID() throws SqlQueriesException {
        UUID uuid = UUID.randomUUID();
        while (this.certificateDao.existsUUID(uuid.toString())) {
            uuid = UUID.randomUUID();
        }
        return uuid.toString();
    }

    private SSLContext getSSLContext() throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        KeyManagerFactory kmf = null;
        try {
            kmf = KeyManagerFactory.getInstance("X509");
        }
        catch (Exception e) {
            System.err.println("CertificateManager.getSSLContext(X509).failed.trying(SunX509)");
        }
        if (kmf == null) {
            try {
                kmf = KeyManagerFactory.getInstance("SunX509");
            }
            catch (Exception e) {
                System.err.println("CertificateManager.getSSLContext(SunX509).failed");
            }
        }
        kmf.init(this.keyStore, PASS.toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("X509");
        tmf.init(this.keyStore);
        SSLContext sslContext = null;
        sslContext = SSLContext.getInstance("TLS");
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        return sslContext;
    }

    public Socket getClientSocket() throws IOException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLSocketFactory factory = this.getSSLContext().getSocketFactory();
        return factory.createSocket();
    }

    public byte[] encrypt(String original) throws NoSuchPaddingException, NoSuchAlgorithmException, IOException, BadPaddingException, IllegalBlockSizeException, InvalidKeyException, ClassNotFoundException {
        return Cryptor.encrypt(this.publicKey, original);
    }

    public String decrypt(byte[] encrypted) throws NoSuchPaddingException, NoSuchAlgorithmException, IOException, BadPaddingException, IllegalBlockSizeException, InvalidKeyException, ClassNotFoundException {
        return Cryptor.decrypt(this.privateKey, encrypted);
    }

    public de.mein.auth.data.db.Certificate getTrustedCertificateByUuid(String uuid) throws SqlQueriesException {
        return this.certificateDao.getTrustedCertificateByUuid(uuid);
    }

    public de.mein.auth.data.db.Certificate getTrustedCertificateById(Long id) throws SqlQueriesException {
        return this.certificateDao.getTrustedCertificateById(id);
    }

    public de.mein.auth.data.db.Certificate getCertificateById(Long id) throws SqlQueriesException {
        return this.certificateDao.getCertificateById(id);
    }

    public void updateCertificate(de.mein.auth.data.db.Certificate certificate) throws SqlQueriesException {
        this.certificateDao.updateCertificate(certificate);
    }

    public List<de.mein.auth.data.db.Certificate> getTrustedCertificates() throws SqlQueriesException {
        return this.certificateDao.getTrustedCertificates();
    }

    public de.mein.auth.data.db.Certificate addAnswerUuid(Long certId, String ownUuid) throws SqlQueriesException {
        this.certificateDao.lockWrite();
        de.mein.auth.data.db.Certificate partnerCertificate = this.certificateDao.getTrustedCertificateById(certId);
        partnerCertificate.setAnswerUuid(ownUuid);
        this.certificateDao.updateCertificate(partnerCertificate);
        this.certificateDao.unlockWrite();
        return partnerCertificate;
    }

    public List<de.mein.auth.data.db.Certificate> getCertificatesByGreeting(String greeting) throws SqlQueriesException {
        this.certificateDao.lockRead();
        List<de.mein.auth.data.db.Certificate> certs = this.certificateDao.getCertificatesByGreeting(greeting);
        this.certificateDao.unlockRead();
        return certs;
    }

    public void deleteCertificate(de.mein.auth.data.db.Certificate certificate) throws SqlQueriesException {
        if (certificate.getId().v() != null) {
            this.certificateDao.delete(certificate.getId().v());
        }
    }

    public de.mein.auth.data.db.Certificate getCertificateByBytes(byte[] certBytes) throws SqlQueriesException {
        this.certificateDao.lockRead();
        de.mein.auth.data.db.Certificate certificate = this.certificateDao.getCertificateByBytes(certBytes);
        this.certificateDao.unlockRead();
        return certificate;
    }

    public Socket createSocket() throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        SSLSocket socket = (SSLSocket)this.getSSLContext().getSocketFactory().createSocket();
        try {
            socket.setEnabledProtocols(new String[]{"TLSv1.2"});
        }
        catch (Exception e) {
            try {
                socket.setEnabledProtocols(new String[]{"TLSv1.1"});
            }
            catch (Exception ee) {
                socket.setEnabledProtocols(new String[]{"TLSv1"});
            }
        }
        return socket;
    }

    public ServerSocket createServerSocket() throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        SSLServerSocket socket = (SSLServerSocket)this.getSSLContext().getServerSocketFactory().createServerSocket();
        try {
            socket.setEnabledProtocols(new String[]{"TLSv1.2"});
        }
        catch (Exception e) {
            try {
                socket.setEnabledProtocols(new String[]{"TLSv1.1"});
            }
            catch (Exception ee) {
                socket.setEnabledProtocols(new String[]{"TLSv1"});
            }
        }
        return socket;
    }

    public de.mein.auth.data.db.Certificate getTrustedCertificateByHash(String hash) throws SqlQueriesException {
        this.certificateDao.lockRead();
        de.mein.auth.data.db.Certificate certificate = this.certificateDao.getTrustedCertificateByHash(hash);
        this.certificateDao.unlockRead();
        return certificate;
    }
}

