/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.data.access;

import de.mein.auth.data.ApprovalMatrix;
import de.mein.auth.data.MeinAuthSettings;
import de.mein.auth.data.access.FileRelatedManager;
import de.mein.auth.data.db.Approval;
import de.mein.auth.data.db.Certificate;
import de.mein.auth.data.db.Service;
import de.mein.auth.data.db.ServiceJoinServiceType;
import de.mein.auth.data.db.ServiceType;
import de.mein.auth.data.db.dao.ApprovalDao;
import de.mein.auth.data.db.dao.ServiceDao;
import de.mein.auth.data.db.dao.ServiceTypeDao;
import de.mein.execute.SqliteExecutor;
import de.mein.sql.ISQLQueries;
import de.mein.sql.RWLock;
import de.mein.sql.SQLQueries;
import de.mein.sql.SQLTableObject;
import de.mein.sql.SqlQueriesException;
import de.mein.sql.conn.SQLConnector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public final class DatabaseManager
extends FileRelatedManager {
    public static final String DB_FILENAME = "meinauth.db";
    protected final ISQLQueries ISQLQueries = sqlConnectionCreator.createConnection(this);
    protected final ServiceTypeDao serviceTypeDao;
    protected final ServiceDao serviceDao;
    protected final ApprovalDao approvalDao;
    private static SqlInputStreamInjector sqlInputStreamInjector = () -> String.class.getResourceAsStream("/sql.sql");
    private static SQLConnectionCreator sqlConnectionCreator = databaseManager -> {
        File f = new File(String.valueOf(databaseManager.createWorkingPath()) + DB_FILENAME);
        return new SQLQueries(SQLConnector.createSqliteConnection(f), new RWLock());
    };

    public ServiceType getServiceTypeById(Long id) throws SqlQueriesException {
        return this.serviceTypeDao.getServiceTypeById(id);
    }

    public static void setSqlInputStreamInjector(SqlInputStreamInjector sqlInputStreamInjector) {
        DatabaseManager.sqlInputStreamInjector = sqlInputStreamInjector;
    }

    public static void setSqlConnectionCreator(SQLConnectionCreator sqlConnectionCreator) {
        DatabaseManager.sqlConnectionCreator = sqlConnectionCreator;
    }

    public DatabaseManager(MeinAuthSettings meinAuthSettings) throws SQLException, ClassNotFoundException, IOException {
        super(meinAuthSettings.getWorkingDirectory());
        SqliteExecutor sqliteExecutor = new SqliteExecutor(this.ISQLQueries.getSQLConnection());
        if (!sqliteExecutor.checkTablesExist("servicetype", "service", "approval", "certificate")) {
            sqliteExecutor.executeStream(sqlInputStreamInjector.createSqlFileInputStream());
            this.hadToInitialize = true;
        }
        this.serviceTypeDao = new ServiceTypeDao(this.ISQLQueries);
        this.approvalDao = new ApprovalDao(this.ISQLQueries);
        this.serviceDao = new ServiceDao(this.ISQLQueries);
    }

    public ServiceType getServiceTypeByName(String name) throws SqlQueriesException {
        return this.serviceTypeDao.getTypeByName(name);
    }

    public ServiceType createServiceType(String name, String description) throws SqlQueriesException {
        ServiceType serviceType = new ServiceType().setType(name).setDescription(description);
        long id = this.ISQLQueries.insert(serviceType);
        return serviceType.setId(id);
    }

    public ISQLQueries getSqlQueries() {
        return this.ISQLQueries;
    }

    public Service getServiceByUuid(String uuid) throws SqlQueriesException {
        Service dummy = new Service();
        String where = String.valueOf(dummy.getUuid().k()) + "=?";
        ArrayList<Object> whereArgs = new ArrayList<Object>();
        whereArgs.add(uuid);
        List<Service> sqlTableObjects = this.ISQLQueries.load(dummy.getAllAttributes(), dummy, where, whereArgs);
        if (sqlTableObjects.size() > 0) {
            return sqlTableObjects.get(0);
        }
        return null;
    }

    public Service createService(Long typeId, String name) throws SqlQueriesException {
        Service service = new Service().setUuid(UUID.randomUUID().toString()).setTypeId(typeId).setName(name);
        Long id = this.ISQLQueries.insert(service);
        return service.setId(id);
    }

    public void grant(Long serviceId, Long certificateId) throws SqlQueriesException {
        Approval approval = new Approval();
        approval.setServiceid(serviceId);
        approval.setCertificateId(certificateId);
        this.ISQLQueries.insert(approval);
    }

    public List<Service> getAllowedServices(Long certificateId) throws SqlQueriesException {
        return this.approvalDao.getAllowedServices(certificateId);
    }

    public boolean isApproved(Long certificateId, Long serviceId) throws SqlQueriesException {
        return this.approvalDao.isApproved(certificateId, serviceId);
    }

    public List<ServiceJoinServiceType> getAllServices() throws SqlQueriesException {
        return this.serviceDao.getAllServices();
    }

    public List<Approval> getAllApprovals() throws SqlQueriesException {
        return this.approvalDao.getAllApprovals();
    }

    public DatabaseManager saveApprovals(ApprovalMatrix approvalMatrix) throws SqlQueriesException {
        this.approvalDao.clear();
        for (Long serviceId : approvalMatrix.getMatrix().keySet()) {
            for (Approval approval : approvalMatrix.getMatrix().get(serviceId).values()) {
                this.approvalDao.insertApproval(approval);
            }
        }
        return this;
    }

    public List<Service> getServicesByType(Long typeId) throws SqlQueriesException {
        Service dummy = new Service();
        String where = String.valueOf(dummy.getTypeId().k()) + "=?";
        ArrayList<Object> whereArgs = new ArrayList<Object>();
        whereArgs.add(typeId);
        List<Service> sqlTableObjects = this.ISQLQueries.load(dummy.getAllAttributes(), dummy, where, whereArgs);
        ArrayList<Service> result2 = new ArrayList<Service>();
        for (SQLTableObject sQLTableObject : sqlTableObjects) {
            result2.add((Service)sQLTableObject);
        }
        return result2;
    }

    public List<ServiceJoinServiceType> getAllowedServicesJoinTypes(Long certId) throws SqlQueriesException {
        Service s = new Service();
        ServiceType t = new ServiceType();
        Approval a2 = new Approval();
        Certificate c2 = new Certificate();
        ServiceJoinServiceType dummy = new ServiceJoinServiceType();
        String query = "select s." + s.getId().k() + ",s." + s.getUuid().k() + ",s." + s.getName().k() + ", t." + t.getType().k() + ", t." + t.getDescription().k() + " from " + s.getTableName() + " s" + " left join " + t.getTableName() + " t on s." + s.getTypeId().k() + "=t." + t.getId().k() + " left join " + a2.getTableName() + " a on s." + s.getId().k() + "=a." + a2.getServiceid().k() + " left join " + c2.getTableName() + " c on c." + c2.getId().k() + "=a." + a2.getCertificateId().k() + " where c." + c2.getId().k() + "=?";
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(certId);
        List<ServiceJoinServiceType> result2 = this.ISQLQueries.loadString(dummy.getAllAttributes(), dummy, query, args);
        ArrayList<ServiceJoinServiceType> services = new ArrayList<ServiceJoinServiceType>();
        for (SQLTableObject sQLTableObject : result2) {
            services.add((ServiceJoinServiceType)sQLTableObject);
        }
        return services;
    }

    public void updateService(Service service) throws SqlQueriesException {
        this.serviceDao.update(service);
    }

    public void deleteService(Long serviceId) throws SqlQueriesException {
        this.serviceDao.delete(serviceId);
    }

    public void revoke(Long serviceId, Long certificateId) throws SqlQueriesException {
        Approval approval = new Approval();
        String where = String.valueOf(approval.getServiceid().k()) + "=? and " + approval.getCertificateId().k() + "=?";
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(serviceId);
        args.add(certificateId);
        this.ISQLQueries.delete(approval, where, args);
    }

    public static interface SQLConnectionCreator {
        public ISQLQueries createConnection(DatabaseManager var1) throws SQLException, ClassNotFoundException;
    }

    public static interface SqlInputStreamInjector {
        public InputStream createSqlFileInputStream();
    }
}

