/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.data.db;

import de.mein.auth.data.access.CertificateManager;
import de.mein.auth.tools.Hash;
import de.mein.core.serialize.JsonIgnore;
import de.mein.core.serialize.SerializableEntity;
import de.mein.sql.Pair;
import de.mein.sql.SQLTableObject;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class Certificate
extends SQLTableObject
implements SerializableEntity {
    private Pair<Long> id = new Pair<Long>(Long.class, "id");
    private Pair<String> uuid = new Pair<String>(String.class, "uuid");
    private Pair<String> answerUuid = new Pair<String>(String.class, "answeruuid");
    private Pair<byte[]> certificate = new Pair<byte[]>(byte[].class, "certificate");
    private Pair<String> address = new Pair<String>(String.class, "address");
    private Pair<Integer> port = new Pair<Integer>(Integer.class, "port");
    private Pair<Integer> certDeliveryPort = new Pair<Integer>(Integer.class, "certport");
    private Pair<String> name = new Pair<String>(String.class, "name");
    private Pair<String> greeting = new Pair<String>(String.class, "greeting");
    private Pair<Boolean> trusted = new Pair<Boolean>(Boolean.class, "trusted");
    @JsonIgnore
    private Pair<String> hash = new Pair<String>(String.class, "hash");

    public int hashCode() {
        int hash = this.id.v() == null ? super.hashCode() : this.id.v().hashCode();
        return hash;
    }

    public Pair<String> getGreeting() {
        return this.greeting;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Certificate) {
            Certificate c2 = (Certificate)obj;
            boolean r = c2.id.v() == null && this.id.v() == null || c2.id.v() == null == (this.id.v() == null) || c2.getId().v().equals(this.id.v());
            return r;
        }
        return false;
    }

    public Certificate setGreeting(String greeting) {
        this.greeting.v(greeting);
        return this;
    }

    public Certificate() {
        this.init();
    }

    public PublicKey getPublicKey() throws CertificateException {
        byte[] certBytes = this.certificate.v();
        X509Certificate x509Certificate = CertificateManager.loadX509CertificateFromBytes(certBytes);
        PublicKey publicKey = x509Certificate.getPublicKey();
        return publicKey;
    }

    @Override
    public String getTableName() {
        return "certificate";
    }

    @Override
    protected void init() {
        this.certificate.setSetListener(value -> {
            try {
                this.hash.v(Hash.sha256(value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return value;
        });
        this.populateInsert(this.uuid, this.answerUuid, this.name, this.certificate, this.address, this.greeting, this.port, this.certDeliveryPort, this.trusted, this.hash);
        this.populateAll(this.id);
    }

    public Pair<Long> getId() {
        return this.id;
    }

    public Certificate setId(Long id) {
        this.id.v(id);
        return this;
    }

    public Pair<String> getHash() {
        return this.hash;
    }

    public Pair<Integer> getPort() {
        return this.port;
    }

    public Pair<Integer> getCertDeliveryPort() {
        return this.certDeliveryPort;
    }

    public Pair<String> getUuid() {
        return this.uuid;
    }

    public Certificate setUuid(String uuid) {
        this.uuid.v(uuid);
        return this;
    }

    public Pair<String> getAnswerUuid() {
        return this.answerUuid;
    }

    public Certificate setAnswerUuid(String answerUuid) {
        this.answerUuid.v(answerUuid);
        return this;
    }

    public Pair<byte[]> getCertificate() {
        return this.certificate;
    }

    public Certificate setCertificate(byte[] certificate) {
        this.certificate.v(certificate);
        return this;
    }

    public Pair<String> getAddress() {
        return this.address;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        return InetAddress.getByName(this.address.v());
    }

    public Certificate setAddress(String address) {
        this.address.v(address);
        return this;
    }

    public Pair<String> getName() {
        return this.name;
    }

    public Certificate setName(String name) {
        this.name.v(name);
        return this;
    }

    public X509Certificate getX509Certificate() throws CertificateException {
        X509Certificate x509Certificate = CertificateManager.loadX509CertificateFromBytes(this.certificate.v());
        return x509Certificate;
    }

    public Certificate setPort(Integer port) {
        this.port.v(port);
        return this;
    }

    public Certificate setCertDeliveryPort(Integer certDeliveryPort) {
        this.certDeliveryPort.v(certDeliveryPort);
        return this;
    }

    public Pair<Boolean> getTrusted() {
        return this.trusted;
    }

    public Certificate setTrusted(Boolean trusted) {
        this.trusted.v(trusted);
        return this;
    }
}

