/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.data.db.dao;

import de.mein.auth.data.db.Certificate;
import de.mein.sql.Dao;
import de.mein.sql.ISQLQueries;
import de.mein.sql.SQLTableObject;
import de.mein.sql.SqlQueriesException;
import java.util.ArrayList;
import java.util.List;

public class CertificateDao
extends Dao.ConnectionLockingDao {
    public CertificateDao(ISQLQueries ISQLQueries2) {
        super(ISQLQueries2);
    }

    public CertificateDao(ISQLQueries ISQLQueries2, boolean lock) {
        super(ISQLQueries2, lock);
    }

    public List<Certificate> getTrustedCertificates() throws SqlQueriesException {
        Certificate dummy = new Certificate();
        List<Certificate> re = this.sqlQueries.load(dummy.getAllAttributes(), dummy, String.valueOf(dummy.getTrusted().k()) + "=?", ISQLQueries.whereArgs(true));
        return re;
    }

    public Certificate insertCertificate(Certificate certificate) throws SqlQueriesException {
        return certificate.setId(this.sqlQueries.insert(certificate));
    }

    public boolean existsUUID(String uuid) throws SqlQueriesException {
        Certificate dummy = new Certificate();
        String where = String.valueOf(dummy.getUuid().k()) + "=?";
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(uuid);
        List<Certificate> result2 = this.sqlQueries.load(dummy.getAllAttributes(), dummy, where, args);
        return result2.size() > 0;
    }

    public void updateCertificate(Certificate certificate) throws SqlQueriesException {
        ArrayList<Object> whereArgs = new ArrayList<Object>();
        whereArgs.add(certificate.getId().v());
        this.sqlQueries.update(certificate, String.valueOf(certificate.getId().k()) + "=?", whereArgs);
    }

    public Certificate getTrustedCertificateByUuid(String uuid) throws SqlQueriesException {
        Certificate dummy = new Certificate();
        String where = String.valueOf(dummy.getUuid().k()) + "=? and " + dummy.getTrusted().k() + "=?";
        List<Certificate> result2 = this.sqlQueries.load(dummy.getAllAttributes(), dummy, where, ISQLQueries.whereArgs(uuid, true));
        return result2.get(0);
    }

    public Certificate getTrustedCertificateById(Long id) throws SqlQueriesException {
        Certificate dummy = new Certificate();
        String where = String.valueOf(dummy.getId().k()) + "=? and " + dummy.getTrusted().k() + "=?";
        List<Certificate> result2 = this.sqlQueries.load(dummy.getAllAttributes(), dummy, where, ISQLQueries.whereArgs(id, true));
        if (result2.size() == 1) {
            return result2.get(0);
        }
        return null;
    }

    public Certificate getCertificateById(Long id) throws SqlQueriesException {
        Certificate dummy = new Certificate();
        String where = String.valueOf(dummy.getId().k()) + "=?";
        List<Certificate> result2 = this.sqlQueries.load(dummy.getAllAttributes(), dummy, where, ISQLQueries.whereArgs(id));
        if (result2.size() == 1) {
            return result2.get(0);
        }
        return null;
    }

    public void delete(Long id) throws SqlQueriesException {
        Certificate dummy = new Certificate().setId(id);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(id);
        this.sqlQueries.delete(dummy, String.valueOf(dummy.getId().k()) + "=?", args);
    }

    public List<Certificate> getCertificatesByGreeting(String greeting) throws SqlQueriesException {
        Certificate dummy = new Certificate();
        String where = String.valueOf(dummy.getGreeting().k()) + "=?";
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(greeting);
        List<Certificate> re = this.sqlQueries.load(dummy.getAllAttributes(), dummy, where, args);
        ArrayList<Certificate> result2 = new ArrayList<Certificate>();
        for (SQLTableObject sQLTableObject : re) {
            result2.add((Certificate)sQLTableObject);
        }
        return result2;
    }

    public Certificate getCertificateByBytes(byte[] certBytes) throws SqlQueriesException {
        Certificate dummy = new Certificate();
        String where = String.valueOf(dummy.getCertificate().k()) + "=?";
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(certBytes);
        List<Certificate> result2 = this.sqlQueries.load(dummy.getAllAttributes(), dummy, where, args);
        if (result2.size() == 1) {
            return result2.get(0);
        }
        return null;
    }

    public void trustCertificate(Long certId, boolean trusted) throws SqlQueriesException {
        Certificate cert = new Certificate();
        String sql = "update " + cert.getTableName() + " set " + cert.getTrusted().k() + "=? where " + cert.getId().k() + "=?";
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(trusted);
        args.add(certId);
        this.sqlQueries.execute(sql, args);
        System.out.println("CertificateDao.trustCertificate");
    }

    public Certificate getTrustedCertificateByHash(String hash) throws SqlQueriesException {
        Certificate dummy = new Certificate();
        String where = String.valueOf(dummy.getHash().k()) + "=? and " + dummy.getTrusted().k() + "=?";
        List<Certificate> result2 = this.sqlQueries.load(dummy.getAllAttributes(), dummy, where, ISQLQueries.whereArgs(hash, true));
        if (result2.size() == 1) {
            return result2.get(0);
        }
        return null;
    }
}

