/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.service;

import de.mein.auth.socket.process.val.MeinValidationProcess;
import de.mein.auth.tools.WaitLock;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class ConnectedEnvironment
extends WaitLock {
    private Map<Long, MeinValidationProcess> idValidateProcessMap = new ConcurrentHashMap<Long, MeinValidationProcess>();
    private Map<String, MeinValidationProcess> addressValidateProcessMap = new ConcurrentHashMap<String, MeinValidationProcess>();

    public synchronized void addValidationProcess(MeinValidationProcess validationProcess) {
        this.idValidateProcessMap.put(validationProcess.getConnectedId(), validationProcess);
        this.addressValidateProcessMap.put(validationProcess.getAddressString(), validationProcess);
    }

    public Collection<MeinValidationProcess> getValidationProcesses() {
        return this.idValidateProcessMap.values();
    }

    public MeinValidationProcess getValidationProcess(Long certificateId) {
        return this.idValidateProcessMap.get(certificateId);
    }

    public MeinValidationProcess getValidationProcess(String address) {
        return this.addressValidateProcessMap.get(address);
    }

    public List<Long> getConnectedIds() {
        return this.idValidateProcessMap.values().stream().map(MeinValidationProcess::getConnectedId).collect(Collectors.toList());
    }

    public synchronized void removeValidationProcess(MeinValidationProcess process) {
        this.addressValidateProcessMap.remove(process.getAddressString());
        this.idValidateProcessMap.remove(process.getConnectedId());
    }
}

