/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.service;

import de.mein.DeferredRunnable;
import de.mein.MeinRunnable;
import de.mein.auth.MeinAuthAdmin;
import de.mein.auth.broadcast.MeinAuthBrotCaster;
import de.mein.auth.data.ApprovalMatrix;
import de.mein.auth.data.MeinAuthSettings;
import de.mein.auth.data.NetworkEnvironment;
import de.mein.auth.data.access.CertificateManager;
import de.mein.auth.data.access.DatabaseManager;
import de.mein.auth.data.db.Certificate;
import de.mein.auth.data.db.ServiceJoinServiceType;
import de.mein.auth.jobs.ConnectJob;
import de.mein.auth.jobs.IsolatedConnectJob;
import de.mein.auth.jobs.NetworkEnvDiscoveryJob;
import de.mein.auth.service.ConnectedEnvironment;
import de.mein.auth.service.IDBCreatedListener;
import de.mein.auth.service.IMeinService;
import de.mein.auth.service.MeinAuthWorker;
import de.mein.auth.service.MeinBoot;
import de.mein.auth.service.MeinService;
import de.mein.auth.socket.MeinAuthSocket;
import de.mein.auth.socket.MeinSocket;
import de.mein.auth.socket.ShamefulSelfConnectException;
import de.mein.auth.socket.process.reg.IRegisterHandler;
import de.mein.auth.socket.process.reg.IRegisteredHandler;
import de.mein.auth.socket.process.transfer.MeinIsolatedProcess;
import de.mein.auth.socket.process.val.MeinServicesPayload;
import de.mein.auth.socket.process.val.MeinValidationProcess;
import de.mein.auth.socket.process.val.Request;
import de.mein.auth.tools.N;
import de.mein.auth.tools.WaitLock;
import de.mein.core.serialize.exceptions.JsonSerializationException;
import de.mein.core.serialize.serialize.fieldserializer.FieldSerializerFactoryRepository;
import de.mein.sql.SqlQueriesException;
import de.mein.sql.deserialize.PairDeserializerFactory;
import de.mein.sql.serialize.PairSerializerFactory;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.jdeferred.Deferred;
import org.jdeferred.Promise;
import org.jdeferred.impl.DeferredObject;

public class MeinAuthService {
    private static Logger logger;
    public static final String SERVICE_NAME = "meinauth";
    public static final String INTENT_REGISTER = "reg";
    public static final String INTENT_AUTH = "auth";
    public static final String INTENT_GET_SERVICES = "getservices";
    private final MeinAuthSettings settings;
    private MeinAuthWorker meinAuthWorker;
    protected final CertificateManager certificateManager;
    private final IDBCreatedListener dbCreatedListener;
    private List<MeinAuthAdmin> meinAuthAdmins = new ArrayList<MeinAuthAdmin>();
    private final DatabaseManager databaseManager;
    private final File workingDirectory;
    protected List<IRegisterHandler> registerHandlers = new ArrayList<IRegisterHandler>();
    private List<IRegisteredHandler> registeredHandlers = new ArrayList<IRegisteredHandler>();
    private NetworkEnvironment networkEnvironment = new NetworkEnvironment();
    private Set<MeinSocket> sockets = new HashSet<MeinSocket>();
    private ConnectedEnvironment connectedEnvironment = new ConnectedEnvironment();
    private WaitLock uuidServiceMapSemaphore = new WaitLock();
    private Map<String, MeinService> uuidServiceMap = new ConcurrentHashMap<String, MeinService>();
    private MeinAuthBrotCaster brotCaster;
    private MeinBoot meinBoot;
    private DeferredObject<DeferredRunnable, Exception, Void> startedPromise;

    static {
        FieldSerializerFactoryRepository.addAvailableSerializerFactory(PairSerializerFactory.getInstance());
        FieldSerializerFactoryRepository.addAvailableDeserializerFactory(PairDeserializerFactory.getInstance());
        logger = Logger.getLogger(MeinAuthService.class.getName());
    }

    MeinAuthService(MeinAuthSettings meinAuthSettings, IDBCreatedListener dbCreatedListener) throws Exception {
        this.workingDirectory = meinAuthSettings.getWorkingDirectory();
        this.databaseManager = new DatabaseManager(meinAuthSettings);
        this.certificateManager = new CertificateManager(this.workingDirectory, this.databaseManager.getSqlQueries(), 1024);
        this.settings = meinAuthSettings;
        this.dbCreatedListener = dbCreatedListener;
        if (this.databaseManager.hadToInitialize() && this.dbCreatedListener != null) {
            this.dbCreatedListener.onDBcreated(this.databaseManager);
        }
        this.addRegisteredHandler((meinAuthService, registered) -> this.notifyAdmins());
    }

    public MeinAuthSettings getSettings() {
        return this.settings;
    }

    public List<Long> getConnectedUserIds() {
        List<Long> ids = this.connectedEnvironment.getConnectedIds();
        return ids;
    }

    public MeinAuthService addMeinAuthAdmin(MeinAuthAdmin admin) {
        this.meinAuthAdmins.add(admin);
        return this;
    }

    public void notifyAdmins() {
        for (MeinAuthAdmin admin : this.meinAuthAdmins) {
            admin.onChanged();
        }
    }

    MeinAuthService(MeinAuthSettings meinAuthSettings) throws Exception {
        this(meinAuthSettings, null);
    }

    public MeinAuthService addRegisteredHandler(IRegisteredHandler IRegisteredHandler2) {
        this.registeredHandlers.add(IRegisteredHandler2);
        return this;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public List<IRegisteredHandler> getRegisteredHandlers() {
        return this.registeredHandlers;
    }

    public MeinAuthService addRegisterHandler(IRegisterHandler registerHandler) {
        this.registerHandlers.add(registerHandler);
        return this;
    }

    public DeferredObject<DeferredRunnable, Exception, Void> prepareStart() {
        N.r(() -> {
            MeinAuthWorker meinAuthWorker = this.meinAuthWorker = new MeinAuthWorker(this, this.settings);
        });
        this.startedPromise = this.meinAuthWorker.getStartedDeferred();
        return this.startedPromise;
    }

    public void start() {
        this.execute(this.meinAuthWorker);
        for (MeinAuthAdmin admin : this.meinAuthAdmins) {
            admin.start(this);
        }
    }

    public List<Certificate> getTrustedCertificates() throws SqlQueriesException {
        List<Certificate> certs = this.certificateManager.getTrustedCertificates();
        return certs;
    }

    public CertificateManager getCertificateManager() {
        return this.certificateManager;
    }

    public String getName() {
        return this.settings.getName();
    }

    public Certificate getMyCertificate() throws CertificateEncodingException {
        Certificate certificate = new Certificate();
        certificate.setCertificate(this.certificateManager.getMyX509Certificate().getEncoded());
        certificate.setName(this.settings.getName());
        return certificate;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "." + this.settings.getName();
    }

    public List<IRegisterHandler> getRegisterHandlers() {
        return this.registerHandlers;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public Request<MeinServicesPayload> getAllowedServices(Long certificateId) throws JsonSerializationException, IllegalAccessException {
        MeinValidationProcess validationProcess = this.connectedEnvironment.getValidationProcess(certificateId);
        Request promise = validationProcess.request(SERVICE_NAME, INTENT_GET_SERVICES, null);
        return promise;
    }

    public IMeinService getMeinService(String serviceUuid) {
        return this.uuidServiceMap.get(serviceUuid);
    }

    public MeinAuthService registerMeinService(MeinService meinService) throws SqlQueriesException {
        if (meinService.getUuid() == null) {
            System.err.println("MeinAuthService.registerMeinService: MeinService.UUID was NULL");
        }
        this.uuidServiceMapSemaphore.lock();
        this.uuidServiceMap.put(meinService.getUuid(), meinService);
        if (this.meinAuthWorker.getStartedDeferred().isResolved()) {
            meinService.onMeinAuthIsUp();
        }
        this.uuidServiceMapSemaphore.unlock();
        this.notifyAdmins();
        return this;
    }

    public MeinAuthService unregisterMeinService(Long serviceUuid) {
        this.uuidServiceMapSemaphore.lock();
        this.uuidServiceMap.remove(serviceUuid);
        this.uuidServiceMapSemaphore.unlock();
        this.notifyAdmins();
        return this;
    }

    public MeinAuthService setName(String name) {
        this.settings.setName(name);
        return this;
    }

    public static void main(String[] args) throws Exception {
        HashSet<InetAddress> addresses = new HashSet<InetAddress>();
        InetAddress i1 = InetAddress.getByName("127.0.0.1");
        InetAddress i2 = InetAddress.getByName("127.0.0.1");
        addresses.add(i1);
        addresses.add(i2);
        addresses.forEach(inetAddress -> System.out.println(inetAddress.toString()));
    }

    public void updateCertAddresses(Long remoteCertId, String address, Integer port, Integer portCert) throws SqlQueriesException {
        Certificate c2 = this.certificateManager.getTrustedCertificateById(remoteCertId);
        c2.setAddress(address).setCertDeliveryPort(portCert).setPort(port);
        this.certificateManager.updateCertificate(c2);
    }

    public Promise<MeinAuthService, Exception, Void> boot() {
        DeferredObject<MeinAuthService, Exception, Void> bootedPromise = new DeferredObject<MeinAuthService, Exception, Void>();
        DeferredObject<DeferredRunnable, Exception, Void> startedPromise = this.prepareStart();
        this.start();
        System.out.println("MeinAuthService.boot.trying to connect to everybody");
        startedPromise.done(result2 -> N.r(() -> {
            for (Certificate certificate : this.certificateManager.getTrustedCertificates()) {
                Promise<MeinValidationProcess, Exception, Void> connected = this.connect(certificate.getId().v(), certificate.getAddress().v(), certificate.getPort().v(), certificate.getCertDeliveryPort().v(), false);
                connected.done(mvp -> N.r(() -> {})).fail(result1 -> System.err.println("MeinAuthServive.boot.could not connect to: '" + certificate.getName().v() + "' address: " + certificate.getAddress().v()));
            }
        }));
        bootedPromise.resolve(this);
        return bootedPromise;
    }

    public MeinAuthService saveApprovals(ApprovalMatrix approvalMatrix) throws SqlQueriesException {
        this.databaseManager.saveApprovals(approvalMatrix);
        return this;
    }

    public <T extends MeinIsolatedProcess> DeferredObject<T, Exception, Void> connectToService(Class<T> isolatedServiceClass, Long certId, String remoteServiceUuid, String ownServiceUuid, String address, Integer port, Integer portCert) throws SqlQueriesException, InterruptedException {
        Certificate certificate = this.certificateManager.getTrustedCertificateById(certId);
        if (address == null) {
            address = certificate.getAddress().v();
        }
        if (port == null) {
            port = certificate.getPort().v();
        }
        if (portCert == null) {
            portCert = certificate.getCertDeliveryPort().v();
        }
        IsolatedConnectJob<T> job = new IsolatedConnectJob<T>(certId, address, port, portCert, remoteServiceUuid, ownServiceUuid, isolatedServiceClass);
        this.meinAuthWorker.addJob(job);
        return job.getPromise();
    }

    public synchronized Promise<MeinValidationProcess, Exception, Void> connect(Long certificateId) throws SqlQueriesException, InterruptedException {
        MeinValidationProcess mvp;
        DeferredObject<MeinValidationProcess, Exception, Void> deferred = new DeferredObject<MeinValidationProcess, Exception, Void>();
        Certificate certificate = this.certificateManager.getTrustedCertificateById(certificateId);
        this.connectedEnvironment.lock();
        if (certificateId != null && (mvp = this.connectedEnvironment.getValidationProcess(certificateId)) != null) {
            deferred.resolve(mvp);
        } else {
            mvp = this.connectedEnvironment.getValidationProcess(certificate.getAddress().v());
            if (mvp != null) {
                deferred.resolve(mvp);
            } else {
                ConnectJob job = new ConnectJob(certificateId, certificate.getAddress().v(), (int)certificate.getPort().v(), (int)certificate.getCertDeliveryPort().v(), false);
                job.getPromise().done(result2 -> {
                    Deferred deferred = deferred.resolve((MeinValidationProcess)result2);
                }).fail(result2 -> {
                    Deferred deferred = deferred.reject((Exception)result2);
                });
                this.meinAuthWorker.addJob(job);
            }
        }
        this.connectedEnvironment.unlock();
        return deferred;
    }

    public Promise<MeinValidationProcess, Exception, Void> connect(Long certificateId, String address, int port, int portCert, boolean regOnUnkown) throws InterruptedException {
        MeinValidationProcess mvp;
        DeferredObject<MeinValidationProcess, Exception, Void> deferred = new DeferredObject<MeinValidationProcess, Exception, Void>();
        if (certificateId != null && (mvp = this.connectedEnvironment.getValidationProcess(certificateId)) != null) {
            deferred.resolve(mvp);
        } else {
            mvp = this.connectedEnvironment.getValidationProcess(address);
            if (mvp != null) {
                deferred.resolve(mvp);
            } else {
                ConnectJob job = new ConnectJob(certificateId, address, port, portCert, regOnUnkown);
                job.getPromise().done(result2 -> {
                    Deferred deferred = deferred.resolve((MeinValidationProcess)result2);
                }).fail(result2 -> {
                    Deferred deferred = deferred.reject((Exception)result2);
                });
                this.meinAuthWorker.addJob(job);
            }
        }
        return deferred;
    }

    public Set<IMeinService> getMeinServices() {
        this.uuidServiceMapSemaphore.lock();
        HashSet<IMeinService> result2 = new HashSet<IMeinService>(this.uuidServiceMap.values());
        this.uuidServiceMapSemaphore.unlock();
        return result2;
    }

    public void setBrotCaster(MeinAuthBrotCaster brotCaster) {
        this.brotCaster = brotCaster;
    }

    public MeinAuthBrotCaster getBrotCaster() {
        return this.brotCaster;
    }

    private void addToNetworkEnvironment(Long certId, MeinServicesPayload meinServicesPayload) {
        this.networkEnvironment.add(certId, null);
        for (ServiceJoinServiceType service : meinServicesPayload.getServices()) {
            this.networkEnvironment.add(certId, service);
        }
    }

    private void connectAndCollect(Map<String, Boolean> checkedAddresses, NetworkEnvironment networkEnvironment, Certificate intendedCertificate) throws IOException, IllegalAccessException, SqlQueriesException, URISyntaxException, ClassNotFoundException, KeyManagementException, BadPaddingException, KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, UnrecoverableKeyException, CertificateException, NoSuchPaddingException, JsonSerializationException, IllegalBlockSizeException, InterruptedException {
        String address = MeinAuthSocket.getAddressString(intendedCertificate.getInetAddress(), intendedCertificate.getPort().v());
        N runner = new N(e -> e.printStackTrace());
        if (!checkedAddresses.containsKey(address)) {
            checkedAddresses.put(address, true);
            Promise<MeinValidationProcess, Exception, Void> authenticatedPromise = this.connect(intendedCertificate.getId().v(), intendedCertificate.getAddress().v(), intendedCertificate.getPort().v(), intendedCertificate.getCertDeliveryPort().v(), false);
            authenticatedPromise.done(meinValidationProcess -> runner.runTry(() -> {
                Request<MeinServicesPayload> servicesPromise = this.getAllowedServices(meinValidationProcess.getPartnerCertificate().getId().v());
                servicesPromise.done(meinServicesPayload -> runner.runTry(() -> this.addToNetworkEnvironment(meinValidationProcess.getPartnerCertificate().getId().v(), (MeinServicesPayload)meinServicesPayload)));
            })).fail(result2 -> logger.log(Level.SEVERE, "MeinAuthService.connectAndCollect.fail"));
        }
    }

    void discoverNetworkEnvironmentImpl() {
        N runner = new N(e -> e.printStackTrace());
        this.networkEnvironment.clear();
        ConcurrentHashMap checkedAddresses = new ConcurrentHashMap();
        runner.runTry(() -> {
            for (MeinValidationProcess validationProcess : this.connectedEnvironment.getValidationProcesses()) {
                Long certId = validationProcess.getConnectedId();
                this.networkEnvironment.add(certId, null);
                checkedAddresses.put(validationProcess.getAddressString(), true);
                Request<MeinServicesPayload> gotServicesPromise = this.getAllowedServices(certId);
                gotServicesPromise.done(meinServicesPayload -> {
                    logger.log(Level.SEVERE, "MeinAuthService.discoverNetworkEnvironment.NOT.IMPLEMENTED.YET");
                    this.addToNetworkEnvironment(certId, (MeinServicesPayload)meinServicesPayload);
                });
            }
            for (Certificate intendedCertificate : this.certificateManager.getTrustedCertificates()) {
                this.connectAndCollect(checkedAddresses, this.networkEnvironment, intendedCertificate);
            }
            this.meinAuthWorker.getBrotCaster().setBrotCasterListener((inetAddress, port, portCert) -> runner.runTry(() -> {
                String address = MeinAuthSocket.getAddressString(inetAddress, port);
                checkedAddresses.put(address, true);
                Promise<MeinValidationProcess, Exception, Void> promise = this.connect(null, inetAddress.getHostAddress(), port, portCert, false);
                promise.done(meinValidationProcess -> runner.runTry(() -> {
                    this.networkEnvironment.add(meinValidationProcess.getPartnerCertificate().getId().v(), null);
                    this.getAllowedServices(meinValidationProcess.getPartnerCertificate().getId().v()).done(meinServicesPayload -> runner.runTry(() -> {
                        for (ServiceJoinServiceType service : meinServicesPayload.getServices()) {
                            this.networkEnvironment.add(meinValidationProcess.getPartnerCertificate().getId().v(), service);
                        }
                    }));
                })).fail(result2 -> {
                    if (!(result2 instanceof ShamefulSelfConnectException)) {
                        this.networkEnvironment.addUnkown(inetAddress.getHostAddress(), port, portCert);
                    }
                });
            }));
            this.meinAuthWorker.getBrotCaster().discover(this.settings.getBrotcastPort());
        });
    }

    public MeinAuthService discoverNetworkEnvironment() {
        this.meinAuthWorker.addJob(new NetworkEnvDiscoveryJob());
        return this;
    }

    public NetworkEnvironment getNetworkEnvironment() {
        return this.networkEnvironment;
    }

    public void onSocketAuthenticated(MeinValidationProcess validationProcess) {
        this.connectedEnvironment.addValidationProcess(validationProcess);
    }

    public void onSocketClosed(MeinAuthSocket meinAuthSocket) {
        if (meinAuthSocket.isValidated()) {
            this.connectedEnvironment.lock();
            this.connectedEnvironment.removeValidationProcess((MeinValidationProcess)meinAuthSocket.getProcess());
            this.sockets.remove(meinAuthSocket);
            this.connectedEnvironment.unlock();
        }
    }

    public void execute(MeinRunnable runnable) {
        this.meinBoot.execute(runnable);
    }

    public void setMeinBoot(MeinBoot meinBoot) {
        this.meinBoot = meinBoot;
    }

    public void shutDown() {
        N.r(() -> {
            this.uuidServiceMapSemaphore.lock();
            for (MeinService service : this.uuidServiceMap.values()) {
                service.shutDown();
            }
            this.uuidServiceMapSemaphore.unlock();
            HashSet<MeinSocket> socks = new HashSet<MeinSocket>(this.sockets);
            for (MeinSocket socket : socks) {
                socket.shutDown();
            }
            this.meinAuthWorker.shutDown();
            this.meinBoot.shutDown();
        });
    }

    public void addMeinSocket(MeinSocket meinSocket) {
        this.sockets.add(meinSocket);
    }

    public MeinBoot getMeinBoot() {
        return this.meinBoot;
    }

    public MeinServicesPayload getAllowedServicesFor(Long certId) throws SqlQueriesException {
        MeinServicesPayload payload = new MeinServicesPayload();
        List<ServiceJoinServiceType> services = this.databaseManager.getAllowedServicesJoinTypes(certId);
        for (ServiceJoinServiceType service : services) {
            boolean running = this.getMeinService(service.getUuid().v()) != null;
            service.setRunning(running);
            payload.addService(service);
        }
        return payload;
    }

    public void onMeinAuthIsUp() {
        for (IMeinService meinService : this.getMeinServices()) {
            meinService.onMeinAuthIsUp();
        }
    }
}

