/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.service;

import de.mein.DeferredRunnable;
import de.mein.auth.broadcast.MeinAuthBrotCaster;
import de.mein.auth.data.MeinAuthSettings;
import de.mein.auth.jobs.AConnectJob;
import de.mein.auth.jobs.Job;
import de.mein.auth.jobs.NetworkEnvDiscoveryJob;
import de.mein.auth.service.MeinAuthService;
import de.mein.auth.service.MeinWorker;
import de.mein.auth.socket.MeinAuthSocket;
import de.mein.auth.socket.MeinAuthSocketOpener;
import de.mein.auth.socket.process.imprt.MeinAuthCertDelivery;
import de.mein.auth.socket.process.val.MeinValidationProcess;
import de.mein.core.serialize.exceptions.JsonSerializationException;
import de.mein.sql.SqlQueriesException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.jdeferred.Promise;
import org.jdeferred.impl.DefaultDeferredManager;
import org.jdeferred.impl.DeferredObject;

public class MeinAuthWorker
extends MeinWorker {
    private final int port;
    private MeinAuthSocketOpener socketOpener;
    private final MeinAuthService meinAuthService;
    protected MeinAuthCertDelivery certDelivery;
    protected MeinAuthBrotCaster brotCaster;

    public MeinAuthWorker(MeinAuthService meinAuthService, MeinAuthSettings meinAuthSettings) throws Exception {
        this.certDelivery = new MeinAuthCertDelivery(meinAuthService, meinAuthSettings.getDeliveryPort());
        this.meinAuthService = meinAuthService;
        this.port = meinAuthSettings.getPort();
        this.brotCaster = new MeinAuthBrotCaster(meinAuthService);
        meinAuthService.setBrotCaster(this.brotCaster);
    }

    @Override
    public void run() {
        DeferredObject<DeferredRunnable, Exception, Void> brotcasterPromise = this.brotCaster.getStartedDeferred();
        DeferredObject<DeferredRunnable, Exception, Void> certDeliveryPromise = this.certDelivery.getStartedDeferred();
        this.socketOpener = new MeinAuthSocketOpener(this.meinAuthService, this.port);
        DeferredObject<DeferredRunnable, Exception, Void> socketOpenerPromise = this.socketOpener.getStartedDeferred();
        this.meinAuthService.execute(this.brotCaster);
        this.meinAuthService.execute(this.certDelivery);
        this.meinAuthService.execute(this.socketOpener);
        new DefaultDeferredManager().when(certDeliveryPromise, socketOpenerPromise, brotcasterPromise).done(result2 -> {
            try {
                this.brotCaster.brotcast(9966, this.meinAuthService.getSettings().getDiscoverMessage());
                this.meinAuthService.onMeinAuthIsUp();
            }
            catch (IOException e) {
                System.err.println("brotcast went wrong :(");
                e.printStackTrace();
                this.startedPromise.resolve(this);
            }
            this.startedPromise.resolve(this);
        }).fail(result2 -> {
            System.out.println("MeinAuthWorker.runTry.STRANGE");
            this.startedPromise.reject(new Exception("keinen plan von nix"));
        });
        super.run();
    }

    @Override
    protected void workWork(Job job) throws Exception {
        System.out.println("MeinAuthWorker.workWork." + job.getClass().getSimpleName());
        if (job instanceof AConnectJob) {
            this.connect((AConnectJob)job);
        } else if (job instanceof NetworkEnvDiscoveryJob) {
            this.meinAuthService.discoverNetworkEnvironmentImpl();
        }
    }

    @Override
    public void addJob(Job job) {
        super.addJob(job);
    }

    private void connect(AConnectJob job) throws ClassNotFoundException, IllegalAccessException, NoSuchPaddingException, URISyntaxException, SqlQueriesException, KeyManagementException, BadPaddingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, UnrecoverableKeyException, JsonSerializationException, IOException, IllegalBlockSizeException, InterruptedException {
        MeinAuthSocket meinAuthSocket = new MeinAuthSocket(this.meinAuthService);
        System.out.println("MeinAuthWorker.connect: " + job.getAddress() + ":" + job.getPort() + ":" + job.getPortCert() + "?reg=" + job.getRegOnUnknown());
        Promise<MeinValidationProcess, Exception, Void> promise = meinAuthSocket.connect(job);
    }

    public MeinAuthBrotCaster getBrotCaster() {
        return this.brotCaster;
    }

    @Override
    public String getRunnableName() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.meinAuthService.getName();
    }

    @Override
    public void onShutDown() {
        this.certDelivery.shutDown();
        this.brotCaster.shutDown();
        this.socketOpener.shutDown();
        super.onShutDown();
    }
}

