/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.service;

import de.mein.DeferredRunnable;
import de.mein.MeinRunnable;
import de.mein.auth.data.MeinAuthSettings;
import de.mein.auth.data.access.DatabaseManager;
import de.mein.auth.data.db.Service;
import de.mein.auth.data.db.ServiceType;
import de.mein.auth.service.BootLoader;
import de.mein.auth.service.MeinAuthService;
import de.mein.auth.tools.BackgroundExecutor;
import de.mein.auth.tools.MeinDeferredManager;
import de.mein.sql.SqlQueriesException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdeferred.Promise;
import org.jdeferred.impl.DeferredObject;

public class MeinBoot
extends BackgroundExecutor
implements MeinRunnable {
    private static Logger logger = Logger.getLogger(MeinBoot.class.getName());
    private static Set<Class<? extends BootLoader>> bootloaderClasses = new HashSet<Class<? extends BootLoader>>();
    private static Map<String, Class<? extends BootLoader>> bootloaderMap = new HashMap<String, Class<? extends BootLoader>>();
    public static final File defaultWorkingDir1 = new File("meinauth.workingdir.1");
    public static final File defaultWorkingDir2 = new File("meinauth.workingdir.2");
    private DeferredObject<MeinAuthService, Exception, Void> deferredObject;
    private MeinAuthSettings meinAuthSettings;
    private MeinAuthService meinAuthService;

    public MeinBoot(MeinAuthSettings settings) {
        this.meinAuthSettings = settings;
        this.deferredObject = new DeferredObject();
    }

    public static void addBootLoaderClass(Class<? extends BootLoader> clazz) {
        bootloaderClasses.add(clazz);
    }

    public static Map<String, Class<? extends BootLoader>> getBootloaderMap() {
        return bootloaderMap;
    }

    public static Set<Class<? extends BootLoader>> getBootloaderClasses() {
        return bootloaderClasses;
    }

    public Promise<MeinAuthService, Exception, Void> boot() throws Exception {
        this.execute(this);
        return this.deferredObject;
    }

    public static void main(String[] args) {
    }

    @Override
    public void run() {
        try {
            this.meinAuthService = new MeinAuthService(this.meinAuthSettings);
            this.meinAuthService.setMeinBoot(this);
            DeferredObject<DeferredRunnable, Exception, Void> promiseAuthIsUp = this.meinAuthService.prepareStart();
            ArrayList<BootLoader> bootLoaders = new ArrayList<BootLoader>();
            for (Class<? extends BootLoader> bootClass : bootloaderClasses) {
                logger.log(Level.FINE, "MeinBoot.boot.booting: " + bootClass.getCanonicalName());
                BootLoader bootLoader = MeinBoot.createBootLoader(this.meinAuthService, bootClass);
                bootloaderMap.put(bootLoader.getName(), bootClass);
                bootLoaders.add(bootLoader);
            }
            ArrayList<Promise> bootedPromises = new ArrayList<Promise>();
            for (BootLoader bootLoader : bootLoaders) {
                List<Service> services;
                Promise<Void, Exception, Void> booted = bootLoader.boot(this.meinAuthService, services = this.meinAuthService.getDatabaseManager().getServicesByType(bootLoader.getTypeId()));
                if (booted == null) continue;
                bootedPromises.add(booted);
            }
            promiseAuthIsUp.done(result2 -> this.deferredObject.resolve(this.meinAuthService));
            new MeinDeferredManager().when(bootedPromises).done(nil -> this.meinAuthService.start()).fail(result2 -> System.err.println("MeinBoot.run.AT LEAST ONE SERVICE FAILED TO BOOT"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.deferredObject.reject(e);
        }
    }

    public static BootLoader createBootLoader(MeinAuthService meinAuthService, Class<? extends BootLoader> bootClass) throws SqlQueriesException, IllegalAccessException, InstantiationException {
        BootLoader bootLoader = bootClass.newInstance();
        bootLoader.setMeinAuthService(meinAuthService);
        DatabaseManager databaseManager = meinAuthService.getDatabaseManager();
        MeinAuthSettings meinAuthSettings = meinAuthService.getSettings();
        ServiceType serviceType = databaseManager.getServiceTypeByName(bootLoader.getName());
        if (serviceType == null) {
            serviceType = databaseManager.createServiceType(bootLoader.getName(), bootLoader.getDescription());
        }
        bootLoader.setTypeId(serviceType.getId().v());
        File bootDir = new File(meinAuthSettings.getWorkingDirectory() + File.separator + "servicetypes" + File.separator + serviceType.getType().v());
        bootDir.mkdirs();
        bootLoader.setBootLoaderDir(bootDir);
        return bootLoader;
    }

    public static BootLoader getBootLoader(MeinAuthService meinAuthService, String typeName) throws IllegalAccessException, SqlQueriesException, InstantiationException {
        Class<? extends BootLoader> bootClazz = bootloaderMap.get(typeName);
        BootLoader bootLoader = MeinBoot.createBootLoader(meinAuthService, bootClazz);
        return bootLoader;
    }

    @Override
    public String getRunnableName() {
        return this.getClass().getSimpleName();
    }

    @Override
    protected ExecutorService createExecutorService(ThreadFactory threadFactory) {
        return Executors.newCachedThreadPool(threadFactory);
    }
}

