/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.service;

import de.mein.MeinRunnable;
import de.mein.MeinThread;
import de.mein.auth.service.IMeinService;
import de.mein.auth.service.MeinAuthService;
import de.mein.auth.service.MeinWorker;
import java.io.File;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;

public abstract class MeinService
extends MeinWorker
implements IMeinService {
    protected final File serviceInstanceWorkingDirectory;
    protected MeinAuthService meinAuthService;
    protected Integer id;
    protected String uuid;
    private ExecutorService executorService;
    private final Semaphore threadSemaphore = new Semaphore(1, true);
    private final LinkedList<MeinThread> threadQueue = new LinkedList();
    private final ThreadFactory threadFactory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            MeinThread meinThread = null;
            try {
                MeinService.this.threadSemaphore.acquire();
                meinThread = (MeinThread)MeinService.this.threadQueue.poll();
                MeinService.this.threadSemaphore.release();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return meinThread;
        }
    };

    public MeinService(MeinAuthService meinAuthService, File serviceInstanceWorkingDirectory) {
        this.meinAuthService = meinAuthService;
        this.serviceInstanceWorkingDirectory = serviceInstanceWorkingDirectory;
        this.executorService = this.createExecutorService(this.threadFactory);
    }

    public File getServiceInstanceWorkingDirectory() {
        return this.serviceInstanceWorkingDirectory;
    }

    public Integer getId() {
        return this.id;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "." + this.meinAuthService.getName();
    }

    public void execute(MeinRunnable runnable) {
        try {
            if (this.executorService == null || this.executorService != null && (this.executorService.isShutdown() || this.executorService.isTerminated())) {
                this.executorService = this.createExecutorService(this.threadFactory);
            }
            this.threadSemaphore.acquire();
            this.threadQueue.add(new MeinThread(runnable));
            this.threadSemaphore.release();
            this.executorService.execute(runnable);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getRunnableName() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.meinAuthService.getName();
    }

    @Override
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public void onShutDown() {
        this.executorService.shutdown();
    }

    protected abstract ExecutorService createExecutorService(ThreadFactory var1);
}

