/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.service;

import de.mein.auth.jobs.Job;
import de.mein.auth.service.IMeinService;
import de.mein.auth.service.MeinAuthService;
import de.mein.auth.service.MeinService;
import de.mein.auth.socket.process.transfer.MeinIsolatedProcess;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public abstract class MeinServiceWorker
extends MeinService
implements IMeinService {
    protected LinkedList<Job> jobs = new LinkedList();
    private Map<String, MeinIsolatedProcess> isolatedProcessMap = new HashMap<String, MeinIsolatedProcess>();
    protected String uuid;

    public MeinServiceWorker(MeinAuthService meinAuthService, File workingDirectory) {
        super(meinAuthService, workingDirectory);
    }

    @Override
    public void onIsolatedConnectionEstablished(MeinIsolatedProcess isolatedProcess) {
        String key = isolatedProcess.getPartnerCertificateId() + "." + isolatedProcess.getPartnerServiceUuid();
        this.isolatedProcessMap.put(key, isolatedProcess);
    }

    public MeinIsolatedProcess getIsolatedProcess(Long partnerCertId, String partnerServiceUuid) {
        String key = partnerCertId + "." + partnerServiceUuid;
        return this.isolatedProcessMap.get(key);
    }

    @Override
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void runImpl() {
        try {
            while (true) {
                if (this.isInterrupted()) {
                    return;
                }
                this.queueLock.lockWrite();
                Job job = this.jobs.poll();
                this.queueLock.unlockWrite();
                if (job != null) {
                    try {
                        this.workWork(job);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (job.getPromise() == null) continue;
                        job.getPromise().reject(e);
                    }
                    continue;
                }
                this.waitLock.lock();
                System.out.println(String.valueOf(this.getRunnableName()) + "...unlocked");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected abstract void workWork(Job var1) throws Exception;

    @Override
    public synchronized void addJob(Job job) {
        this.queueLock.lockWrite();
        this.jobs.offer(job);
        this.queueLock.unlockWrite();
        this.waitLock.unlock();
    }

    @Override
    public void onShutDown() {
        super.onShutDown();
        this.queueLock.unlockWrite();
        this.waitLock.unlock();
    }

    public void start() {
        this.meinAuthService.execute(this);
    }
}

