/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.service;

import de.mein.DeferredRunnable;
import de.mein.auth.jobs.Job;
import de.mein.auth.tools.WaitLock;
import de.mein.sql.RWLock;
import java.util.LinkedList;

public abstract class MeinWorker
extends DeferredRunnable {
    protected LinkedList<Job> jobs = new LinkedList();
    protected RWLock queueLock = new RWLock();
    protected WaitLock waitLock = new WaitLock();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void runImpl() {
        try {
            while (true) {
                if (this.isInterrupted()) {
                    System.out.println(String.valueOf(this.getClass().getSimpleName()) + " has finished");
                    return;
                }
                this.queueLock.lockWrite();
                Job job = this.jobs.poll();
                this.queueLock.unlockWrite();
                if (job != null) {
                    try {
                        this.workWork(job);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                this.waitLock.lock();
                System.out.println(String.valueOf(this.getRunnableName()) + "...unlocked");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract void workWork(Job var1) throws Exception;

    public void addJob(Job job) {
        this.queueLock.lockWrite();
        this.jobs.offer(job);
        this.queueLock.unlockWrite();
        this.waitLock.unlock();
    }

    @Override
    public void onShutDown() {
        this.queueLock.unlockWrite();
        this.waitLock.unlock();
    }
}

