/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.socket;

import de.mein.auth.data.MeinRequest;
import de.mein.auth.jobs.AConnectJob;
import de.mein.auth.service.MeinAuthService;
import de.mein.auth.socket.CannotConnectException;
import de.mein.auth.socket.MeinProcess;
import de.mein.auth.socket.MeinSocket;
import de.mein.auth.socket.ShamefulSelfConnectException;
import de.mein.auth.socket.process.auth.MeinAuthProcess;
import de.mein.auth.socket.process.imprt.MeinCertRetriever;
import de.mein.auth.socket.process.reg.MeinRegisterProcess;
import de.mein.auth.socket.process.transfer.MeinIsolatedProcess;
import de.mein.auth.socket.process.val.MeinValidationProcess;
import de.mein.auth.tools.Hash;
import de.mein.auth.tools.N;
import de.mein.core.serialize.SerializableEntity;
import de.mein.core.serialize.deserialize.entity.SerializableEntityDeserializer;
import de.mein.core.serialize.exceptions.JsonSerializationException;
import de.mein.sql.SqlQueriesException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.net.ssl.SSLSocket;
import org.jdeferred.Promise;
import org.jdeferred.impl.DeferredObject;

public class MeinAuthSocket
extends MeinSocket
implements MeinSocket.MeinSocketListener {
    private static Logger logger = Logger.getLogger(MeinAuthSocket.class.getName());
    protected MeinProcess process;
    protected de.mein.auth.data.db.Certificate partnerCertificate;

    public MeinAuthSocket(MeinAuthService meinAuthService) {
        super(meinAuthService);
        this.setListener(this);
    }

    public de.mein.auth.data.db.Certificate getPartnerCertificate() {
        return this.partnerCertificate;
    }

    MeinAuthSocket setProcess(MeinProcess process) {
        this.process = process;
        return this;
    }

    public String getAddressString() {
        return MeinAuthSocket.getAddressString(this.socket.getInetAddress(), this.socket.getPort());
    }

    public static String getAddressString(InetAddress address, int port) {
        return String.valueOf(address.getHostAddress()) + ":" + port;
    }

    public MeinAuthSocket(MeinAuthService meinAuthService, Socket socket) {
        super(meinAuthService, socket);
        this.setListener(this);
    }

    @Override
    public MeinAuthSocket allowIsolation() {
        this.allowIsolation = true;
        return this;
    }

    public InetAddress getAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public void onIsolated() {
        ((MeinIsolatedProcess)this.process).onIsolated();
    }

    @Override
    public void onMessage(MeinSocket meinSocket, String msg) {
        try {
            MeinRequest request;
            System.out.println(String.valueOf(this.meinAuthService.getName()) + ".got: " + msg);
            SerializableEntityDeserializer deserializer = new SerializableEntityDeserializer();
            SerializableEntity deserialized = SerializableEntityDeserializer.deserialize(msg);
            if (deserialized instanceof MeinRequest && (request = (MeinRequest)deserialized).getAuthenticated() != null && request.getAuthenticated().booleanValue()) {
                System.out.println("MeinAuthSocket.onMessage.9djg90areh0g");
                System.out.println("MeinAuthSocket.onMessage.ij3g89wh9543w");
            }
            if (this.process != null) {
                this.process.onMessageReceived(deserialized, this);
            } else if (deserialized instanceof MeinRequest) {
                request = (MeinRequest)deserialized;
                if (request.getServiceUuid().equals("meinauth") && request.getIntent().equals("reg")) {
                    MeinRegisterProcess meinRegisterProcess = new MeinRegisterProcess(this);
                    this.process = meinRegisterProcess;
                    meinRegisterProcess.onMessageReceived(deserialized, this);
                } else if (request.getServiceUuid().equals("meinauth") && request.getIntent().equals("auth")) {
                    MeinAuthProcess meinAuthProcess = new MeinAuthProcess(this);
                    this.process = meinAuthProcess;
                    meinAuthProcess.onMessageReceived(deserialized, this);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void onError(Exception ex) {
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        System.out.println(String.valueOf(this.meinAuthService.getName()) + "." + this.getClass().getSimpleName() + ".onClose");
    }

    @Override
    public void onBlockReceived(byte[] block) {
        ((MeinIsolatedProcess)this.process).onBlockReceived(block);
    }

    public Promise<MeinValidationProcess, Exception, Void> connect(AConnectJob job) throws URISyntaxException, InterruptedException, UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException, InvalidKeyException, IllegalAccessException, NoSuchPaddingException, BadPaddingException, SqlQueriesException, IllegalBlockSizeException, ClassNotFoundException, JsonSerializationException {
        Long remoteCertId = job.getCertificateId();
        String address = job.getAddress();
        Integer port = job.getPort();
        Integer portCert = job.getPortCert();
        boolean regOnUnknown = job.getRegOnUnknown();
        System.out.println("MeinAuthSocket.connect(id=" + remoteCertId + " addr=" + address + " port=" + port + " portCert=" + portCert + " reg=" + regOnUnknown + ")");
        DeferredObject<MeinValidationProcess, Exception, Void> result2 = job.getPromise();
        N runner = new N(e -> result2.reject(e));
        DeferredObject<Void, Exception, Void> firstAuth = this.auth(job);
        firstAuth.done(result1 -> result2.resolve((MeinValidationProcess)result1)).fail(except -> {
            N n4 = runner.runTry(() -> {
                if (except instanceof ShamefulSelfConnectException) {
                    result2.reject((Exception)except);
                } else if (except instanceof ConnectException) {
                    System.err.println(String.valueOf(this.getClass().getSimpleName()) + " for " + this.meinAuthService.getName() + ".connect.HOST:NOT:REACHABLE");
                    result2.reject((Exception)except);
                } else if (regOnUnknown && remoteCertId == null) {
                    DeferredObject<de.mein.auth.data.db.Certificate, Exception, Object> importPromise = new DeferredObject<de.mein.auth.data.db.Certificate, Exception, Object>();
                    DeferredObject registered = new DeferredObject();
                    this.importCertificate(importPromise, address, port, portCert);
                    importPromise.done(importedCert -> runner.runTry(() -> {
                        job.setCertificateId(importedCert.getId().v());
                        this.register(registered, (de.mein.auth.data.db.Certificate)importedCert, address, port);
                        registered.done(registeredCert -> runner.runTry(() -> this.auth(job))).fail(exception -> {
                            exception.printStackTrace();
                            result2.reject((Exception)exception);
                        });
                    })).fail(ee -> {
                        ee.printStackTrace();
                        result2.reject((Exception)ee);
                    });
                } else if (!(except instanceof ShamefulSelfConnectException)) {
                    result2.reject(new CannotConnectException((Exception)except, address, port));
                } else {
                    result2.reject((Exception)except);
                }
            });
        });
        return result2;
    }

    public void importCertificate(DeferredObject<de.mein.auth.data.db.Certificate, Exception, Object> deferred, String address, int port, int portCert) throws URISyntaxException, InterruptedException {
        MeinCertRetriever retriever = new MeinCertRetriever(this.meinAuthService);
        retriever.retrieveCertificate(deferred, address, port, portCert);
    }

    private Promise<de.mein.auth.data.db.Certificate, Exception, Void> register(DeferredObject<de.mein.auth.data.db.Certificate, Exception, Void> result2, de.mein.auth.data.db.Certificate certificate, String address, Integer port) throws IllegalAccessException, SqlQueriesException, URISyntaxException, InvalidKeyException, NoSuchAlgorithmException, JsonSerializationException, CertificateException, KeyStoreException, ClassNotFoundException, KeyManagementException, BadPaddingException, UnrecoverableKeyException, NoSuchPaddingException, IOException, IllegalBlockSizeException, InterruptedException {
        MeinRegisterProcess meinRegisterProcess = new MeinRegisterProcess(this);
        return meinRegisterProcess.register(result2, certificate.getId().v(), address, port);
    }

    private DeferredObject<Void, Exception, Void> auth(AConnectJob job) {
        Long remoteCertId = job.getCertificateId();
        String address = job.getAddress();
        Integer port = job.getPort();
        Integer portCert = job.getPortCert();
        DeferredObject<Void, Exception, Void> deferred = new DeferredObject<Void, Exception, Void>();
        N runner = new N(e -> {
            e.printStackTrace();
            deferred.reject(e);
        });
        runner.runTry(() -> {
            MeinAuthProcess meinAuthProcess = new MeinAuthProcess(this);
            Promise<Void, Exception, Void> authPromise = meinAuthProcess.authenticate(job);
            authPromise.fail(ex -> {
                ex.printStackTrace();
                deferred.reject((Exception)ex);
            });
        });
        return deferred;
    }

    public Promise<Void, Exception, Void> connectSSL(String address, Integer port) throws InterruptedException, UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, IOException, URISyntaxException {
        DeferredObject<Void, Exception, Void> deferredObject = new DeferredObject<Void, Exception, Void>();
        Socket socket = this.meinAuthService.getCertificateManager().createSocket();
        MeinSocket meinSocket = new MeinSocket(this.meinAuthService);
        meinSocket.setSocket(socket).setAddress(address);
        return deferredObject;
    }

    public void connectSSL(Long certId, String address, int port) throws SqlQueriesException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        if (certId != null) {
            this.partnerCertificate = this.meinAuthService.getCertificateManager().getTrustedCertificateById(certId);
        }
        Socket socket = this.meinAuthService.getCertificateManager().createSocket();
        socket.connect(new InetSocketAddress(address, port));
        this.setSocket(socket);
        this.start();
    }

    public de.mein.auth.data.db.Certificate getTrustedPartnerCertificate() throws IOException, CertificateEncodingException, SqlQueriesException, ShamefulSelfConnectException {
        if (this.partnerCertificate == null) {
            SSLSocket sslSocket = (SSLSocket)this.socket;
            Certificate cert = sslSocket.getSession().getPeerCertificates()[0];
            byte[] certBytes = cert.getEncoded();
            String hash = Hash.sha256(certBytes);
            this.partnerCertificate = this.meinAuthService.getCertificateManager().getTrustedCertificateByHash(hash);
            if (this.partnerCertificate == null && Arrays.equals(this.meinAuthService.getCertificateManager().getPublicKey().getEncoded(), cert.getPublicKey().getEncoded())) {
                throw new ShamefulSelfConnectException();
            }
        }
        return this.partnerCertificate;
    }

    public void sendBlock(byte[] block) throws IOException {
        assert (block.length == 65557);
        this.out.write(block);
        this.out.flush();
    }

    public void disconnect() throws IOException {
        this.socket.close();
    }

    public boolean isValidated() {
        return this.process != null && this.process instanceof MeinValidationProcess;
    }

    @Override
    protected void onSocketClosed(Exception e) {
        this.meinAuthService.onSocketClosed(this);
    }

    public MeinProcess getProcess() {
        return this.process;
    }

    @Override
    public void onShutDown() {
        super.onShutDown();
    }
}

