/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.socket;

import de.mein.DeferredRunnable;
import de.mein.auth.service.MeinAuthService;
import de.mein.auth.socket.MeinAuthSocket;
import de.mein.auth.tools.N;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class MeinAuthSocketOpener
extends DeferredRunnable {
    private ServerSocket serverSocket;
    private final MeinAuthService meinAuthService;
    private final int port;

    public MeinAuthSocketOpener(MeinAuthService meinAuthService, int port) {
        this.meinAuthService = meinAuthService;
        this.port = port;
    }

    @Override
    public void onShutDown() {
        N.r(() -> this.serverSocket.close());
    }

    @Override
    public void runImpl() {
        block13: {
            try {
                try {
                    this.serverSocket = this.meinAuthService.getCertificateManager().createServerSocket();
                    this.serverSocket.bind(new InetSocketAddress(this.port));
                    this.startedPromise.resolve(this);
                    while (!Thread.currentThread().isInterrupted()) {
                        Socket socket = this.serverSocket.accept();
                        MeinAuthSocket meinSocket = new MeinAuthSocket(this.meinAuthService, socket);
                        meinSocket.start();
                    }
                }
                catch (Exception e) {
                    if (!this.isInterrupted()) {
                        System.err.println("MeinAuthSocketOpener.runTry.FAAAAAIL!");
                        e.printStackTrace();
                    }
                    try {
                        this.serverSocket.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.serverSocket.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                this.serverSocket.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("MeinAuthService.runTry.end");
    }

    @Override
    public String getRunnableName() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.meinAuthService.getName();
    }
}

