/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.socket;

import de.mein.auth.data.Dobject;
import de.mein.auth.data.IRequestHandler;
import de.mein.auth.data.MeinRequest;
import de.mein.auth.data.MeinResponse;
import de.mein.auth.data.StateMsg;
import de.mein.auth.data.db.Certificate;
import de.mein.auth.socket.MeinAuthSocket;
import de.mein.core.serialize.SerializableEntity;
import de.mein.core.serialize.exceptions.JsonSerializationException;
import de.mein.core.serialize.serialize.fieldserializer.entity.SerializableEntitySerializer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class MeinProcess
implements IRequestHandler {
    private static Logger logger = Logger.getLogger(MeinProcess.class.getName());
    public static final String STATE_OK = "ok";
    public static final String STATE_ERR = "err";
    protected MeinAuthSocket meinAuthSocket;
    protected Certificate partnerCertificate;
    protected Map<Long, Dobject> requestMap = new ConcurrentHashMap<Long, Dobject>();

    public MeinProcess(MeinAuthSocket meinAuthSocket) {
        this.meinAuthSocket = meinAuthSocket;
        meinAuthSocket.setProcess(this);
    }

    protected void send(SerializableEntity meinMessage) throws JsonSerializationException, IllegalAccessException {
        String json = SerializableEntitySerializer.serialize(meinMessage);
        logger.log(Level.FINEST, String.valueOf(this.meinAuthSocket.getMeinAuthService().getName()) + ".send: " + json);
        this.meinAuthSocket.send(json);
    }

    public void removeThyself() {
        this.meinAuthSocket.stop();
    }

    protected synchronized boolean handleAnswer(SerializableEntity deserialized) {
        Long answerId = null;
        if (deserialized instanceof MeinRequest) {
            answerId = ((MeinRequest)deserialized).getAnswerId();
        } else if (deserialized instanceof MeinResponse) {
            answerId = ((MeinResponse)deserialized).getResponseId();
        }
        if (answerId != null && this.requestMap.containsKey(answerId)) {
            StateMsg msg = (StateMsg)deserialized;
            Dobject deferred = this.requestMap.get(answerId);
            this.requestMap.remove(answerId);
            if (!msg.getState().equals(STATE_OK)) {
                if (msg.getPayload() != null) {
                    deferred.reject((Exception)((Object)msg.getPayload()));
                } else {
                    deferred.reject(new Exception("state was: " + msg.getState()));
                }
                return true;
            }
            deferred.check(deserialized);
            return true;
        }
        return false;
    }

    @Override
    public void queueForResponse(MeinRequest request) {
        this.requestMap.put(request.getRequestId(), request.getDobject());
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "." + this.meinAuthSocket.getMeinAuthService().getName();
    }

    public void stop() {
        this.meinAuthSocket.stop();
    }

    public abstract void onMessageReceived(SerializableEntity var1, MeinAuthSocket var2);
}

