/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.socket;

import de.mein.DeferredRunnable;
import de.mein.auth.jobs.BlockReceivedJob;
import de.mein.auth.jobs.Job;
import de.mein.auth.jobs.ReceivedJob;
import de.mein.auth.service.MeinAuthService;
import de.mein.auth.service.MeinWorker;
import de.mein.auth.tools.N;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;

public class MeinSocket
extends DeferredRunnable {
    private static Logger logger = Logger.getLogger(MeinSocket.class.getName());
    protected boolean allowIsolation = false;
    protected boolean isIsolated = false;
    private SocketWorker socketWorker;
    public static final String MODE_ISOLATE = "isolate";
    public static final int BLOCK_SIZE = 65557;
    protected MeinAuthService meinAuthService;
    private MeinThread thread;
    protected DataOutputStream out;
    protected DataInputStream in;
    protected SocketFactory socketFactory;
    protected String address;
    protected int port;
    protected Socket socket;
    private MeinSocketListener listener;
    private final int v;
    private static AtomicInteger vv = new AtomicInteger(0);

    public MeinSocket setIsolated(boolean isolated) {
        this.isIsolated = isolated;
        return this;
    }

    public MeinSocket setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
        return this;
    }

    public MeinAuthService getMeinAuthService() {
        return this.meinAuthService;
    }

    @Override
    public String getRunnableName() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.meinAuthService.getName();
    }

    public MeinSocket allowIsolation() {
        this.allowIsolation = true;
        return this;
    }

    public void start() {
        this.thread = new MeinThread(this);
        String name = "THREAD." + this.meinAuthService.getName() + "." + "id=" + this.v + "." + this.getClass().getSimpleName();
        this.thread.setName(name);
        System.out.println("MeinSocket.starting: " + name);
        this.thread.start();
    }

    public void send(String json) {
        try {
            this.out.writeUTF(json);
            this.out.flush();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "MeinSocket.send.error");
            e.printStackTrace();
        }
    }

    public MeinSocket setAddress(String address) {
        this.address = address;
        return this;
    }

    public MeinSocket setPort(int port) {
        this.port = port;
        return this;
    }

    public MeinSocket(MeinAuthService meinAuthService, Socket socket) {
        this(meinAuthService);
        this.socket = socket;
        this.streams();
    }

    public MeinSocket(MeinAuthService meinAuthService) {
        this.meinAuthService = meinAuthService;
        this.v = vv.getAndIncrement();
        meinAuthService.addMeinSocket(this);
    }

    private void streams() {
        try {
            this.in = new DataInputStream(this.socket.getInputStream());
            this.out = new DataOutputStream(this.socket.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MeinSocket setSocket(Socket socket) {
        this.socket = socket;
        this.streams();
        return this;
    }

    @Override
    public void onShutDown() {
        N.r(() -> this.socketWorker.shutDown());
        N.r(() -> this.socket.close());
    }

    @Override
    public void runImpl() {
        Thread thread = Thread.currentThread();
        try {
            try {
                if (this.socket == null) {
                    this.socket = this.socketFactory.createSocket();
                    this.socket.connect(new InetSocketAddress(this.address, this.port));
                }
                if (this.in == null || this.out == null) {
                    this.streams();
                }
                this.socketWorker = new SocketWorker(this, this.listener);
                this.meinAuthService.execute(this.socketWorker);
                while (!this.isInterrupted()) {
                    if (this.isIsolated && this.allowIsolation) {
                        byte[] bytes = new byte[65557];
                        this.in.readFully(bytes);
                        this.socketWorker.addJob(new BlockReceivedJob().setBlock(bytes));
                        continue;
                    }
                    String s = this.in.readUTF();
                    System.out.println(String.valueOf(this.meinAuthService.getName()) + ".MeinSocket.runTry.got: " + s);
                    if (s.equals(MODE_ISOLATE) && this.allowIsolation) {
                        if (!this.isIsolated) {
                            this.send(MODE_ISOLATE);
                        } else {
                            this.listener.onIsolated();
                        }
                        this.isIsolated = true;
                        continue;
                    }
                    this.socketWorker.addJob(new ReceivedJob().setMessage(s));
                }
                logger.log(Level.SEVERE, "MeinSocket.runTry.CLOSING");
                this.listener.onClose(42, "don't know shit", true);
            }
            catch (Exception e) {
                if (!this.isInterrupted()) {
                    String line = String.valueOf(this.meinAuthService.getName()) + "." + this.getClass().getSimpleName() + "." + this.socket.getClass().getSimpleName() + ".runTry.disconnected(interrupted? " + thread.isInterrupted() + ")";
                    if (line.startsWith("MA2.MeinAuthSocket.SSLSocketImpl.run") || line.startsWith("MA1.MeinAuthSocket.SSLSocketImpl.run")) {
                        System.out.println("MeinSocket.runImpl.943f938fw0io34");
                    }
                    System.err.println(line);
                    this.onSocketClosed(e);
                    e.printStackTrace();
                }
                try {
                    this.in.close();
                    this.out.close();
                    this.socket.close();
                    this.socketWorker.shutDown();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                this.in.close();
                this.out.close();
                this.socket.close();
                this.socketWorker.shutDown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void onSocketClosed(Exception e) {
        this.shutDown();
    }

    public MeinSocket setListener(MeinSocketListener listener) {
        this.listener = listener;
        return this;
    }

    public void stop() {
        try {
            if (this.thread != null) {
                this.in.close();
                this.out.close();
                this.thread.interrupt();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface MeinSocketListener {
        public void onIsolated();

        public void onMessage(MeinSocket var1, String var2);

        public void onOpen();

        public void onError(Exception var1);

        public void onClose(int var1, String var2, boolean var3);

        public void onBlockReceived(byte[] var1);
    }

    static class MeinThread
    extends Thread {
        public MeinThread(MeinSocket meinSocket) {
            super(meinSocket);
        }

        @Override
        public void interrupt() {
            super.interrupt();
        }
    }

    static class SocketWorker
    extends MeinWorker {
        private final MeinSocketListener listener;
        private final MeinSocket socket;

        SocketWorker(MeinSocket socket, MeinSocketListener listener) {
            this.socket = socket;
            this.listener = listener;
        }

        @Override
        protected void workWork(Job job) throws Exception {
            if (job instanceof ReceivedJob) {
                ReceivedJob receivedJob = (ReceivedJob)job;
                this.listener.onMessage(this.socket, receivedJob.getMessage());
            } else if (job instanceof BlockReceivedJob) {
                this.listener.onBlockReceived(((BlockReceivedJob)job).getBlock());
            }
        }

        @Override
        public String getRunnableName() {
            return String.valueOf(this.getClass().getSimpleName()) + " for " + this.socket.getMeinAuthService().getName();
        }

        @Override
        public void onShutDown() {
            System.out.println("SocketWorker.onShutDown, Runnable: " + this.getRunnableName());
            super.onShutDown();
        }

        @Override
        public void shutDown() {
            super.shutDown();
        }
    }
}

