/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.socket.process.auth;

import de.mein.auth.data.IsolationDetails;
import de.mein.auth.data.MeinRequest;
import de.mein.auth.data.MeinResponse;
import de.mein.auth.data.db.Certificate;
import de.mein.auth.data.db.Service;
import de.mein.auth.data.db.ServiceJoinServiceType;
import de.mein.auth.jobs.AConnectJob;
import de.mein.auth.jobs.ConnectJob;
import de.mein.auth.jobs.IsolatedConnectJob;
import de.mein.auth.service.IMeinService;
import de.mein.auth.service.MeinAuthService;
import de.mein.auth.socket.MeinAuthSocket;
import de.mein.auth.socket.MeinProcess;
import de.mein.auth.socket.ShamefulSelfConnectException;
import de.mein.auth.socket.process.transfer.MeinIsolatedProcess;
import de.mein.auth.socket.process.val.MeinServicesPayload;
import de.mein.auth.socket.process.val.MeinValidationProcess;
import de.mein.auth.tools.Cryptor;
import de.mein.auth.tools.N;
import de.mein.core.serialize.SerializableEntity;
import de.mein.core.serialize.exceptions.JsonSerializationException;
import de.mein.sql.SqlQueriesException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.jdeferred.Deferred;
import org.jdeferred.Promise;
import org.jdeferred.impl.DeferredObject;

public class MeinAuthProcess
extends MeinProcess {
    private String mySecret;
    private String decryptedSecret;
    private boolean partnerAuthenticated = false;
    private MeinValidationProcess validationProcess;

    public MeinAuthProcess(MeinAuthSocket meinAuthSocket) {
        super(meinAuthSocket);
    }

    public static void addAllowedServices(MeinAuthService meinAuthService, Certificate partnerCertificate, MeinResponse response) throws SqlQueriesException {
        MeinServicesPayload payload = meinAuthService.getAllowedServicesFor(partnerCertificate.getId().v());
        response.setPayLoad(payload);
    }

    @Override
    public void onMessageReceived(SerializableEntity deserialized, MeinAuthSocket socket) {
        try {
            if (!this.handleAnswer(deserialized)) {
                if (deserialized instanceof MeinRequest) {
                    MeinRequest request = (MeinRequest)deserialized;
                    try {
                        this.partnerCertificate = this.meinAuthSocket.getMeinAuthService().getCertificateManager().getTrustedCertificateByUuid(request.getUserUuid());
                        assert (this.partnerCertificate != null);
                        this.decryptedSecret = this.meinAuthSocket.getMeinAuthService().getCertificateManager().decrypt(request.getSecret());
                        this.mySecret = UUID.randomUUID().toString();
                        IsolationDetails isolationDetails = null;
                        if (request.getPayload() != null && request.getPayload() instanceof IsolationDetails) {
                            isolationDetails = (IsolationDetails)request.getPayload();
                        }
                        byte[] secret = Cryptor.encrypt(this.partnerCertificate, this.mySecret);
                        MeinRequest answer = request.request().setRequestHandler(this).queue().setDecryptedSecret(this.decryptedSecret).setSecret(secret);
                        IsolationDetails finalIsolationDetails = isolationDetails;
                        answer.getPromise().done(result2 -> {
                            MeinRequest r = (MeinRequest)result2;
                            MeinResponse response = r.reponse();
                            try {
                                if (r.getDecryptedSecret().equals(this.mySecret)) {
                                    if (finalIsolationDetails == null) {
                                        this.propagateAuthentication(this.partnerCertificate);
                                        MeinAuthProcess.addAllowedServices(this.meinAuthSocket.getMeinAuthService(), this.partnerCertificate, response);
                                        System.out.println(String.valueOf(this.meinAuthSocket.getMeinAuthService().getName()) + " AuthProcess leaves socket");
                                        MeinValidationProcess validationProcess = new MeinValidationProcess(socket, this.partnerCertificate);
                                        this.meinAuthSocket.getMeinAuthService().onSocketAuthenticated(validationProcess);
                                        this.send(response);
                                    } else {
                                        System.out.println("MeinAuthProcess.onMessageReceived");
                                        IMeinService service = this.meinAuthSocket.getMeinAuthService().getMeinService(finalIsolationDetails.getTargetService());
                                        this.getClass();
                                        Class<?> isolatedClass = Class.forName(finalIsolationDetails.getProcessClass());
                                        MeinIsolatedProcess isolatedProcess = MeinIsolatedProcess.instance(isolatedClass, this.meinAuthSocket, service, this.partnerCertificate.getId().v(), finalIsolationDetails.getSourceService(), finalIsolationDetails.getIsolationUuid());
                                        service.onIsolatedConnectionEstablished(isolatedProcess);
                                        this.send(response);
                                    }
                                } else {
                                    response.setState("err");
                                    this.send(response);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                this.removeThyself();
                            }
                        });
                        this.send(answer);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    System.out.println("MeinAuthProcess.onMessageReceived.ELSE1");
                }
            }
        }
        catch (Exception e) {
            try {
                socket.disconnect();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void propagateAuthentication(Certificate partnerCertificate) throws JsonSerializationException, IllegalAccessException, SqlQueriesException {
        List<Service> services = this.meinAuthSocket.getMeinAuthService().getDatabaseManager().getAllowedServices(partnerCertificate.getId().v());
        for (Service service : services) {
            IMeinService ins = this.meinAuthSocket.getMeinAuthService().getMeinService(service.getUuid().v());
            ins.connectionAuthenticated(partnerCertificate);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "." + this.meinAuthSocket.getMeinAuthService().getName();
    }

    public Promise<Void, Exception, Void> authenticate(AConnectJob job) throws SqlQueriesException, InterruptedException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException, URISyntaxException, IOException, CertificateException, NoSuchPaddingException, BadPaddingException, IllegalBlockSizeException, InvalidKeyException, ClassNotFoundException, JsonSerializationException, IllegalAccessException, ShamefulSelfConnectException {
        Long id = job.getCertificateId();
        String address = job.getAddress();
        Integer port = job.getPort();
        DeferredObject<Void, Exception, Void> deferred = new DeferredObject<Void, Exception, Void>();
        try {
            this.meinAuthSocket.connectSSL(id, address, port);
            this.mySecret = UUID.randomUUID().toString();
            if (this.partnerCertificate == null) {
                this.partnerCertificate = this.meinAuthSocket.getTrustedPartnerCertificate();
            }
            N runner = new N(e -> {
                e.printStackTrace();
                deferred.reject(e);
            });
            this.mySecret = UUID.randomUUID().toString();
            byte[] secret = Cryptor.encrypt(this.partnerCertificate, this.mySecret);
            MeinRequest request = new MeinRequest("meinauth", "auth").setRequestHandler(this).queue().setSecret(secret).setUserUuid(this.partnerCertificate.getAnswerUuid().v());
            if (job instanceof IsolatedConnectJob) {
                IsolatedConnectJob isolatedConnectJob = (IsolatedConnectJob)job;
                IsolationDetails isolationDetails = new IsolationDetails().setTargetService(isolatedConnectJob.getRemoteServiceUuid()).setSourceService(isolatedConnectJob.getOwnServiceUuid()).setIsolationUuid(((IsolatedConnectJob)job).getIsolatedUuid()).setProcessClass(((IsolatedConnectJob)job).getProcessClass().getCanonicalName());
                request.setPayLoad(isolationDetails);
            }
            request.getPromise().done(result2 -> {
                MeinRequest r = (MeinRequest)result2;
                if (r.getDecryptedSecret().equals(this.mySecret)) {
                    runner.runTry(() -> {
                        this.decryptedSecret = this.meinAuthSocket.getMeinAuthService().getCertificateManager().decrypt(r.getSecret());
                        MeinRequest answer = r.request().setDecryptedSecret(this.decryptedSecret).setAuthenticated(true).setRequestHandler(this).queue();
                        answer.getPromise().done(result1 -> runner.runTry(() -> {
                            if (job instanceof ConnectJob) {
                                this.propagateAuthentication(this.partnerCertificate);
                                System.out.println(String.valueOf(this.meinAuthSocket.getMeinAuthService().getName()) + " AuthProcess leaves socket");
                                MeinValidationProcess validationProcess = new MeinValidationProcess(this.meinAuthSocket, this.partnerCertificate);
                                this.meinAuthSocket.getMeinAuthService().onSocketAuthenticated(validationProcess);
                                job.getPromise().resolve(validationProcess);
                                Long[] actualRemoteCertId = new Long[1];
                                runner.runTry(() -> {
                                    longArray[0] = job.getCertificateId() == null ? this.partnerCertificate.getId().v() : job.getCertificateId();
                                    this.meinAuthSocket.getMeinAuthService().updateCertAddresses(actualRemoteCertId[0], address, port, job.getPortCert());
                                });
                            } else if (job instanceof IsolatedConnectJob) {
                                IsolatedConnectJob isolatedConnectJob = (IsolatedConnectJob)job;
                                if (this.partnerCertificate.getId().v() != job.getCertificateId()) {
                                    job.getPromise().reject(new Exception("not the partner I expected"));
                                } else {
                                    System.out.println("MeinAuthProcess.authenticate465");
                                    IMeinService service = this.meinAuthSocket.getMeinAuthService().getMeinService(isolatedConnectJob.getOwnServiceUuid());
                                    Class isolatedProcessClass = isolatedConnectJob.getProcessClass();
                                    MeinIsolatedProcess meinIsolatedProcess = MeinIsolatedProcess.instance(isolatedProcessClass, this.meinAuthSocket, service, this.partnerCertificate.getId().v(), isolatedConnectJob.getRemoteServiceUuid(), isolatedConnectJob.getIsolatedUuid());
                                    Promise<Void, Exception, Void> isolated = meinIsolatedProcess.sendIsolate();
                                    isolated.done(nil -> {
                                        service.onIsolatedConnectionEstablished(meinIsolatedProcess);
                                        meinIsolatedProcess.setService(service);
                                        job.getPromise().resolve(meinIsolatedProcess);
                                    }).fail(excc -> {
                                        Deferred deferred = job.getPromise().reject((Exception)excc);
                                    });
                                }
                            }
                        }));
                        this.send(answer);
                    });
                } else {
                    System.out.println("MeinAuthProcess.authenticate.error.decrypted.secret: " + r.getDecryptedSecret());
                    System.out.println("MeinAuthProcess.authenticate.error.should.be: " + this.mySecret);
                    deferred.reject(new Exception("find aok39ka"));
                }
            });
            this.send(request);
        }
        catch (Exception e2) {
            deferred.reject(e2);
        }
        return deferred;
    }

    public static void addAllowedServicesJoinTypes(MeinAuthService meinAuthService, Certificate partnerCertificate, MeinResponse response) throws SqlQueriesException {
        MeinServicesPayload payload = new MeinServicesPayload();
        response.setPayLoad(payload);
        List<ServiceJoinServiceType> servicesJoinTypes = meinAuthService.getDatabaseManager().getAllowedServicesJoinTypes(partnerCertificate.getId().v());
        for (ServiceJoinServiceType service : servicesJoinTypes) {
            boolean running = meinAuthService.getMeinService(service.getUuid().v()) != null;
            service.setRunning(running);
            payload.addService(service);
        }
        response.setPayLoad(payload);
    }
}

