/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.socket.process.imprt;

import de.mein.DeferredRunnable;
import de.mein.auth.data.MeinRequest;
import de.mein.auth.data.MeinResponse;
import de.mein.auth.data.access.CertificateManager;
import de.mein.auth.data.db.Certificate;
import de.mein.auth.service.MeinAuthService;
import de.mein.auth.socket.MeinSocket;
import de.mein.auth.tools.N;
import de.mein.core.serialize.deserialize.entity.SerializableEntityDeserializer;
import de.mein.core.serialize.serialize.fieldserializer.entity.SerializableEntitySerializer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;

public class MeinAuthCertDelivery
extends DeferredRunnable {
    private static Logger logger = Logger.getLogger(MeinAuthCertDelivery.class.getName());
    protected ServerSocket serverSocket;
    public static final String GET_CERT_ANSWER = "getCert.answer";
    public static final String GET_CERT = "getCert";
    private final CertificateManager certificateManager;
    protected DataOutputStream out;
    protected DataInputStream in;
    private MeinAuthService meinAuthService;
    private ServerSocketFactory serverSocketFactory;
    protected Integer port;
    protected MeinSocket.MeinSocketListener listener;

    public MeinAuthCertDelivery(final MeinAuthService meinAuthService, int port) throws Exception {
        this.meinAuthService = meinAuthService;
        this.certificateManager = meinAuthService.getCertificateManager();
        this.port = port;
        this.serverSocketFactory = ServerSocketFactory.getDefault();
        this.listener = new MeinSocket.MeinSocketListener(){

            @Override
            public void onIsolated() {
            }

            @Override
            public void onMessage(MeinSocket meinSocket, String messageString) {
                try {
                    logger.log(Level.FINEST, String.valueOf(meinAuthService.getName()) + ".MeinAuthCertDelivery.onMessage.got: " + messageString);
                    new SerializableEntityDeserializer();
                    MeinRequest request = (MeinRequest)SerializableEntityDeserializer.deserialize(messageString);
                    if (request.getServiceUuid().equals("meinauth") && request.getIntent().equals(MeinAuthCertDelivery.GET_CERT)) {
                        X509Certificate x509Certificate = MeinAuthCertDelivery.this.certificateManager.getMyX509Certificate();
                        Certificate certificate = new Certificate();
                        certificate.setCertificate(x509Certificate.getEncoded());
                        certificate.setName(meinAuthService.getName());
                        certificate.setGreeting(meinAuthService.getSettings().getGreeting());
                        certificate.setPort(meinAuthService.getSettings().getPort());
                        certificate.setCertDeliveryPort(meinAuthService.getSettings().getDeliveryPort());
                        MeinResponse answer = MeinAuthCertDelivery.createCertDeliveryAnswer(request, certificate);
                        SerializableEntitySerializer serializer = new SerializableEntitySerializer();
                        serializer.setEntity(answer);
                        String json = serializer.JSON();
                        meinSocket.send(json);
                    } else {
                        meinSocket.send("could not understand you");
                    }
                }
                catch (Exception e) {
                    meinSocket.send("Err\u00f6r");
                    e.printStackTrace();
                }
            }

            @Override
            public void onOpen() {
                logger.log(Level.FINEST, "MeinAuthCertDelivery.onOpen");
            }

            @Override
            public void onError(Exception ex) {
                logger.log(Level.FINEST, "MeinAuthCertDelivery.onError");
            }

            @Override
            public void onClose(int code, String reason, boolean remote) {
                logger.log(Level.FINEST, "MeinAuthCertDelivery.onClose");
            }

            @Override
            public void onBlockReceived(byte[] block) {
            }
        };
    }

    static MeinResponse createCertDeliveryAnswer(MeinRequest request, Certificate certificate) {
        return new MeinResponse().setCertificate(certificate).setResponseId(request.getRequestId());
    }

    public static MeinRequest createCertDeliveryGet() {
        return new MeinRequest("meinauth", GET_CERT);
    }

    @Override
    public void onShutDown() {
        N.r(() -> this.serverSocket.close());
    }

    @Override
    public void runImpl() {
        try {
            try {
                this.serverSocket = this.serverSocketFactory.createServerSocket();
                this.serverSocket.setReuseAddress(true);
                this.serverSocket.bind(new InetSocketAddress(this.port));
                this.startedPromise.resolve(null);
                while (!Thread.currentThread().isInterrupted()) {
                    Socket socket = this.serverSocket.accept();
                    this.in = new DataInputStream(socket.getInputStream());
                    this.out = new DataOutputStream(socket.getOutputStream());
                    String s = this.in.readUTF();
                    logger.log(Level.FINEST, String.valueOf(this.meinAuthService.getName()) + ".MeinAuthCertDelivery.runTry.got: " + s);
                    MeinSocket meinSocket = new MeinSocket(this.meinAuthService, socket);
                    this.listener.onMessage(meinSocket, s);
                    meinSocket.shutDown();
                }
                this.listener.onClose(42, "don't know shit...", true);
            }
            catch (Exception e) {
                if (!this.isInterrupted()) {
                    e.printStackTrace();
                }
                try {
                    this.in.close();
                    this.out.close();
                    this.serverSocket.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                this.in.close();
                this.out.close();
                this.serverSocket.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getRunnableName() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.meinAuthService.getName();
    }
}

