/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.socket.process.imprt;

import de.mein.DeferredRunnable;
import de.mein.auth.data.MeinRequest;
import de.mein.auth.data.MeinResponse;
import de.mein.auth.data.access.CertificateManager;
import de.mein.auth.data.db.Certificate;
import de.mein.auth.service.MeinAuthService;
import de.mein.auth.socket.MeinSocket;
import de.mein.auth.socket.ShamefulSelfConnectException;
import de.mein.auth.socket.process.imprt.MeinAuthCertDelivery;
import de.mein.core.serialize.deserialize.entity.SerializableEntityDeserializer;
import de.mein.core.serialize.exceptions.JsonSerializationException;
import de.mein.core.serialize.serialize.fieldserializer.entity.SerializableEntitySerializer;
import de.mein.sql.SqlQueriesException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdeferred.impl.DeferredObject;

public class MeinCertRetriever
extends DeferredRunnable {
    private static Logger logger = Logger.getLogger(MeinCertRetriever.class.getName());
    private final MeinAuthService meinAuthService;
    private final CertificateManager certificateManager;
    private Map<MeinSocket, Object> clientSockets = new ConcurrentHashMap<MeinSocket, Object>();
    private DeferredObject<Certificate, Exception, Object> deferred;
    private int portCert;
    private String address;
    private int port;
    private MeinSocket certDeliveryClient;

    public MeinCertRetriever(MeinAuthService meinAuthService) {
        this.meinAuthService = meinAuthService;
        this.certificateManager = meinAuthService.getCertificateManager();
    }

    public DeferredObject<Certificate, Exception, Object> retrieveCertificate(DeferredObject<Certificate, Exception, Object> deferred, String address, int port, int portCert) throws URISyntaxException, InterruptedException {
        this.address = address;
        this.port = port;
        this.portCert = portCert;
        this.deferred = deferred;
        this.meinAuthService.execute(this);
        return deferred;
    }

    public void register(String address) throws URISyntaxException, SqlQueriesException, CertificateEncodingException, JsonSerializationException, IllegalAccessException {
    }

    public void stop() {
    }

    @Override
    public String getRunnableName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void onShutDown() {
        this.certDeliveryClient.shutDown();
        for (MeinSocket socket : this.clientSockets.keySet()) {
            socket.shutDown();
        }
    }

    @Override
    public void runImpl() {
        block2: {
            try {
                logger.log(Level.FINER, "MeinCertRetriever.retrieveCertificate.ALPHONSO");
                URI uri = new URI(this.address);
                this.certDeliveryClient = new MeinSocket(this.meinAuthService);
                this.certDeliveryClient.setListener(new MeinSocket.MeinSocketListener(){

                    @Override
                    public void onIsolated() {
                    }

                    @Override
                    public void onMessage(MeinSocket meinSocket, String messageString) {
                        block6: {
                            logger.log(Level.FINEST, String.valueOf(MeinCertRetriever.this.meinAuthService.getName()) + ".MeinCertRetriever.onMessage.got: " + messageString);
                            try {
                                try {
                                    SerializableEntityDeserializer deserializer = new SerializableEntityDeserializer();
                                    MeinResponse response = (MeinResponse)SerializableEntityDeserializer.deserialize(messageString);
                                    Certificate certificate = response.getCertificate();
                                    X509Certificate x509Certificate = CertificateManager.loadX509CertificateFromBytes(certificate.getCertificate().v());
                                    boolean isItMe = Arrays.equals(MeinCertRetriever.this.certificateManager.getMyX509Certificate().getPublicKey().getEncoded(), x509Certificate.getPublicKey().getEncoded());
                                    if (isItMe) {
                                        MeinCertRetriever.this.deferred.reject(new ShamefulSelfConnectException());
                                        break block6;
                                    }
                                    Certificate result2 = MeinCertRetriever.this.certificateManager.importCertificate(x509Certificate, certificate.getName().v(), null, MeinCertRetriever.this.address, MeinCertRetriever.this.port, MeinCertRetriever.this.portCert, certificate.getGreeting().v());
                                    MeinCertRetriever.this.deferred.resolve(result2);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    MeinCertRetriever.this.deferred.reject(e);
                                    MeinCertRetriever.this.stop();
                                }
                            }
                            finally {
                                MeinCertRetriever.this.stop();
                            }
                        }
                    }

                    @Override
                    public void onOpen() {
                    }

                    @Override
                    public void onError(Exception ex) {
                        ex.printStackTrace();
                        MeinCertRetriever.this.deferred.reject(ex);
                        MeinCertRetriever.this.stop();
                    }

                    @Override
                    public void onClose(int code, String reason, boolean remote) {
                        MeinCertRetriever.this.clientSockets.remove(this);
                        MeinCertRetriever.this.stop();
                    }

                    @Override
                    public void onBlockReceived(byte[] block) {
                    }
                });
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(this.address, this.portCert));
                this.certDeliveryClient.setSocket(socket);
                this.certDeliveryClient.start();
                this.clientSockets.put(this.certDeliveryClient, 1);
                MeinRequest meinMessage = MeinAuthCertDelivery.createCertDeliveryGet();
                String json = SerializableEntitySerializer.serialize(meinMessage);
                this.certDeliveryClient.send(json);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.deferred.isRejected()) break block2;
                this.deferred.reject(e);
            }
        }
    }
}

