/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.socket.process.reg;

import de.mein.auth.data.MeinAuthSettings;
import de.mein.auth.data.MeinMessage;
import de.mein.auth.data.MeinRegisterConfirm;
import de.mein.auth.data.MeinRequest;
import de.mein.auth.data.MeinResponse;
import de.mein.auth.data.PartnerDidNotTrustException;
import de.mein.auth.data.access.CertificateManager;
import de.mein.auth.data.db.Certificate;
import de.mein.auth.socket.MeinAuthSocket;
import de.mein.auth.socket.MeinProcess;
import de.mein.auth.socket.process.reg.IRegisterHandler;
import de.mein.auth.socket.process.reg.IRegisterHandlerListener;
import de.mein.auth.socket.process.reg.IRegisteredHandler;
import de.mein.auth.tools.N;
import de.mein.core.serialize.SerializableEntity;
import de.mein.core.serialize.exceptions.JsonSerializationException;
import de.mein.core.serialize.serialize.fieldserializer.entity.SerializableEntitySerializer;
import de.mein.sql.SqlQueriesException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.jdeferred.Promise;
import org.jdeferred.impl.DefaultDeferredManager;
import org.jdeferred.impl.DeferredObject;

public class MeinRegisterProcess
extends MeinProcess {
    private CertificateManager certificateManager = null;
    private N runner = new N(Throwable::printStackTrace);
    private DeferredObject<MeinRegisterConfirm, Exception, Void> confirmedPromise = new DeferredObject();
    private DeferredObject<Certificate, Exception, Void> acceptedPromise = new DeferredObject();

    public MeinRegisterProcess(MeinAuthSocket meinAuthSocket) {
        super(meinAuthSocket);
        this.certificateManager = meinAuthSocket.getMeinAuthService().getCertificateManager();
        new DefaultDeferredManager().when(this.confirmedPromise, this.acceptedPromise).done(results -> {
            N n = this.runner.runTry(() -> {
                System.out.println(String.valueOf(meinAuthSocket.getMeinAuthService().getName()) + ".MeinRegisterProcess.MeinRegisterProcess");
                MeinRegisterConfirm confirm = (MeinRegisterConfirm)results.get(0).getResult();
                Certificate certificate = (Certificate)results.get(1).getResult();
                certificate.getAnswerUuid().v(confirm.getAnswerUuid());
                this.certificateManager.updateCertificate(certificate);
                this.certificateManager.trustCertificate(certificate.getId().v(), true);
                meinAuthSocket.getMeinAuthService().getRegisterHandlers().forEach(iRegisterHandler -> iRegisterHandler.onRegistrationCompleted(this.partnerCertificate));
                for (IRegisteredHandler handler : meinAuthSocket.getMeinAuthService().getRegisteredHandlers()) {
                    handler.onCertificateRegistered(meinAuthSocket.getMeinAuthService(), certificate);
                }
            });
        }).fail(results -> {
            N n = this.runner.runTry(() -> {
                System.out.println("MeinRegisterProcess.MeinRegisterProcess.rejected: " + results.getReject().toString());
                this.certificateManager.deleteCertificate(this.partnerCertificate);
                meinAuthSocket.getMeinAuthService().getRegisterHandlers().forEach(iRegisterHandler -> iRegisterHandler.onRegistrationCompleted(this.partnerCertificate));
                this.stop();
            });
        });
    }

    public Promise<Certificate, Exception, Void> register(DeferredObject<Certificate, Exception, Void> deferred, Long id, String address, int port) throws InterruptedException, SqlQueriesException, CertificateException, NoSuchPaddingException, NoSuchAlgorithmException, IOException, BadPaddingException, IllegalBlockSizeException, InvalidKeyException, ClassNotFoundException, JsonSerializationException, IllegalAccessException, URISyntaxException, UnrecoverableKeyException, KeyStoreException, KeyManagementException {
        System.out.println(String.valueOf(this.meinAuthSocket.getMeinAuthService().getName()) + ".MeinRegisterProcessImpl.register.id=" + id);
        this.meinAuthSocket.connectSSL(id, address, port);
        this.partnerCertificate = this.meinAuthSocket.getMeinAuthService().getCertificateManager().getCertificateById(id);
        Certificate myCert = new Certificate();
        myCert.setName(this.meinAuthSocket.getMeinAuthService().getName());
        myCert.setAnswerUuid(this.partnerCertificate.getUuid().v());
        myCert.setCertificate(this.meinAuthSocket.getMeinAuthService().getCertificateManager().getMyX509Certificate().getEncoded());
        MeinAuthSettings settings = this.meinAuthSocket.getMeinAuthService().getSettings();
        myCert.setPort(settings.getPort()).setGreeting(settings.getGreeting()).setCertDeliveryPort(settings.getDeliveryPort());
        MeinRequest request = new MeinRequest("meinauth", "reg").setCertificate(myCert).setRequestHandler(this).queue();
        for (IRegisterHandler regHandler : this.meinAuthSocket.getMeinAuthService().getRegisterHandlers()) {
            regHandler.acceptCertificate(new IRegisterHandlerListener(){

                @Override
                public void onCertificateAccepted(MeinRequest request, Certificate certificate) {
                    MeinRegisterProcess.this.runner.runTry(() -> {
                        MeinRegisterProcess.this.sendConfirmation(true);
                        MeinRegisterProcess.this.partnerCertificate = certificate;
                        MeinRegisterProcess.this.acceptedPromise.resolve(certificate);
                    });
                }

                @Override
                public void onCertificateRejected(MeinRequest request, Certificate certificate) {
                    MeinRegisterProcess.this.runner.runTry(() -> {
                        MeinRegisterProcess.this.sendConfirmation(false);
                        MeinRegisterProcess.this.acceptedPromise.reject(new PartnerDidNotTrustException());
                    });
                }
            }, request, this.meinAuthSocket.getMeinAuthService().getMyCertificate(), this.partnerCertificate);
        }
        request.getPromise().done(result2 -> {
            MeinRequest r = (MeinRequest)result2;
            Certificate certificate = r.getCertificate();
            try {
                this.partnerCertificate = this.meinAuthSocket.getMeinAuthService().getCertificateManager().addAnswerUuid(this.partnerCertificate.getId().v(), certificate.getAnswerUuid().v());
                MeinResponse response = r.reponse();
                response.setState("ok");
                this.send(response);
                this.removeThyself();
                this.meinAuthSocket.getMeinAuthService().getRegisteredHandlers().forEach(h -> {
                    try {
                        h.onCertificateRegistered(this.meinAuthSocket.getMeinAuthService(), this.partnerCertificate);
                    }
                    catch (SqlQueriesException e) {
                        e.printStackTrace();
                    }
                });
                deferred.resolve(this.partnerCertificate);
            }
            catch (Exception e) {
                e.printStackTrace();
                deferred.reject(e);
            }
        }).fail(result2 -> {
            System.out.println("MeinRegisterProcess.onFail!!!!!!!!");
            deferred.reject((Exception)result2);
        });
        new DefaultDeferredManager().when(this.confirmedPromise, this.acceptedPromise).done(result2 -> {
            System.out.println("MeinRegisterProcess.register");
            deferred.resolve(this.partnerCertificate);
        });
        String json = SerializableEntitySerializer.serialize(request);
        this.meinAuthSocket.send(json);
        return deferred;
    }

    public void sendConfirmation(boolean trusted) throws JsonSerializationException, IllegalAccessException {
        MeinMessage message = new MeinMessage("meinauth", null);
        if (trusted) {
            message.setPayLoad(new MeinRegisterConfirm().setConfirmed(trusted).setAnswerUuid(this.partnerCertificate.getUuid().v()));
        } else {
            message.setPayLoad(new MeinRegisterConfirm().setConfirmed(false));
        }
        this.send(message);
    }

    @Override
    public void onMessageReceived(SerializableEntity deserialized, MeinAuthSocket webSocket) {
        if (this.meinAuthSocket == null) {
            this.meinAuthSocket = webSocket;
        }
        if (!this.handleAnswer(deserialized)) {
            if (deserialized instanceof MeinRequest) {
                MeinRequest request = (MeinRequest)deserialized;
                try {
                    Certificate certificate = request.getCertificate();
                    if (this.meinAuthSocket.getMeinAuthService().getRegisterHandlers().size() == 0) {
                        System.out.println("MeinRegisterProcess.onMessageReceived.NO.HANDLER.FOR.REGISTRATION.AVAILABLE");
                    }
                    for (IRegisterHandler registerHandler : this.meinAuthSocket.getMeinAuthService().getRegisterHandlers()) {
                        registerHandler.acceptCertificate(new IRegisterHandlerListener(){

                            @Override
                            public void onCertificateAccepted(MeinRequest request, Certificate certificate) {
                                MeinRegisterProcess.this.runner.runTry(() -> {
                                    X509Certificate x509Certificate = CertificateManager.loadX509CertificateFromBytes(certificate.getCertificate().v());
                                    String address = MeinRegisterProcess.this.meinAuthSocket.getAddress().getHostAddress();
                                    int port = certificate.getPort().v();
                                    int portCert = certificate.getCertDeliveryPort().v();
                                    MeinRegisterProcess.this.partnerCertificate = MeinRegisterProcess.this.certificateManager.importCertificate(x509Certificate, certificate.getName().v(), certificate.getAnswerUuid().v(), address, port, portCert, certificate.getGreeting().v());
                                    MeinRegisterProcess.this.certificateManager.trustCertificate(MeinRegisterProcess.this.partnerCertificate.getId().v(), true);
                                    MeinRegisterProcess.this.sendConfirmation(true);
                                    for (IRegisteredHandler handler : MeinRegisterProcess.this.meinAuthSocket.getMeinAuthService().getRegisteredHandlers()) {
                                        handler.onCertificateRegistered(MeinRegisterProcess.this.meinAuthSocket.getMeinAuthService(), MeinRegisterProcess.this.partnerCertificate);
                                    }
                                    MeinRegisterProcess.this.acceptedPromise.resolve(MeinRegisterProcess.this.partnerCertificate);
                                });
                            }

                            @Override
                            public void onCertificateRejected(MeinRequest request, Certificate certificate) {
                                MeinRegisterProcess.this.runner.runTry(() -> {
                                    MeinRegisterProcess.this.sendConfirmation(false);
                                    MeinRegisterProcess.this.acceptedPromise.reject(new PartnerDidNotTrustException());
                                });
                            }
                        }, request, this.meinAuthSocket.getMeinAuthService().getMyCertificate(), certificate);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (deserialized instanceof MeinResponse) {
                System.out.println("MeinRegisterProcess.onMessageReceived.WRONG");
            } else if (deserialized instanceof MeinMessage) {
                MeinMessage message = (MeinMessage)deserialized;
                if (message.getPayload() != null && message.getPayload() instanceof MeinRegisterConfirm) {
                    MeinRegisterConfirm confirm = (MeinRegisterConfirm)message.getPayload();
                    if (confirm.isConfirmed()) {
                        this.confirmedPromise.resolve(confirm);
                    } else {
                        this.confirmedPromise.reject(new PartnerDidNotTrustException());
                    }
                }
            } else {
                System.out.println("MeinRegisterProcess.onMessageReceived.VERY.WRONG");
            }
        }
    }
}

