/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.socket.process.transfer;

import de.mein.core.serialize.JsonIgnore;
import de.mein.core.serialize.SerializableEntity;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;

public class FileTransferDetail
implements SerializableEntity {
    @JsonIgnore
    private long position;
    private File file;
    private int streamId;
    private FileInputStream in;
    private FileOutputStream out;
    private Long fsId;
    private String hash;
    @JsonIgnore
    private boolean transferred = false;
    private FileTransferDoneListener transferDoneListener;
    private long start;
    private long end;

    public FileTransferDetail() {
    }

    public FileTransferDetail setTransferDoneListener(FileTransferDoneListener transferDoneListener) {
        this.transferDoneListener = transferDoneListener;
        return this;
    }

    public FileTransferDetail(File file, int streamId, long start, long end) {
        this.file = file;
        this.streamId = streamId;
        this.start = start;
        this.end = end;
        this.position = start;
        this.assertCheck();
    }

    public FileTransferDetail setHash(String hash) {
        this.hash = hash;
        return this;
    }

    public String getHash() {
        return this.hash;
    }

    public Long getFsId() {
        return this.fsId;
    }

    public FileTransferDetail setFsId(Long fsId) {
        this.fsId = fsId;
        return this;
    }

    public FileTransferDetail setFile(File file) {
        this.file = file;
        this.assertCheck();
        return this;
    }

    private void assertCheck() {
        assert (!this.file.isDirectory());
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getPosition() {
        return this.position;
    }

    public File getFile() {
        return this.file;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public void onReceived(long offset, byte[] data) throws IOException {
        if (this.out == null) {
            this.out = new FileOutputStream(this.file);
        }
        FileChannel ch = this.out.getChannel();
        ch.position(offset);
        ch.write(ByteBuffer.wrap(data));
        this.position = offset + (long)data.length;
        if (this.position >= this.end) {
            assert (this.position == this.end);
            this.out.close();
            this.transferred = true;
            if (this.transferDoneListener != null) {
                this.transferDoneListener.onFileTransferDone(this);
            }
        }
    }

    public boolean transferred() {
        return this.transferred;
    }

    public FReadInfo readFile(long offset, int length) throws IOException {
        byte[] bytes = new byte[length];
        if (this.in == null) {
            this.in = new FileInputStream(this.file);
        }
        FileChannel ch = this.in.getChannel();
        ch.position(offset);
        int readBytes = ch.read(ByteBuffer.wrap(bytes));
        if (readBytes == -1) {
            bytes = new byte[]{};
        } else if (readBytes < length) {
            bytes = Arrays.copyOf(bytes, readBytes);
        }
        this.position += (long)readBytes;
        if (this.position == this.end) {
            this.in.close();
            this.transferred = true;
        }
        return new FReadInfo(bytes, length - readBytes);
    }

    public static class FReadInfo {
        private byte[] bytes;
        private int notFilledBytes = 0;

        public byte[] getBytes() {
            return this.bytes;
        }

        public int getNotFilledBytes() {
            return this.notFilledBytes;
        }

        public FReadInfo(byte[] bytes, int notFilledBytes) {
            this.bytes = bytes;
            this.notFilledBytes = notFilledBytes;
        }
    }

    public static interface FileTransferDoneListener {
        public void onFileTransferDone(FileTransferDetail var1);
    }
}

