/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.socket.process.transfer;

import de.mein.MeinRunnable;
import de.mein.auth.service.IMeinService;
import de.mein.auth.socket.MeinAuthSocket;
import de.mein.auth.socket.process.transfer.Block;
import de.mein.auth.socket.process.transfer.FileTransferDetail;
import de.mein.auth.socket.process.transfer.MeinIsolatedProcess;
import de.mein.auth.tools.ByteTools;
import de.mein.core.serialize.exceptions.JsonSerializationException;
import de.mein.sql.RWLock;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;

public class MeinIsolatedFileProcess
extends MeinIsolatedProcess
implements MeinRunnable {
    private Map<Integer, FileTransferDetail> streamIdFileMapReceiving = new TreeMap<Integer, FileTransferDetail>();
    private Queue<FileTransferDetail> sendingDetails = new LinkedList<FileTransferDetail>();
    private Semaphore sendingSemaphore = new Semaphore(1, true);
    private Semaphore receivingSemaphore = new Semaphore(1, true);
    private RWLock sendWaitLock = new RWLock();
    private static final int META_LENGTH = 17;

    public void addFilesReceiving(Collection<FileTransferDetail> fileTransferDetails) throws InterruptedException {
        this.receivingSemaphore.acquire();
        fileTransferDetails.forEach(d -> {
            FileTransferDetail fileTransferDetail = this.streamIdFileMapReceiving.put(d.getStreamId(), (FileTransferDetail)d);
        });
        this.receivingSemaphore.release();
    }

    public void addFilesReceiving(FileTransferDetail fileTransferDetail) throws InterruptedException {
        System.out.println("MeinIsolatedFileProcess.addFilesReceiving.ID: " + fileTransferDetail.getStreamId());
        this.receivingSemaphore.acquire();
        this.streamIdFileMapReceiving.put(fileTransferDetail.getStreamId(), fileTransferDetail);
        this.receivingSemaphore.release();
        System.out.println("MeinIsolatedFileProcess.addFilesReceiving.stored.hash: " + this.streamIdFileMapReceiving.get(fileTransferDetail.getStreamId()).getHash());
    }

    public MeinIsolatedFileProcess(MeinAuthSocket meinAuthSocket, IMeinService meinService, Long partnerCertificateId, String partnerServiceUuid, String isolatedUuid) {
        super(meinAuthSocket, meinService, partnerCertificateId, partnerServiceUuid, isolatedUuid);
        meinAuthSocket.getMeinAuthService().execute(this);
    }

    @Override
    public void onBlockReceived(byte[] bytes) {
        assert (bytes.length == 65557);
        byte[] streamBytes = Arrays.copyOfRange(bytes, 1, 5);
        int streamId = ByteTools.bytesToInt(streamBytes);
        Block block = new Block(streamId).setBytes(bytes);
        try {
            while (block.getFirstByteToProcessIndex() < block.getBytes().length && block.getBytes()[block.getFirstByteToProcessIndex()] != 0) {
                if (this.handleTransfer(block)) continue;
                System.err.println("MeinIsolatedFileProcess.onBlockReceived. did not know what to do :(");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean handleTransfer(Block block) throws IOException, InterruptedException {
        Character c2 = this.readCommand(block);
        if (c2.equals(Character.valueOf('T')) || c2.equals(Character.valueOf('t'))) {
            byte[] bytes = block.getBytes();
            int firstByteToProcess = block.getFirstByteToProcessIndex();
            int streamId = ByteTools.bytesToInt(bytes, firstByteToProcess + 1);
            long offset = ByteTools.bytesToLong(bytes, firstByteToProcess + 5);
            int length = ByteTools.bytesToInt(bytes, firstByteToProcess + 13);
            byte[] data = Arrays.copyOfRange(bytes, firstByteToProcess + 17, firstByteToProcess + 17 + length);
            assert (length == data.length);
            FileTransferDetail transferDetail = this.streamIdFileMapReceiving.get(streamId);
            if (transferDetail == null) {
                System.out.println("MeinIsolatedFileProcess.handleTransfer.NULL, id was: " + block.getStreamId());
            }
            transferDetail.onReceived(offset, data);
            assert (c2.equals(Character.valueOf('t')) == transferDetail.transferred());
            if (transferDetail.transferred() || c2.equals(Character.valueOf('t'))) {
                this.receivingSemaphore.acquire();
                System.out.println("MeinIsolatedFileProcess.handleTransfer.remove.receiving.id: " + transferDetail.getStreamId());
                this.streamIdFileMapReceiving.remove(streamId);
                this.receivingSemaphore.release();
            }
            block.setFirstByteToProcessIndex(firstByteToProcess + length + 17);
            return true;
        }
        return false;
    }

    private Character readCommand(Block block) {
        return Character.valueOf((char)block.getBytes()[block.getFirstByteToProcessIndex()]);
    }

    public void sendFile(FileTransferDetail transferDetail) throws IOException, JsonSerializationException, IllegalAccessException, InterruptedException {
        this.sendingSemaphore.acquire();
        this.sendingDetails.add(transferDetail);
        this.sendingSemaphore.release();
        this.sendWaitLock.unlockWrite();
    }

    @Override
    public void run() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                this.sendingSemaphore.acquire();
                FileTransferDetail details = this.sendingDetails.peek();
                this.sendingSemaphore.release();
                if (details != null && !Thread.currentThread().isInterrupted()) {
                    this.transfer();
                    continue;
                }
                this.sendWaitLock.lockWrite();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void transfer() throws JsonSerializationException, IllegalAccessException, IOException, InterruptedException {
        int blockOffset = 0;
        int bytesLeft = 65557;
        byte[] block = new byte[65557];
        FileTransferDetail transferDetail = this.sendingDetails.peek();
        while (transferDetail != null) {
            Character charToSend = Character.valueOf('T');
            if (transferDetail.transferred() || transferDetail.getPosition() == transferDetail.getEnd() || transferDetail.getEnd() - transferDetail.getPosition() <= (long)(bytesLeft - 17)) {
                charToSend = Character.valueOf('t');
            }
            blockOffset = ByteTools.fill(block, blockOffset, (byte[][])new byte[][]{charToSend.toString().getBytes(), ByteTools.intToBytes(transferDetail.getStreamId()), ByteTools.longToBytes(transferDetail.getPosition())});
            bytesLeft = 65557 - blockOffset - 4;
            FileTransferDetail.FReadInfo readResult = transferDetail.readFile(transferDetail.getPosition(), bytesLeft);
            blockOffset = ByteTools.fill(block, blockOffset, (byte[][])new byte[][]{ByteTools.intToBytes(readResult.getBytes().length), readResult.getBytes()});
            bytesLeft = 65557 - blockOffset;
            if (transferDetail.transferred() || readResult.getNotFilledBytes() > 0) {
                this.sendingSemaphore.acquire();
                this.sendingDetails.poll();
                this.sendingSemaphore.release();
            }
            if (bytesLeft > 0) {
                if (bytesLeft > 17) {
                    this.sendingSemaphore.acquire();
                    transferDetail = this.sendingDetails.peek();
                    this.sendingSemaphore.release();
                    if (transferDetail != null) continue;
                    this.meinAuthSocket.sendBlock(block);
                    continue;
                }
                transferDetail = null;
                this.meinAuthSocket.sendBlock(block);
                continue;
            }
            this.meinAuthSocket.sendBlock(block);
            transferDetail = null;
        }
    }

    @Override
    public String getRunnableName() {
        return this.getClass().getSimpleName();
    }
}

