/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.socket.process.transfer;

import de.mein.auth.service.IMeinService;
import de.mein.auth.socket.MeinAuthSocket;
import de.mein.auth.socket.MeinProcess;
import de.mein.auth.tools.ByteTools;
import de.mein.core.serialize.SerializableEntity;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.jdeferred.Promise;
import org.jdeferred.impl.DeferredObject;

public abstract class MeinIsolatedProcess
extends MeinProcess {
    private final String isolatedUuid;
    private IMeinService service;
    private final Long partnerCertificateId;
    private final String partnerServiceUuid;
    private DeferredObject isolatedPromise = new DeferredObject();

    public void setService(IMeinService service) {
        this.service = service;
    }

    public Long getPartnerCertificateId() {
        return this.partnerCertificateId;
    }

    public String getIsolatedUuid() {
        return this.isolatedUuid;
    }

    public String getPartnerServiceUuid() {
        return this.partnerServiceUuid;
    }

    public MeinIsolatedProcess(MeinAuthSocket meinAuthSocket, IMeinService meinService, Long partnerCertificateId, String partnerServiceUuid, String isolatedUuid) {
        super(meinAuthSocket);
        meinAuthSocket.allowIsolation();
        this.partnerCertificateId = partnerCertificateId;
        this.partnerServiceUuid = partnerServiceUuid;
        this.service = meinService;
        this.isolatedUuid = isolatedUuid;
    }

    public static MeinIsolatedProcess instance(Class<? extends MeinIsolatedProcess> clazz, MeinAuthSocket meinAuthSocket, IMeinService meinService, Long partnerCertificateId, String partnerServiceUuid, String isolatedUuid) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return clazz.getConstructor(MeinAuthSocket.class, IMeinService.class, Long.class, String.class, String.class).newInstance(meinAuthSocket, meinService, partnerCertificateId, partnerServiceUuid, isolatedUuid);
    }

    public void onIsolated() {
        this.isolatedPromise.resolve(null);
    }

    @Override
    public void onMessageReceived(SerializableEntity deserialized, MeinAuthSocket webSocket) {
        System.out.println("MeinIsolatedProcess.onMessageReceived");
    }

    public Promise<Void, Exception, Void> sendIsolate() {
        System.out.println("MeinIsolatedProcess.sendIsolate");
        this.meinAuthSocket.send("isolate");
        this.meinAuthSocket.setIsolated(true);
        return this.isolatedPromise;
    }

    public abstract void onBlockReceived(byte[] var1);

    private long readTransferOffSet(byte[] block) {
        return ByteTools.bytesToLong(Arrays.copyOfRange(block, 6, 14));
    }

    private long readTransferLength(byte[] block) {
        return ByteTools.bytesToLong(Arrays.copyOfRange(block, 15, 23));
    }
}

