/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.socket.process.val;

import de.mein.auth.data.IPayload;
import de.mein.auth.data.MeinMessage;
import de.mein.auth.data.MeinRequest;
import de.mein.auth.data.MeinResponse;
import de.mein.auth.data.StateMsg;
import de.mein.auth.data.db.Certificate;
import de.mein.auth.data.db.Service;
import de.mein.auth.service.IMeinService;
import de.mein.auth.socket.MeinAuthSocket;
import de.mein.auth.socket.MeinProcess;
import de.mein.auth.socket.process.auth.MeinAuthProcess;
import de.mein.auth.socket.process.val.Request;
import de.mein.core.serialize.SerializableEntity;
import de.mein.core.serialize.exceptions.JsonSerializationException;
import de.mein.sql.SqlQueriesException;
import java.util.Map;

public class MeinValidationProcess
extends MeinProcess {
    private final Long connectedId;
    private Map<Long, Request> promiseMap;

    public MeinValidationProcess(MeinAuthSocket meinAuthSocket, Certificate partnercertificate) {
        super(meinAuthSocket);
        this.meinAuthSocket = meinAuthSocket;
        this.connectedId = partnercertificate.getId().v();
        try {
            this.partnerCertificate = meinAuthSocket.getMeinAuthService().getCertificateManager().getTrustedCertificateById(this.connectedId);
        }
        catch (SqlQueriesException e) {
            e.printStackTrace();
        }
    }

    public Long getConnectedId() {
        return this.connectedId;
    }

    @Override
    public synchronized void onMessageReceived(SerializableEntity deserialized, MeinAuthSocket webSocket) {
        if (!this.handleAnswer(deserialized)) {
            try {
                if (!this.handleGetServices(deserialized) && !this.handleOther(deserialized)) {
                    System.out.println("MeinValidationProcess.onMessageReceived.something exploded here :/");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean handleOther(SerializableEntity deserialized) throws SqlQueriesException {
        if (deserialized instanceof MeinMessage) {
            MeinMessage message = (MeinMessage)deserialized;
            String serviceUuid = message.getServiceUuid();
            if (serviceUuid == null) {
                return this.handleAnswer(deserialized);
            }
            if (this.isServiceAllowed(serviceUuid)) {
                IMeinService meinService = this.meinAuthSocket.getMeinAuthService().getMeinService(serviceUuid);
                if (deserialized instanceof MeinRequest) {
                    MeinRequest request = (MeinRequest)deserialized;
                    Request validatePromise = new Request<IPayload>().setPayload(request.getPayload()).setPartnerCertificate(this.partnerCertificate).setIntent(request.getIntent());
                    validatePromise.done(newPayload -> {
                        MeinResponse response = request.reponse().setPayLoad((IPayload)newPayload);
                        try {
                            this.send(response);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.handleError(request, e);
                        }
                    }).fail(result2 -> this.handleError(request, (Exception)result2));
                    try {
                        meinService.handleRequest(validatePromise);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.handleError(request, e);
                    }
                    return true;
                }
                if (deserialized instanceof MeinMessage) {
                    MeinMessage meinMessage = (MeinMessage)deserialized;
                    meinService.handleMessage(meinMessage.getPayload(), this.partnerCertificate, meinMessage.getIntent());
                    return true;
                }
            }
        } else if (deserialized instanceof MeinResponse) {
            return this.handleAnswer(deserialized);
        }
        return false;
    }

    private void handleError(MeinRequest request, Exception e) {
        MeinResponse response = request.respondError(e);
        try {
            System.err.println("MeinValidationProcess for " + this.meinAuthSocket.getMeinAuthService().getName() + ".handleError");
            e.printStackTrace();
            this.send(response);
            System.err.println("MeinValidationProcess for " + this.meinAuthSocket.getMeinAuthService().getName() + ".handleError.done");
        }
        catch (JsonSerializationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
    }

    private boolean isServiceAllowed(String serviceUuid) throws SqlQueriesException {
        Service service = this.meinAuthSocket.getMeinAuthService().getDatabaseManager().getServiceByUuid(serviceUuid);
        return this.meinAuthSocket.getMeinAuthService().getDatabaseManager().isApproved(this.partnerCertificate.getId().v(), service.getId().v());
    }

    private boolean handleGetServices(SerializableEntity deserialized) throws JsonSerializationException, IllegalAccessException, SqlQueriesException {
        MeinRequest request;
        if (deserialized instanceof MeinRequest && (request = (MeinRequest)deserialized).getServiceUuid().equals("meinauth") && request.getIntent().equals("getservices")) {
            MeinResponse response = request.reponse();
            MeinAuthProcess.addAllowedServicesJoinTypes(this.meinAuthSocket.getMeinAuthService(), this.partnerCertificate, response);
            this.send(response);
            return true;
        }
        return false;
    }

    public Request request(String serviceUuid, String intent, IPayload payload) throws JsonSerializationException, IllegalAccessException {
        Request promise = new Request();
        MeinRequest request = new MeinRequest(serviceUuid, intent);
        if (payload != null) {
            request.setPayLoad(payload);
        }
        request.setRequestHandler(this).queue();
        request.getPromise().done(result2 -> {
            StateMsg response = (StateMsg)result2;
            promise.resolve(response.getPayload());
        }).fail(result2 -> {
            if (this.validateFail((Exception)result2)) {
                promise.reject(result2);
            } else {
                promise.reject(result2);
            }
        });
        this.send(request);
        return promise;
    }

    private boolean validateFail(Exception result2) {
        return false;
    }

    private boolean validateThingy(SerializableEntity result2) {
        return false;
    }

    public void message(String serviceUuid, String intent, IPayload payload) throws JsonSerializationException, IllegalAccessException {
        MeinMessage message = new MeinMessage(serviceUuid, intent).setPayLoad(payload);
        this.send(message);
    }

    public Certificate getPartnerCertificate() {
        return this.partnerCertificate;
    }

    public String getAddressString() {
        return this.meinAuthSocket.getAddressString();
    }
}

