/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.tools;

import de.mein.MeinRunnable;
import de.mein.MeinThread;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class BackgroundExecutor {
    private ExecutorService executorService;
    private final Semaphore threadSemaphore = new Semaphore(1, true);
    private final LinkedList<MeinThread> threadQueue = new LinkedList();
    private final ThreadFactory threadFactory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            MeinThread meinThread = null;
            try {
                BackgroundExecutor.this.threadSemaphore.acquire();
                meinThread = (MeinThread)BackgroundExecutor.this.threadQueue.poll();
                BackgroundExecutor.this.threadSemaphore.release();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return meinThread;
        }
    };

    public void execute(MeinRunnable runnable) {
        try {
            if (this.executorService == null || this.executorService != null && (this.executorService.isShutdown() || this.executorService.isTerminated())) {
                this.executorService = this.createExecutorService(this.threadFactory);
            }
            this.threadSemaphore.acquire();
            this.threadQueue.add(new MeinThread(runnable));
            this.threadSemaphore.release();
            this.executorService.execute(runnable);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void shutDown() throws InterruptedException {
        this.executorService.shutdown();
        this.executorService.awaitTermination(2000L, TimeUnit.MILLISECONDS);
    }

    protected abstract ExecutorService createExecutorService(ThreadFactory var1);
}

