/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.tools;

public class ByteTools {
    public static byte[] longToBytes(long l) {
        byte[] result2 = new byte[8];
        int i = 7;
        while (i >= 0) {
            result2[i] = (byte)(l & 0xFFL);
            l >>= 8;
            --i;
        }
        return result2;
    }

    public static long bytesToLong(byte[] b2) {
        long result2 = 0L;
        int i = 0;
        while (i < 8) {
            result2 <<= 8;
            result2 |= (long)(b2[i] & 0xFF);
            ++i;
        }
        return result2;
    }

    public static long bytesToLong(byte[] b2, int offset) {
        long result2 = 0L;
        int max = offset + 8;
        int i = offset;
        while (i < max) {
            result2 <<= 8;
            result2 |= (long)(b2[i] & 0xFF);
            ++i;
        }
        return result2;
    }

    public static int fill(byte[] target, byte[] ... sources) {
        return ByteTools.fill(target, 0, sources);
    }

    public static int fill(byte[] target, int offset, byte[] ... sources) {
        byte[][] byArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] source;
            byte[] byArray2 = source = byArray[n2];
            int n3 = source.length;
            int n4 = 0;
            while (n4 < n3) {
                byte b2 = byArray2[n4];
                if (offset == target.length) {
                    return offset;
                }
                target[offset] = b2;
                ++offset;
                ++n4;
            }
            ++n2;
        }
        return offset;
    }

    public static byte[] intToBytes(int i) {
        return new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
    }

    public static int bytesToInt(byte[] bytes) {
        return bytes[0] << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static int bytesToInt(byte[] bytes, int offset) {
        return bytes[offset] << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }
}

