/*
 * Decompiled with CFR 0.152.
 */
package de.mein.auth.tools;

import de.mein.sql.RWLock;
import java.util.concurrent.Semaphore;

public class RWSemaphore {
    private Semaphore semaphore = new Semaphore(1, true);
    private boolean write = false;
    private ReadLockCounter readLockCounter = new ReadLockCounter();
    private boolean locked = false;

    public synchronized RWSemaphore lockRead() {
        if (this.write) {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        RWLock.printStack("lockRead");
        this.readLockCounter.inc();
        return this;
    }

    public RWSemaphore unlockRead() {
        this.readLockCounter.dec();
        if (this.readLockCounter.getReadLockCount() == 0 && !this.write) {
            this.semaphore.release();
            RWLock.printStack("unlockRead");
        }
        return this;
    }

    public synchronized RWSemaphore unlockWrite() {
        if (this.write) {
            this.semaphore.release();
            this.write = false;
        }
        RWLock.printStack("unlockWrite");
        return this;
    }

    public synchronized RWSemaphore lockWrite() {
        try {
            this.semaphore.acquire();
            this.write = true;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        RWLock.printStack("lockWrite");
        return this;
    }

    class ReadLockCounter {
        private int readLockCount = 0;

        ReadLockCounter() {
        }

        public synchronized void inc() {
            ++this.readLockCount;
        }

        public synchronized void dec() {
            --this.readLockCount;
        }

        public int getReadLockCount() {
            return this.readLockCount;
        }
    }
}

