/*
 * Decompiled with CFR 0.152.
 */
package de.mein.core.serialize;

import de.mein.core.serialize.JsonIgnore;
import de.mein.core.serialize.SerializableEntity;
import de.mein.core.serialize.serialize.reflection.FieldAnalyzer;
import de.mein.core.serialize.serialize.tools.StringBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EntityAnalyzer {
    static final Map<String, Class<? extends SerializableEntity>> SIMPLECLASSNAME_CLASS_MAP = new HashMap<String, Class<? extends SerializableEntity>>(){
        private static final long serialVersionUID = 7276907138700440209L;
    };
    @JsonIgnore
    private static final Map<Class<? extends SerializableEntity>, List<Field>> CLASS_FIELDS_MAP = Collections.synchronizedMap(new HashMap());

    public static Class<? extends SerializableEntity> clazz(String className) throws ClassNotFoundException {
        Class<Object> clazz = null;
        if (SIMPLECLASSNAME_CLASS_MAP.containsKey(className)) {
            clazz = SIMPLECLASSNAME_CLASS_MAP.get(className);
        } else {
            clazz = Class.forName(className);
            if (SerializableEntity.class.isAssignableFrom(clazz)) {
                SIMPLECLASSNAME_CLASS_MAP.put(className, clazz);
            }
        }
        if (clazz == null) {
            System.err.println(String.valueOf(className) + " is not derived from Entity.class");
            throw new ClassNotFoundException(String.valueOf(className) + " is not derived from Entity.class");
        }
        return clazz;
    }

    public static String getType(SerializableEntity serializable) {
        return serializable.getClass().getName();
    }

    public static String toJSONlike(SerializableEntity serializable) {
        StringBuilder b2 = new StringBuilder();
        b2.objBegin();
        b2.key("__type");
        b2.eq();
        b2.value(EntityAnalyzer.getType(serializable));
        b2.comma();
        EntityAnalyzer.getFields(serializable.getClass()).forEach(field -> {
            b2.key(field.getName());
            b2.eq();
            field.setAccessible(true);
            try {
                b2.value(field.get(serializable));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            b2.comma();
        });
        b2.objEnd();
        return b2.toString();
    }

    public static String toString(SerializableEntity serializable) {
        StringBuilder b2 = new StringBuilder();
        b2.append("(").append(serializable.getClass()).append(")");
        b2.objBegin().lineBreak();
        boolean valueWritten = false;
        try {
            for (Field field : EntityAnalyzer.getFields(serializable.getClass())) {
                field.setAccessible(true);
                Class<?> fieldClazz = field.getType();
                Object fieldValue = field.get(serializable);
                if (fieldValue == null || Modifier.isTransient(field.getModifiers())) continue;
                if (valueWritten) {
                    b2.comma().lineBreak();
                }
                b2.key(field.getName()).eq();
                if (FieldAnalyzer.isCollectionClass(fieldClazz)) {
                    Set set = (Set)fieldValue;
                    Type type = field.getGenericType();
                    String typeString = "";
                    if (type instanceof ParameterizedType) {
                        ParameterizedType pType = (ParameterizedType)type;
                        Class clarz = (Class)pType.getActualTypeArguments()[0];
                        typeString = clarz.getSimpleName();
                    }
                    b2.arrBegin().append(typeString).append(" x " + set.size()).arrEnd();
                } else if (FieldAnalyzer.isEntitySerializable(field)) {
                    b2.objBegin().append(fieldClazz.getSimpleName()).objEnd();
                } else {
                    b2.value(fieldValue);
                }
                valueWritten = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        b2.lineBreak().objEnd();
        return b2.toString();
    }

    public static List<Field> getSerializableFields(SerializableEntity serializable) {
        ArrayList<Field> result2 = new ArrayList<Field>();
        for (Field field : EntityAnalyzer.getFields(serializable.getClass())) {
            if (Modifier.isTransient(field.getModifiers()) || FieldAnalyzer.isJsonIgnored(field)) continue;
            result2.add(field);
        }
        return result2;
    }

    public static List<Field> getFields(Class<? extends SerializableEntity> clazz) {
        List<Field> fields;
        if (!CLASS_FIELDS_MAP.containsKey(clazz)) {
            fields = FieldAnalyzer.collectFields(clazz);
            CLASS_FIELDS_MAP.put(clazz, fields);
        }
        fields = CLASS_FIELDS_MAP.get(clazz);
        return fields;
    }

    public static SerializableEntity instance(String simpleClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        SerializableEntity entity = EntityAnalyzer.clazz(simpleClassName).newInstance();
        return entity;
    }
}

