/*
 * Decompiled with CFR 0.152.
 */
package de.mein.core.serialize.deserialize;

import de.mein.core.serialize.SerializableEntity;
import de.mein.core.serialize.classes.BinarySerializableEntity;
import de.mein.core.serialize.classes.ChildSerializableEntity;
import de.mein.core.serialize.classes.SimpleSerializableEntity;
import de.mein.core.serialize.classes.WithPrimitiveCollection;
import de.mein.core.serialize.classes.WithSerializableEntityCollection;
import de.mein.core.serialize.deserialize.entity.SerializableEntityDeserializer;
import de.mein.core.serialize.exceptions.JsonDeserializationException;
import de.mein.core.serialize.exceptions.JsonSerializationException;
import de.mein.core.serialize.serialize.fieldserializer.entity.SerializableEntitySerializer;
import java.util.Base64;
import org.junit.Assert;
import org.junit.Test;

public class DeSerializationTest {
    private WithPrimitiveCollection createWithPrimitiveCollection() {
        WithPrimitiveCollection withPrimitiveCollection = new WithPrimitiveCollection();
        withPrimitiveCollection.strings.add("primitive.test");
        withPrimitiveCollection.strings.add("primitive.test.2");
        return withPrimitiveCollection;
    }

    private WithSerializableEntityCollection createWithEntitySerializableCollection() {
        WithSerializableEntityCollection withEntitySerializableCollection = new WithSerializableEntityCollection();
        withEntitySerializableCollection.entityserializables.add(new WithPrimitiveCollection());
        withEntitySerializableCollection.entityserializables.add(new WithPrimitiveCollection());
        return withEntitySerializableCollection;
    }

    public static String serialize(SerializableEntity serializable) {
        SerializableEntitySerializer serializer = new SerializableEntitySerializer();
        serializer.setEntity(serializable);
        try {
            return serializer.JSON();
        }
        catch (JsonSerializationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SerializableEntity deserialize(String s) throws IllegalAccessException, ClassNotFoundException, InstantiationException, JsonDeserializationException {
        SerializableEntityDeserializer deserializer = new SerializableEntityDeserializer();
        SerializableEntity serializable = SerializableEntityDeserializer.deserialize(s);
        return serializable;
    }

    @Test
    public void withEntitySerializableCollectionTest() throws IllegalAccessException, InstantiationException, ClassNotFoundException, JsonDeserializationException {
        WithSerializableEntityCollection source = this.createWithEntitySerializableCollection();
        String json = DeSerializationTest.serialize(source);
        WithSerializableEntityCollection deserialized = (WithSerializableEntityCollection)DeSerializationTest.deserialize(json);
        Assert.assertEquals(source.entityserializables.get(0).getClass(), WithPrimitiveCollection.class);
        Assert.assertEquals(source.entityserializables.get(1).getClass(), WithPrimitiveCollection.class);
    }

    @Test
    public void testDefaultSerializable() throws IllegalAccessException, InstantiationException, ClassNotFoundException, JsonDeserializationException {
        ChildSerializableEntity root = new ChildSerializableEntity();
        ChildSerializableEntity child = new ChildSerializableEntity();
        root.setPrimitive("root");
        root.addChild(child);
        child.setParent(root);
        child.setPrimitive("child");
        String json = DeSerializationTest.serialize(root);
        ChildSerializableEntity deserialized = (ChildSerializableEntity)DeSerializationTest.deserialize(json);
        Assert.assertEquals(root.getChildren().get(0).getPrimitive(), deserialized.getChildren().get(0).getPrimitive());
        Assert.assertEquals(root.getPrimitive(), deserialized.getPrimitive());
    }

    @Test
    public void listWithNull() throws ClassNotFoundException, InstantiationException, JsonDeserializationException, IllegalAccessException {
        WithSerializableEntityCollection original = new WithSerializableEntityCollection();
        original.entityserializables.add(null);
        original.entityserializables.add(null);
        original.entityserializables.add(new SimpleSerializableEntity());
        String json = DeSerializationTest.serialize(original);
        WithSerializableEntityCollection deserial = (WithSerializableEntityCollection)DeSerializationTest.deserialize(json);
        Assert.assertNull(original.entityserializables.get(0));
        Assert.assertNull(deserial.entityserializables.get(0));
        Assert.assertNull(original.entityserializables.get(1));
        Assert.assertNull(deserial.entityserializables.get(1));
        Assert.assertNotNull(original.entityserializables.get(2));
        Assert.assertNotNull(deserial.entityserializables.get(2));
    }

    @Test
    public void binary() throws ClassNotFoundException, InstantiationException, JsonDeserializationException, IllegalAccessException {
        BinarySerializableEntity binarySerializable = new BinarySerializableEntity();
        binarySerializable.setBinary(Base64.getEncoder().encode("binarybla".getBytes()));
        String json = DeSerializationTest.serialize(binarySerializable);
        BinarySerializableEntity decoded = (BinarySerializableEntity)DeSerializationTest.deserialize(json);
        int i = 0;
        while (i < binarySerializable.getBinary().length) {
            Assert.assertEquals(binarySerializable.getBinary()[i], decoded.getBinary()[i]);
            ++i;
        }
    }
}

